/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.common.Compatibility;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.operation.OperationImplicitParameterReader;

@Component
@Order(value=-2147482648)
public class OperationImplicitParametersReader
implements OperationBuilderPlugin {
    private final DescriptionResolver descriptions;

    @Autowired
    public OperationImplicitParametersReader(DescriptionResolver descriptions) {
        this.descriptions = descriptions;
    }

    @Override
    public void apply(OperationContext context) {
        List<Compatibility<Parameter, RequestParameter>> parameters = this.readParameters(context);
        context.operationBuilder().parameters(parameters.stream().map(Compatibility::getLegacy).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        context.operationBuilder().requestParameters(parameters.stream().map(Compatibility::getModern).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private List<Compatibility<Parameter, RequestParameter>> readParameters(OperationContext context) {
        List<ApiImplicitParams> annotations = context.findAllAnnotations(ApiImplicitParams.class);
        ArrayList<Compatibility<Parameter, RequestParameter>> parameters = new ArrayList<Compatibility<Parameter, RequestParameter>>();
        if (!annotations.isEmpty()) {
            for (ApiImplicitParams annotation : annotations) {
                for (ApiImplicitParam param : annotation.value()) {
                    parameters.add(OperationImplicitParameterReader.implicitParameter(this.descriptions, param));
                }
            }
        }
        return parameters;
    }
}

