/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.swagger2.mappers.EnumMapper;
import springfox.documentation.swagger2.mappers.Properties;
import springfox.documentation.swagger2.mappers.SerializableParameterFactory;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Deprecated
public class SerializableParameterFactories {
    private static final Map<String, SerializableParameterFactory> FACTORY_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, HeaderSerializableParameterFactory>("header", new HeaderSerializableParameterFactory()), new AbstractMap.SimpleEntry<String, FormSerializableParameterFactory>("form", new FormSerializableParameterFactory()), new AbstractMap.SimpleEntry<String, PathSerializableParameterFactory>("path", new PathSerializableParameterFactory()), new AbstractMap.SimpleEntry<String, QuerySerializableParameterFactory>("query", new QuerySerializableParameterFactory()), new AbstractMap.SimpleEntry<String, CookieSerializableParameterFactory>("cookie", new CookieSerializableParameterFactory())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    private static final VendorExtensionsMapper VENDOR_EXTENSIONS_MAPPER = new VendorExtensionsMapper();

    private SerializableParameterFactories() {
        throw new UnsupportedOperationException();
    }

    static Optional<Parameter> create(springfox.documentation.service.Parameter source) {
        String safeSourceParamType = Optional.ofNullable(source.getParamType()).map(String::toLowerCase).orElse("");
        SerializableParameterFactory factory = FACTORY_MAP.getOrDefault(safeSourceParamType, new NullSerializableParameterFactory());
        SerializableParameter toReturn = factory.create(source);
        if (toReturn == null) {
            return Optional.empty();
        }
        ModelReference paramModel = source.getModelRef();
        toReturn.setName(source.getName());
        toReturn.setDescription(source.getDescription());
        toReturn.setAccess(source.getParamAccess());
        toReturn.setPattern(source.getPattern());
        toReturn.setRequired(source.isRequired());
        toReturn.setAllowEmptyValue(source.isAllowEmptyValue());
        toReturn.getVendorExtensions().putAll(VENDOR_EXTENSIONS_MAPPER.mapExtensions(source.getVendorExtentions()));
        Property property = Properties.property(paramModel.getType());
        EnumMapper.maybeAddAllowableValuesToParameter(toReturn, property, source.getAllowableValues());
        if (paramModel.isCollection()) {
            if (paramModel.getItemType().equals("byte")) {
                toReturn.setType("string");
                toReturn.setFormat("byte");
            } else {
                toReturn.setCollectionFormat(SerializableParameterFactories.collectionFormat(source));
                toReturn.setType("array");
                ModelReference paramItemModelRef = paramModel.itemModel().orElseThrow(() -> new IllegalStateException("ModelRef that is a collection should have an itemModel"));
                Property itemProperty = EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty(paramItemModelRef), paramItemModelRef.getAllowableValues());
                toReturn.setItems(itemProperty);
                EnumMapper.maybeAddAllowableValuesToParameter(toReturn, itemProperty, paramItemModelRef.getAllowableValues());
            }
        } else if (paramModel.isMap()) {
            ModelReference paramItemModelRef = paramModel.itemModel().orElseThrow(() -> new IllegalStateException("ModelRef that is a map should have an itemModel"));
            MapProperty itemProperty = new MapProperty(Properties.itemTypeProperty(paramItemModelRef));
            toReturn.setItems(itemProperty);
        } else {
            ((AbstractSerializableParameter)toReturn).setDefaultValue(source.getDefaultValue());
            if (source.getScalarExample() != null) {
                ((AbstractSerializableParameter)toReturn).setExample(String.valueOf(source.getScalarExample()));
            }
            toReturn.setType(property.getType());
            toReturn.setFormat(property.getFormat());
        }
        return Optional.of(toReturn);
    }

    private static String collectionFormat(springfox.documentation.service.Parameter source) {
        return StringUtils.isEmpty(source.getCollectionFormat()) ? "multi" : source.getCollectionFormat();
    }

    static class NullSerializableParameterFactory
    implements SerializableParameterFactory {
        NullSerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            return null;
        }
    }

    static class QuerySerializableParameterFactory
    implements SerializableParameterFactory {
        QuerySerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            QueryParameter param = new QueryParameter();
            param.setDefaultValue(source.getDefaultValue());
            return param;
        }
    }

    static class PathSerializableParameterFactory
    implements SerializableParameterFactory {
        PathSerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            PathParameter param = new PathParameter();
            param.setDefaultValue(source.getDefaultValue());
            return param;
        }
    }

    static class HeaderSerializableParameterFactory
    implements SerializableParameterFactory {
        HeaderSerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            HeaderParameter param = new HeaderParameter();
            param.setDefaultValue(source.getDefaultValue());
            return param;
        }
    }

    static class FormSerializableParameterFactory
    implements SerializableParameterFactory {
        FormSerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            FormParameter param = new FormParameter();
            param.setDefaultValue(source.getDefaultValue());
            return param;
        }
    }

    static class CookieSerializableParameterFactory
    implements SerializableParameterFactory {
        CookieSerializableParameterFactory() {
        }

        @Override
        public SerializableParameter create(springfox.documentation.service.Parameter source) {
            CookieParameter param = new CookieParameter();
            param.setDefaultValue(source.getDefaultValue());
            return param;
        }
    }
}

