/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.lambda.civ;

import java.util.Map;
import java.util.stream.Collectors;
import tech.deepdreams.worker.api.context.DeductionBasisContext;
import tech.deepdreams.worker.api.context.DeductionContext;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.input.AdvantageInCash;
import tech.deepdreams.worker.input.AdvantageInKind;
import tech.deepdreams.worker.input.PayrollRequest;
import tech.deepdreams.worker.lambda.LambdaService;
import tech.deepdreams.worker.output.Deduction;
import tech.deepdreams.worker.output.PayrollResponse;

public class LambdaServicev2024Impl
implements LambdaService {
    @Override
    public String country() {
        return CountryCode.CIV.name();
    }

    @Override
    public int version() {
        return 2024;
    }

    @Override
    public PayrollResponse calculate(PayrollRequest request) {
        Map<String, Object> params = request.getAdvantagesInCash().stream().collect(Collectors.toMap(AdvantageInCash::getCode, AdvantageInCash::getValue));
        Map<String, Integer> advantagesInKind = request.getAdvantagesInKind().stream().collect(Collectors.toMap(AdvantageInKind::getCode, AdvantageInKind::getValue));
        params.put("185", request.getBranchId());
        params.put("186", request.getStateId());
        params.put("187", request.getLocalityId());
        params.put("200", params.getOrDefault("200", 0.0));
        DeductionBasisContext grossSalaryContext = new DeductionBasisContext(CountryCode.CIV, "300", 2020);
        Double grossSalary = grossSalaryContext.calculate(params, advantagesInKind);
        params.put("300", grossSalary);
        DeductionBasisContext taxableSalaryContext = new DeductionBasisContext(CountryCode.CIV, "305", 2020);
        Double taxableSalary = taxableSalaryContext.calculate(params, advantagesInKind);
        params.put("305", taxableSalary);
        DeductionBasisContext contribSalaryContext = new DeductionBasisContext(CountryCode.CIV, "306", 2020);
        Double contribSalary = contribSalaryContext.calculate(params, advantagesInKind);
        params.put("306", contribSalary);
        Double baseSalary = (Double)params.getOrDefault("200", 0.0);
        DeductionContext itsContext = new DeductionContext(CountryCode.CIV, "400", 2024);
        Double its = itsContext.calculateEmployee(params);
        params.put("403", its);
        DeductionContext cnpsContext = new DeductionContext(CountryCode.CIV, "420", 2020);
        Double cnpsSal = cnpsContext.calculateEmployee(params);
        Double cnpsPat = cnpsContext.calculateEmployer(params);
        DeductionContext accTravContext = new DeductionContext(CountryCode.CIV, "423", 2020);
        Double accTrav = accTravContext.calculateEmployer(params);
        DeductionContext allFamContext = new DeductionContext(CountryCode.CIV, "424", 2020);
        Double allFam = allFamContext.calculateEmployer(params);
        Double employeeDeductions = its + cnpsSal;
        Double employerDeductions = cnpsPat + accTrav + allFam;
        Double netSalary = grossSalary - employeeDeductions;
        PayrollResponse response = new PayrollResponse();
        response.setGrossSalary(grossSalary);
        response.setEmployeeDeductions(employeeDeductions);
        response.setEmployerDeductions(employerDeductions);
        response.setNetSalary(netSalary);
        response.addDeduction(new Deduction("400", "ITS", taxableSalary, its, 0.0));
        response.addDeduction(new Deduction("420", "CNPS", baseSalary, cnpsSal, cnpsPat));
        response.addDeduction(new Deduction("423", "Accident de travail", contribSalary, 0.0, accTrav));
        response.addDeduction(new Deduction("424", "Prestations familiales", contribSalary, 0.0, allFam));
        return response;
    }
}

