/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.lambda.cmr;

import java.util.Map;
import java.util.stream.Collectors;
import tech.deepdreams.worker.api.context.DeductionBasisContext;
import tech.deepdreams.worker.api.context.DeductionContext;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.input.AdvantageInCash;
import tech.deepdreams.worker.input.AdvantageInKind;
import tech.deepdreams.worker.input.PayrollRequest;
import tech.deepdreams.worker.lambda.LambdaService;
import tech.deepdreams.worker.output.Deduction;
import tech.deepdreams.worker.output.PayrollResponse;

public class LambdaServicev2004Impl
implements LambdaService {
    @Override
    public String country() {
        return CountryCode.CMR.name();
    }

    @Override
    public int version() {
        return 2004;
    }

    @Override
    public PayrollResponse calculate(PayrollRequest request) {
        Map<String, Object> params = request.getAdvantagesInCash().stream().collect(Collectors.toMap(AdvantageInCash::getCode, AdvantageInCash::getValue));
        Map<String, Integer> advantagesInKind = request.getAdvantagesInKind().stream().collect(Collectors.toMap(AdvantageInKind::getCode, AdvantageInKind::getValue));
        params.put("185", request.getBranchId());
        params.put("186", request.getStateId());
        params.put("187", request.getLocalityId());
        params.put("200", params.getOrDefault("200", 0.0));
        DeductionBasisContext grossSalaryContext = new DeductionBasisContext(CountryCode.CMR, "300", 2004);
        Double grossSalary = grossSalaryContext.calculate(params, advantagesInKind);
        params.put("300", grossSalary);
        DeductionBasisContext taxableSalaryContext = new DeductionBasisContext(CountryCode.CMR, "305", 2004);
        Double taxableSalary = taxableSalaryContext.calculate(params, advantagesInKind);
        params.put("305", taxableSalary);
        DeductionBasisContext contribSalaryContext = new DeductionBasisContext(CountryCode.CMR, "306", 2004);
        Double contribSalary = contribSalaryContext.calculate(params, advantagesInKind);
        params.put("306", contribSalary);
        Double baseSalary = (Double)params.getOrDefault("200", 0.0);
        DeductionContext irppContext = new DeductionContext(CountryCode.CMR, "400", 2004);
        Double irpp = irppContext.calculateEmployee(params);
        params.put("400", irpp);
        DeductionContext cacContext = new DeductionContext(CountryCode.CMR, "401", 2004);
        Double cac = cacContext.calculateEmployee(params);
        params.put("401", cac);
        DeductionContext ravContext = new DeductionContext(CountryCode.CMR, "403", 1989);
        Double rav = ravContext.calculateEmployee(params);
        DeductionContext tdlContext = new DeductionContext(CountryCode.CMR, "402", 1980);
        Double tdl = tdlContext.calculateEmployee(params);
        DeductionContext cfcSalContext = new DeductionContext(CountryCode.CMR, "404", 1977);
        Double cfcSal = cfcSalContext.calculateEmployee(params);
        DeductionContext cfcPatContext = new DeductionContext(CountryCode.CMR, "404", 1977);
        Double cfcPat = cfcPatContext.calculateEmployer(params);
        DeductionContext pvidSalContext = new DeductionContext(CountryCode.CMR, "420", 1974);
        Double pvidSal = pvidSalContext.calculateEmployee(params);
        DeductionContext pvidPatContext = new DeductionContext(CountryCode.CMR, "420", 1974);
        Double pvidPat = pvidPatContext.calculateEmployer(params);
        DeductionContext accTravContext = new DeductionContext(CountryCode.CMR, "423", 1977);
        Double accTrav = accTravContext.calculateEmployer(params);
        DeductionContext allFamContext = new DeductionContext(CountryCode.CMR, "424", 1973);
        Double allFam = allFamContext.calculateEmployer(params);
        DeductionContext fneContext = new DeductionContext(CountryCode.CMR, "425", 1990);
        Double fne = fneContext.calculateEmployer(params);
        Double employeeDeductions = irpp + cac + rav + tdl + cfcSal + pvidSal;
        Double employerDeductions = cfcPat + pvidPat + accTrav + allFam;
        Double netSalary = grossSalary - employeeDeductions;
        PayrollResponse response = new PayrollResponse();
        response.setGrossSalary(grossSalary);
        response.setEmployeeDeductions(employeeDeductions);
        response.setEmployerDeductions(employerDeductions);
        response.setNetSalary(netSalary);
        response.addDeduction(new Deduction("400", "IRPP", taxableSalary, irpp, 0.0));
        response.addDeduction(new Deduction("401", "CAC", irpp, cac, 0.0));
        response.addDeduction(new Deduction("403", "RAV", taxableSalary, rav, 0.0));
        response.addDeduction(new Deduction("402", "TDL", baseSalary, tdl, 0.0));
        response.addDeduction(new Deduction("404", "CFC", taxableSalary, cfcSal, cfcPat));
        response.addDeduction(new Deduction("420", "PVID", contribSalary, pvidSal, pvidPat));
        response.addDeduction(new Deduction("423", "Accident de travail", contribSalary, 0.0, accTrav));
        response.addDeduction(new Deduction("424", "Allocations familiales", contribSalary, 0.0, allFam));
        response.addDeduction(new Deduction("425", "FNE", taxableSalary, 0.0, fne));
        return response;
    }
}

