/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.lambda.gab;

import java.util.Map;
import java.util.stream.Collectors;
import tech.deepdreams.worker.api.context.DeductionBasisContext;
import tech.deepdreams.worker.api.context.DeductionContext;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.input.AdvantageInCash;
import tech.deepdreams.worker.input.AdvantageInKind;
import tech.deepdreams.worker.input.PayrollRequest;
import tech.deepdreams.worker.lambda.LambdaService;
import tech.deepdreams.worker.output.Deduction;
import tech.deepdreams.worker.output.PayrollResponse;

public class LambdaServicev2019Impl
implements LambdaService {
    @Override
    public String country() {
        return CountryCode.GAB.name();
    }

    @Override
    public int version() {
        return 2019;
    }

    @Override
    public PayrollResponse calculate(PayrollRequest request) {
        Map<String, Object> params = request.getAdvantagesInCash().stream().collect(Collectors.toMap(AdvantageInCash::getCode, AdvantageInCash::getValue));
        Map<String, Integer> advantagesInKind = request.getAdvantagesInKind().stream().collect(Collectors.toMap(AdvantageInKind::getCode, AdvantageInKind::getValue));
        params.put("185", request.getBranchId());
        params.put("186", request.getStateId());
        params.put("187", request.getLocalityId());
        params.put("200", params.getOrDefault("200", 0.0));
        DeductionBasisContext grossSalaryContext = new DeductionBasisContext(CountryCode.GAB, "300", 2020);
        Double grossSalary = grossSalaryContext.calculate(params, advantagesInKind);
        params.put("300", grossSalary);
        DeductionBasisContext taxableSalaryContext = new DeductionBasisContext(CountryCode.GAB, "305", 2020);
        Double taxableSalary = taxableSalaryContext.calculate(params, advantagesInKind);
        params.put("305", taxableSalary);
        DeductionBasisContext contribSalaryContext = new DeductionBasisContext(CountryCode.GAB, "306", 2020);
        Double contribSalary = contribSalaryContext.calculate(params, advantagesInKind);
        params.put("306", contribSalary);
        Double baseSalary = (Double)params.getOrDefault("200", 0.0);
        DeductionContext irppContext = new DeductionContext(CountryCode.GAB, "400", 2019);
        Double irpp = irppContext.calculateEmployee(params);
        params.put("400", irpp);
        DeductionContext tcsContext = new DeductionContext(CountryCode.GAB, "401", 2019);
        Double tcs = tcsContext.calculateEmployee(params);
        params.put("401", tcs);
        DeductionContext fnhContext = new DeductionContext(CountryCode.GAB, "402", 2019);
        Double fnh = fnhContext.calculateEmployer(params);
        DeductionContext cfpContext = new DeductionContext(CountryCode.GAB, "403", 2017);
        Double cfp = cfpContext.calculateEmployer(params);
        DeductionContext cnssContext = new DeductionContext(CountryCode.GAB, "420", 2016);
        Double cnssSal = cnssContext.calculateEmployee(params);
        Double cnssPat = cnssContext.calculateEmployer(params);
        DeductionContext cnamgsContext = new DeductionContext(CountryCode.GAB, "421", 2016);
        Double cnamgsSal = cnamgsContext.calculateEmployee(params);
        Double cnamgsPat = cnamgsContext.calculateEmployer(params);
        Double employeeDeductions = irpp + fnh + cfp + cnssSal + cnamgsSal;
        Double employerDeductions = cnssPat + cnamgsPat;
        Double netSalary = grossSalary - employeeDeductions;
        PayrollResponse response = new PayrollResponse();
        response.setGrossSalary(grossSalary);
        response.setEmployeeDeductions(employeeDeductions);
        response.setEmployerDeductions(employerDeductions);
        response.setNetSalary(netSalary);
        response.addDeduction(new Deduction("400", "IRPP", taxableSalary, irpp, 0.0));
        response.addDeduction(new Deduction("401", "TCS", taxableSalary, tcs, 0.0));
        response.addDeduction(new Deduction("402", "FNH", taxableSalary, 0.0, fnh));
        response.addDeduction(new Deduction("403", "CFP", taxableSalary, 0.0, cfp));
        response.addDeduction(new Deduction("420", "CNSS", baseSalary, cnamgsSal, cnamgsPat));
        response.addDeduction(new Deduction("420", "CNAMGS", baseSalary, cnssSal, cnssPat));
        return response;
    }
}

