/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.services.deduction;

import java.util.Arrays;
import java.util.Map;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.services.DeductionService;

public class IGRServicev2020Impl
implements DeductionService {
    private Double[] rangeArray = new Double[]{0.0, 25000.0, 45584.0, 81584.0, 126584.0, 220334.0, 389084.0, 842167.0, 9.9999999999E8};
    private String[] formulaArray = new String[]{"0", "BASE*10/110-2273*SHARES", "BASE*15/115-4076*SHARES", "BASE*20/120-7031*SHARES", "BASE*25/125-11250*SHARES", "BASE*35/135-24306*SHARES", "BASE*45/145-44181*SHARES", "BASE*60/160-98633*SHARES"};

    @Override
    public Double calculateEmployee(Map<String, Object> params) {
        Double shares = (Double)params.get("144");
        Double value = (Double)params.get("303");
        Double amountIS = (Double)params.get("400");
        Double amountCN = (Double)params.get("401");
        Double base = 0.85 * (0.8 * value - (amountIS + amountCN)) / shares;
        int rawIndex = Arrays.binarySearch((Object[])this.rangeArray, base);
        int index = Math.max(rawIndex >= 0 ? rawIndex - 1 : -1 * (rawIndex + 1) - 1, 0);
        String formula = this.formulaArray[index];
        String[] variables = new String[]{"BASE", "SHARES"};
        Expression expression = new ExpressionBuilder(formula).variables(variables).build();
        expression.setVariable("BASE", base);
        expression.setVariable("SHARES", shares);
        Double resultat = expression.evaluate();
        return Double.parseDouble(((Object)resultat).toString());
    }

    @Override
    public Double calculateEmployer(Map<String, Object> params) {
        return 0.0;
    }

    @Override
    public CountryCode country() {
        return CountryCode.CIV;
    }

    @Override
    public String code() {
        return "402";
    }

    @Override
    public int version() {
        return 2020;
    }
}

