/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.services.deduction;

import java.util.Arrays;
import java.util.Map;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import tech.deepdreams.worker.api.context.DeductionContext;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.services.DeductionService;

public class IRPPServicev2016Impl
implements DeductionService {
    private static final Double MIN_GROSS_TAXABLE_SALARY = 62000.0;
    private Double[] rangeArray = new Double[]{0.0, 166666.67, 250000.0, 416666.67, 9.9999999999E8};
    private String[] formulaArray = new String[]{"0.1*BASE", "16666.67+0.15*(BASE-166666.67)", "29166.67+0.25*(BASE-250000.00)", "70833.34+0.35*(BASE-416666.67)"};

    @Override
    public Double calculateEmployee(Map<String, Object> params) {
        Double value = (Double)params.get("305");
        if (value <= MIN_GROSS_TAXABLE_SALARY) {
            return 0.0;
        }
        DeductionContext context = new DeductionContext(CountryCode.CMR, "420", 2016);
        Double base = value * 0.7 - context.calculateEmployee(params) - 41666.666666666664;
        int rawIndex = Arrays.binarySearch((Object[])this.rangeArray, base);
        int index = Math.max(rawIndex >= 0 ? rawIndex - 1 : -1 * (rawIndex + 1) - 1, 0);
        String formula = this.formulaArray[index];
        String[] variables = new String[]{"BASE"};
        Expression expression = new ExpressionBuilder(formula).variables(variables).build();
        expression.setVariable("BASE", base);
        Double resultat = expression.evaluate();
        return Double.parseDouble(((Object)resultat).toString());
    }

    @Override
    public Double calculateEmployer(Map<String, Object> params) {
        return 0.0;
    }

    @Override
    public CountryCode country() {
        return CountryCode.CMR;
    }

    @Override
    public String code() {
        return "400";
    }

    @Override
    public int version() {
        return 2016;
    }
}

