/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.services.deductionbasis;

import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.services.DeductionBasisService;

public class GrossTaxableSalaryv2024Impl
implements DeductionBasisService {
    private static final String[] PROFESIONAL_FEES_ITEMS = new String[]{"210", "214", "217", "221", "224", "234", "235", "238"};
    private static final String[] EXCEPTIONAL_INCOMES = new String[]{"330", "332", "333", "334", "335"};
    private static final String[] ADVANTAGES_IN_KIND = new String[]{"370", "371", "372", "373", "374", "375", "376", "377", "378", "379"};
    private static final String[] INDEMNITIES_IN_KIND = new String[]{"233", "239", "245", "246", "247", "248", "249", "250", "251", "252"};

    @Override
    public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
        Double taxableSalary = params.entrySet().stream().filter(entry -> {
            int key = Integer.parseInt((String)entry.getKey());
            boolean all = key >= 200 && key <= 369;
            return all && !Arrays.asList(PROFESIONAL_FEES_ITEMS).contains(entry.getKey()) && !Arrays.asList(INDEMNITIES_IN_KIND).contains(entry.getKey());
        }).mapToDouble(entry -> Double.parseDouble(entry.getValue().toString())).sum();
        return taxableSalary + advantagesInKind.entrySet().stream().filter(entry -> Arrays.asList(ADVANTAGES_IN_KIND).contains(entry.getKey())).mapToDouble(entry -> switch ((String)entry.getKey()) {
            case "370" -> 0.15 * taxableSalary;
            case "372" -> 0.04 * taxableSalary;
            case "371" -> 0.02 * taxableSalary;
            case "373" -> {
                Double vehicles = Double.parseDouble(((Integer)entry.getValue()).toString());
                yield 0.1 * vehicles * taxableSalary;
            }
            case "374" -> {
                Double domestics = Double.parseDouble(((Integer)entry.getValue()).toString());
                yield 0.05 * domestics * taxableSalary;
            }
            case "375" -> 0.1 * taxableSalary;
            case "376" -> 0.05 * taxableSalary;
            case "377" -> 0.1 * taxableSalary;
            case "378" -> 0.05 * taxableSalary;
            case "379" -> 0.05 * taxableSalary;
            default -> 0.0;
        }).sum();
    }

    @Override
    public CountryCode country() {
        return CountryCode.CMR;
    }

    @Override
    public String code() {
        return "305";
    }

    @Override
    public int version() {
        return 2024;
    }
}

