/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.services.report;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import tech.deepdreams.worker.api.dtos.ConstantValueDTO;
import tech.deepdreams.worker.api.dtos.DeductionItemDTO;
import tech.deepdreams.worker.api.dtos.EmployeeDTO;
import tech.deepdreams.worker.api.dtos.PayPeriodDTO;
import tech.deepdreams.worker.api.dtos.PayslipDTO;
import tech.deepdreams.worker.api.dtos.ReportDTO;
import tech.deepdreams.worker.api.dtos.SubscriberDTO;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.enums.FormatType;
import tech.deepdreams.worker.api.enums.ReportType;
import tech.deepdreams.worker.api.services.ReportGeneratorService;
import tech.deepdreams.worker.services.report.HeaderFooterPageEvent;

public class ContributionsPdfGeneratorServiceImpl
implements ReportGeneratorService {
    private static final Logger log = Logger.getLogger(ContributionsPdfGeneratorServiceImpl.class);
    private DecimalFormat amountFormatter = new DecimalFormat("##,###");

    @Override
    public CountryCode country() {
        return CountryCode.CMR;
    }

    @Override
    public ReportType getReportType() {
        return ReportType.COTISATIONS;
    }

    @Override
    public FormatType getFormatType() {
        return FormatType.PDF;
    }

    @Override
    public ReportDTO generate(SubscriberDTO subscriber, PayPeriodDTO payPeriod, List<PayslipDTO> payslips) {
        try {
            String fs = System.getProperty("file.separator");
            String folderName = System.getProperty("user.home");
            String fileName = "cotisations_CNPS_" + subscriber.getLabel() + "_" + payPeriod.getStartDate().format(DateTimeFormatter.ofPattern("ddMMyyyy")) + "_" + payPeriod.getEndDate().format(DateTimeFormatter.ofPattern("ddMMyyyy")) + ".pdf";
            ReportDTO reportDTO = new ReportDTO();
            reportDTO.setFileName(fileName);
            reportDTO.setDocumentType("PDF");
            Document document = new Document(PageSize.A4.rotate());
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(folderName + fs + fileName));
            HeaderFooterPageEvent event = new HeaderFooterPageEvent();
            writer.setPageEvent(event);
            document.open();
            PdfPTable titleTable = new PdfPTable(1);
            titleTable.setHorizontalAlignment(1);
            titleTable.setSpacingBefore(30.0f);
            Phrase titlePhrase = new Phrase("ETAT DES COTISATIONS", new Font(Font.FontFamily.TIMES_ROMAN, 16.0f, 1));
            PdfPCell titleCell = new PdfPCell(titlePhrase);
            titleCell.setBorder(0);
            titleCell.setHorizontalAlignment(1);
            titleTable.addCell(titleCell);
            PdfPCell subTitle1Cell = new PdfPCell(new Phrase("CNPS", new Font(Font.FontFamily.TIMES_ROMAN, 16.0f, 0)));
            subTitle1Cell.setHorizontalAlignment(1);
            subTitle1Cell.setBorder(0);
            titleTable.addCell(subTitle1Cell);
            document.add(titleTable);
            PdfPTable headerTable = new PdfPTable(4);
            headerTable.setHorizontalAlignment(1);
            headerTable.setSpacingBefore(20.0f);
            headerTable.setWidthPercentage(90.0f);
            Phrase labelLabelPhrase = new Phrase("Nom de l'employeur", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell labelLabelCell = new PdfPCell(labelLabelPhrase);
            labelLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            labelLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(labelLabelCell);
            Phrase labelPhrase = new Phrase(subscriber.getLabel(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell labelCell = new PdfPCell(labelPhrase);
            labelCell.setHorizontalAlignment(0);
            headerTable.addCell(labelCell);
            Phrase regNumberLabelPhrase = new Phrase("P\u00e9riode de paie", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell regNumberLabelCell = new PdfPCell(regNumberLabelPhrase);
            regNumberLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            regNumberLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(regNumberLabelCell);
            Phrase regNumberPhrase = new Phrase(payPeriod.getStartDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " - " + payPeriod.getEndDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell regNumberCell = new PdfPCell(regNumberPhrase);
            regNumberCell.setHorizontalAlignment(1);
            headerTable.addCell(regNumberCell);
            Phrase secNumberLabelPhrase = new Phrase("Num\u00e9ro CNPS", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell secNumberLabelCell = new PdfPCell(secNumberLabelPhrase);
            secNumberLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            secNumberLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(secNumberLabelCell);
            Phrase secNumberPhrase = new Phrase(subscriber.getSocialRegistrationNumber(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell secNumberCell = new PdfPCell(secNumberPhrase);
            secNumberCell.setHorizontalAlignment(0);
            headerTable.addCell(secNumberCell);
            Phrase numberLabelPhrase = new Phrase("Effectif", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell numberLabelCell = new PdfPCell(numberLabelPhrase);
            numberLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            numberLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(numberLabelCell);
            Phrase numberValPhrase = new Phrase(String.valueOf(payslips.size()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell numberValCell = new PdfPCell(numberValPhrase);
            numberValCell.setHorizontalAlignment(1);
            headerTable.addCell(numberValCell);
            document.add(headerTable);
            PdfPTable bodyTable = new PdfPTable(9);
            bodyTable.setSpacingBefore(20.0f);
            bodyTable.setHorizontalAlignment(1);
            bodyTable.setWidthPercentage(100.0f);
            bodyTable.setWidths(new float[]{5.0f, 30.0f, 20.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
            PdfPCell numLabCell = new PdfPCell(new Phrase("N\u00b0", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            numLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            numLabCell.setHorizontalAlignment(1);
            numLabCell.setVerticalAlignment(5);
            numLabCell.setRowspan(2);
            bodyTable.addCell(numLabCell);
            PdfPCell nameLabCell = new PdfPCell(new Phrase("Nom et Pr\u00e9nom", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            nameLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            nameLabCell.setHorizontalAlignment(1);
            nameLabCell.setVerticalAlignment(5);
            nameLabCell.setRowspan(2);
            bodyTable.addCell(nameLabCell);
            PdfPCell regNumberLabCell = new PdfPCell(new Phrase("Num\u00e9ro CNPS", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            regNumberLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            regNumberLabCell.setHorizontalAlignment(1);
            regNumberLabCell.setVerticalAlignment(5);
            regNumberLabCell.setRowspan(2);
            bodyTable.addCell(regNumberLabCell);
            PdfPCell baseLabCell = new PdfPCell(new Phrase("Salaire Cotisable", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            baseLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            baseLabCell.setHorizontalAlignment(1);
            baseLabCell.setVerticalAlignment(5);
            baseLabCell.setRowspan(2);
            bodyTable.addCell(baseLabCell);
            PdfPCell pvidLabCell = new PdfPCell(new Phrase("PVID", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            pvidLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            pvidLabCell.setHorizontalAlignment(1);
            pvidLabCell.setVerticalAlignment(5);
            pvidLabCell.setColspan(2);
            bodyTable.addCell(pvidLabCell);
            PdfPCell accTravLabCell = new PdfPCell(new Phrase("Accident de travail", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            accTravLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            accTravLabCell.setHorizontalAlignment(1);
            accTravLabCell.setVerticalAlignment(5);
            accTravLabCell.setRowspan(2);
            bodyTable.addCell(accTravLabCell);
            PdfPCell allFamLabCell = new PdfPCell(new Phrase("Allocations familiales", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            allFamLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            allFamLabCell.setHorizontalAlignment(1);
            allFamLabCell.setVerticalAlignment(5);
            allFamLabCell.setRowspan(2);
            bodyTable.addCell(allFamLabCell);
            PdfPCell totalLabCell = new PdfPCell(new Phrase("Total", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            totalLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            totalLabCell.setHorizontalAlignment(1);
            totalLabCell.setVerticalAlignment(5);
            totalLabCell.setRowspan(2);
            bodyTable.addCell(totalLabCell);
            PdfPCell pvidSalLabCell = new PdfPCell(new Phrase("Salarial", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            pvidSalLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            pvidSalLabCell.setHorizontalAlignment(1);
            pvidSalLabCell.setVerticalAlignment(5);
            bodyTable.addCell(pvidSalLabCell);
            PdfPCell pvidPatLabCell = new PdfPCell(new Phrase("Patronal", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            pvidPatLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            pvidPatLabCell.setHorizontalAlignment(1);
            pvidPatLabCell.setVerticalAlignment(5);
            bodyTable.addCell(pvidPatLabCell);
            for (int index = 0; index < payslips.size(); ++index) {
                PayslipDTO payslip = payslips.get(index);
                PdfPCell _numCell = new PdfPCell(new Phrase(String.valueOf(index + 1), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _numCell.setHorizontalAlignment(1);
                bodyTable.addCell(_numCell);
                EmployeeDTO employee = payslip.getEmployee();
                PdfPCell _nameCell = new PdfPCell(new Phrase(employee.getLastName() + " " + employee.getFirstName(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _nameCell.setHorizontalAlignment(0);
                bodyTable.addCell(_nameCell);
                PdfPCell _secNumberCell = new PdfPCell(new Phrase(employee.getSocialSecurityNumber(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _secNumberCell.setHorizontalAlignment(1);
                bodyTable.addCell(_secNumberCell);
                ConstantValueDTO contribSalaryValue = payslip.getConstantValues().stream().filter(constantValue -> "306".equals(constantValue.getConstant().getCode())).findAny().orElseThrow();
                PdfPCell _contribCell = new PdfPCell(new Phrase(this.amountFormatter.format(contribSalaryValue.getValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _contribCell.setHorizontalAlignment(2);
                bodyTable.addCell(_contribCell);
                DeductionItemDTO pvidDeduct = payslip.getDeductionItems().stream().filter(item -> "420".equals(item.getElement().getCode())).findAny().orElseThrow();
                PdfPCell _pvidSalCell = new PdfPCell(new Phrase(this.amountFormatter.format(pvidDeduct.getEmployeeAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _pvidSalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_pvidSalCell);
                PdfPCell _pvidPatCell = new PdfPCell(new Phrase(this.amountFormatter.format(pvidDeduct.getEmployerAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _pvidPatCell.setHorizontalAlignment(2);
                bodyTable.addCell(_pvidPatCell);
                DeductionItemDTO accTravDeduct = payslip.getDeductionItems().stream().filter(item -> "423".equals(item.getElement().getCode())).findAny().orElseThrow();
                PdfPCell _accTravCell = new PdfPCell(new Phrase(this.amountFormatter.format(accTravDeduct.getEmployerAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _accTravCell.setHorizontalAlignment(2);
                bodyTable.addCell(_accTravCell);
                DeductionItemDTO allFamDeduct = payslip.getDeductionItems().stream().filter(item -> "424".equals(item.getElement().getCode())).findAny().orElseThrow();
                PdfPCell _allFamCell = new PdfPCell(new Phrase(this.amountFormatter.format(allFamDeduct.getEmployerAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _allFamCell.setHorizontalAlignment(2);
                bodyTable.addCell(_allFamCell);
                PdfPCell _totalCell = new PdfPCell(new Phrase(this.amountFormatter.format(pvidDeduct.getEmployeeAmount().doubleValue() + pvidDeduct.getEmployerAmount().doubleValue() + accTravDeduct.getEmployerAmount().doubleValue() + allFamDeduct.getEmployerAmount().doubleValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _totalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_totalCell);
            }
            document.add(bodyTable);
            document.close();
            return reportDTO;
        }
        catch (Exception e) {
            log.log(Level.ERROR, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

