/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.services.report;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import tech.deepdreams.worker.api.dtos.EmployeeDTO;
import tech.deepdreams.worker.api.dtos.PayPeriodDTO;
import tech.deepdreams.worker.api.dtos.PayslipDTO;
import tech.deepdreams.worker.api.dtos.ReportDTO;
import tech.deepdreams.worker.api.dtos.SubscriberDTO;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.enums.FormatType;
import tech.deepdreams.worker.api.enums.ReportType;
import tech.deepdreams.worker.api.services.ReportGeneratorService;
import tech.deepdreams.worker.services.report.HeaderFooterPageEvent;

public class PaymentOrderPdfGeneratorServiceImpl
implements ReportGeneratorService {
    private static final Logger log = Logger.getLogger(PaymentOrderPdfGeneratorServiceImpl.class);
    private DecimalFormat amountFormatter = new DecimalFormat("##,###");

    @Override
    public CountryCode country() {
        return CountryCode.CMR;
    }

    @Override
    public ReportType getReportType() {
        return ReportType.VIREMENT;
    }

    @Override
    public FormatType getFormatType() {
        return FormatType.PDF;
    }

    @Override
    public ReportDTO generate(SubscriberDTO subscriber, PayPeriodDTO payPeriod, List<PayslipDTO> payslips) {
        try {
            String fs = System.getProperty("file.separator");
            String folderName = System.getProperty("user.home");
            String fileName = "ordre_virement_" + subscriber.getLabel() + "_" + payPeriod.getStartDate().format(DateTimeFormatter.ofPattern("ddMMyyyy")) + "_" + payPeriod.getEndDate().format(DateTimeFormatter.ofPattern("ddMMyyyy")) + ".pdf";
            ReportDTO reportDTO = new ReportDTO();
            reportDTO.setFileName(fileName);
            reportDTO.setDocumentType("PDF");
            Document document = new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(folderName + fs + fileName));
            HeaderFooterPageEvent event = new HeaderFooterPageEvent();
            writer.setPageEvent(event);
            document.open();
            PdfPTable titleTable = new PdfPTable(1);
            titleTable.setHorizontalAlignment(1);
            titleTable.setSpacingBefore(30.0f);
            Phrase titlePhrase = new Phrase("ORDRE DE VIREMENT", new Font(Font.FontFamily.TIMES_ROMAN, 16.0f, 1));
            PdfPCell titleCell = new PdfPCell(titlePhrase);
            titleCell.setBorder(0);
            titleCell.setHorizontalAlignment(1);
            titleTable.addCell(titleCell);
            PdfPCell subTitle1Cell = new PdfPCell(new Phrase(payPeriod.getStartDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " - " + payPeriod.getEndDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), new Font(Font.FontFamily.TIMES_ROMAN, 12.0f, 0)));
            subTitle1Cell.setHorizontalAlignment(1);
            subTitle1Cell.setBorder(0);
            titleTable.addCell(subTitle1Cell);
            document.add(titleTable);
            PdfPTable headerTable = new PdfPTable(4);
            headerTable.setHorizontalAlignment(1);
            headerTable.setSpacingBefore(20.0f);
            headerTable.setWidthPercentage(90.0f);
            Phrase labelLabelPhrase = new Phrase("Nom de l'employeur", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell labelLabelCell = new PdfPCell(labelLabelPhrase);
            labelLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            labelLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(labelLabelCell);
            Phrase labelPhrase = new Phrase(subscriber.getLabel(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell labelCell = new PdfPCell(labelPhrase);
            labelCell.setHorizontalAlignment(0);
            headerTable.addCell(labelCell);
            Phrase regNumberLabelPhrase = new Phrase("P\u00e9riode de paie", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell regNumberLabelCell = new PdfPCell(regNumberLabelPhrase);
            regNumberLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            regNumberLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(regNumberLabelCell);
            Phrase regNumberPhrase = new Phrase(payPeriod.getStartDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " - " + payPeriod.getEndDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell regNumberCell = new PdfPCell(regNumberPhrase);
            regNumberCell.setHorizontalAlignment(1);
            headerTable.addCell(regNumberCell);
            Phrase bankLabelPhrase = new Phrase("Banque", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell bankLabelCell = new PdfPCell(bankLabelPhrase);
            bankLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            bankLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(bankLabelCell);
            Phrase bankValuePhrase = new Phrase(subscriber.getBank().getLabel(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell bankValueCell = new PdfPCell(bankValuePhrase);
            bankValueCell.setHorizontalAlignment(1);
            headerTable.addCell(bankValueCell);
            Phrase bankAccountLabelPhrase = new Phrase("Compte bancaire", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell bankAccountLabelCell = new PdfPCell(bankAccountLabelPhrase);
            bankAccountLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            bankAccountLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(bankAccountLabelCell);
            Phrase bankAccountValuePhrase = new Phrase(subscriber.getBank().getCode() + " " + subscriber.getBankAccountNumber() + " " + subscriber.getBankAccountKey(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell bankAccountValueCell = new PdfPCell(bankAccountValuePhrase);
            bankAccountValueCell.setHorizontalAlignment(1);
            headerTable.addCell(bankAccountValueCell);
            document.add(headerTable);
            PdfPTable bodyTable = new PdfPTable(4);
            bodyTable.setSpacingBefore(20.0f);
            bodyTable.setHorizontalAlignment(1);
            bodyTable.setWidthPercentage(100.0f);
            bodyTable.setWidths(new float[]{5.0f, 30.0f, 25.0f, 15.0f});
            PdfPCell numLabCell = new PdfPCell(new Phrase("N\u00b0", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            numLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            numLabCell.setHorizontalAlignment(1);
            numLabCell.setVerticalAlignment(5);
            bodyTable.addCell(numLabCell);
            PdfPCell nameLabCell = new PdfPCell(new Phrase("Nom et Pr\u00e9nom", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            nameLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            nameLabCell.setHorizontalAlignment(1);
            nameLabCell.setVerticalAlignment(5);
            bodyTable.addCell(nameLabCell);
            PdfPCell bankAccountLabCell = new PdfPCell(new Phrase("Compte bancaire", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            bankAccountLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            bankAccountLabCell.setHorizontalAlignment(1);
            bankAccountLabCell.setVerticalAlignment(5);
            bodyTable.addCell(bankAccountLabCell);
            PdfPCell netSalaryLabCell = new PdfPCell(new Phrase("Salaire net", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            netSalaryLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            netSalaryLabCell.setHorizontalAlignment(1);
            netSalaryLabCell.setVerticalAlignment(5);
            bodyTable.addCell(netSalaryLabCell);
            BigDecimal total = BigDecimal.ZERO;
            for (int index = 0; index < payslips.size(); ++index) {
                PayslipDTO payslip = payslips.get(index);
                PdfPCell _numCell = new PdfPCell(new Phrase(String.valueOf(index + 1), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _numCell.setHorizontalAlignment(1);
                bodyTable.addCell(_numCell);
                EmployeeDTO employee = payslip.getEmployee();
                PdfPCell _nameCell = new PdfPCell(new Phrase(employee.getLastName() + " " + employee.getFirstName(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _nameCell.setHorizontalAlignment(0);
                bodyTable.addCell(_nameCell);
                PdfPCell _bankAccountCell = new PdfPCell(new Phrase(employee.getBankAccountNumber(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _bankAccountCell.setHorizontalAlignment(1);
                bodyTable.addCell(_bankAccountCell);
                PdfPCell _totalCell = new PdfPCell(new Phrase(this.amountFormatter.format(payslip.getNetSalary().doubleValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _totalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_totalCell);
                total = total.add(payslip.getNetSalary());
            }
            document.add(bodyTable);
            PdfPTable totalTable = new PdfPTable(2);
            totalTable.setSpacingBefore(10.0f);
            totalTable.setHorizontalAlignment(2);
            totalTable.setWidthPercentage(50.0f);
            totalTable.setWidths(new float[]{30.0f, 20.0f});
            PdfPCell netLabelCell = new PdfPCell(new Phrase("Montant total".toUpperCase(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            netLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            netLabelCell.setHorizontalAlignment(1);
            totalTable.addCell(netLabelCell);
            PdfPCell netCell = new PdfPCell(new Phrase(this.amountFormatter.format(total.doubleValue()), new Font(Font.FontFamily.TIMES_ROMAN, 13.0f, 1)));
            netCell.setHorizontalAlignment(2);
            totalTable.addCell(netCell);
            document.add(totalTable);
            document.close();
            return reportDTO;
        }
        catch (Exception e) {
            log.log(Level.ERROR, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

