/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.worker.services.report;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import tech.deepdreams.worker.api.dtos.BenefitItemDTO;
import tech.deepdreams.worker.api.dtos.ConstantValueDTO;
import tech.deepdreams.worker.api.dtos.DeductionItemDTO;
import tech.deepdreams.worker.api.dtos.EmployeeDTO;
import tech.deepdreams.worker.api.dtos.PayPeriodDTO;
import tech.deepdreams.worker.api.dtos.PayslipDTO;
import tech.deepdreams.worker.api.dtos.ReportDTO;
import tech.deepdreams.worker.api.dtos.SubscriberDTO;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.api.enums.FormatType;
import tech.deepdreams.worker.api.enums.ReportType;
import tech.deepdreams.worker.api.services.ReportGeneratorService;
import tech.deepdreams.worker.services.report.HeaderFooterPageEvent;

public class TaxesPdfGeneratorServiceImpl
implements ReportGeneratorService {
    private static final Logger log = Logger.getLogger(TaxesPdfGeneratorServiceImpl.class);
    private DecimalFormat amountFormatter = new DecimalFormat("##,###");

    @Override
    public CountryCode country() {
        return CountryCode.CMR;
    }

    @Override
    public ReportType getReportType() {
        return ReportType.TAXES;
    }

    @Override
    public FormatType getFormatType() {
        return FormatType.PDF;
    }

    @Override
    public ReportDTO generate(SubscriberDTO subscriber, PayPeriodDTO payPeriod, List<PayslipDTO> payslips) {
        try {
            String fs = System.getProperty("file.separator");
            String folderName = System.getProperty("user.home");
            String fileName = "taxes_" + subscriber.getLabel() + "_" + payPeriod.getStartDate().format(DateTimeFormatter.ofPattern("ddMMyyyy")) + "_" + payPeriod.getEndDate().format(DateTimeFormatter.ofPattern("ddMMyyyy")) + ".pdf";
            ReportDTO reportDTO = new ReportDTO();
            reportDTO.setFileName(fileName);
            reportDTO.setDocumentType("PDF");
            Document document = new Document(PageSize.A4.rotate());
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(folderName + fs + fileName));
            HeaderFooterPageEvent event = new HeaderFooterPageEvent();
            writer.setPageEvent(event);
            document.open();
            PdfPTable titleTable = new PdfPTable(1);
            titleTable.setHorizontalAlignment(1);
            titleTable.setSpacingBefore(30.0f);
            Phrase titlePhrase = new Phrase("ETAT DES TAXES", new Font(Font.FontFamily.TIMES_ROMAN, 16.0f, 1));
            PdfPCell titleCell = new PdfPCell(titlePhrase);
            titleCell.setBorder(0);
            titleCell.setHorizontalAlignment(1);
            titleTable.addCell(titleCell);
            PdfPCell subTitle1Cell = new PdfPCell(new Phrase("SUR SALAIRE", new Font(Font.FontFamily.TIMES_ROMAN, 12.0f, 1)));
            subTitle1Cell.setHorizontalAlignment(1);
            subTitle1Cell.setBorder(0);
            titleTable.addCell(subTitle1Cell);
            document.add(titleTable);
            PdfPTable headerTable = new PdfPTable(4);
            headerTable.setHorizontalAlignment(1);
            headerTable.setSpacingBefore(20.0f);
            headerTable.setWidthPercentage(90.0f);
            Phrase labelLabelPhrase = new Phrase("Nom de l'employeur", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell labelLabelCell = new PdfPCell(labelLabelPhrase);
            labelLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            labelLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(labelLabelCell);
            Phrase labelPhrase = new Phrase(subscriber.getLabel(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell labelCell = new PdfPCell(labelPhrase);
            labelCell.setHorizontalAlignment(0);
            headerTable.addCell(labelCell);
            Phrase regNumberLabelPhrase = new Phrase("P\u00e9riode de paie", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1));
            PdfPCell regNumberLabelCell = new PdfPCell(regNumberLabelPhrase);
            regNumberLabelCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            regNumberLabelCell.setHorizontalAlignment(0);
            headerTable.addCell(regNumberLabelCell);
            Phrase regNumberPhrase = new Phrase(payPeriod.getStartDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " - " + payPeriod.getEndDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0));
            PdfPCell regNumberCell = new PdfPCell(regNumberPhrase);
            regNumberCell.setHorizontalAlignment(1);
            headerTable.addCell(regNumberCell);
            document.add(headerTable);
            PdfPTable bodyTable = new PdfPTable(11);
            bodyTable.setSpacingBefore(20.0f);
            bodyTable.setHorizontalAlignment(1);
            bodyTable.setWidthPercentage(100.0f);
            bodyTable.setWidths(new float[]{5.0f, 30.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
            PdfPCell numLabCell = new PdfPCell(new Phrase("N\u00b0", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            numLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            numLabCell.setHorizontalAlignment(1);
            numLabCell.setVerticalAlignment(5);
            numLabCell.setRowspan(2);
            bodyTable.addCell(numLabCell);
            PdfPCell nameLabCell = new PdfPCell(new Phrase("Nom et Pr\u00e9nom", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            nameLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            nameLabCell.setHorizontalAlignment(1);
            nameLabCell.setVerticalAlignment(5);
            nameLabCell.setRowspan(2);
            bodyTable.addCell(nameLabCell);
            PdfPCell baseLabCell = new PdfPCell(new Phrase("Salaire de base", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            baseLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            baseLabCell.setHorizontalAlignment(1);
            baseLabCell.setVerticalAlignment(5);
            baseLabCell.setRowspan(2);
            bodyTable.addCell(baseLabCell);
            PdfPCell taxableSalLabCell = new PdfPCell(new Phrase("Salaire taxable", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            taxableSalLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            taxableSalLabCell.setHorizontalAlignment(1);
            taxableSalLabCell.setVerticalAlignment(5);
            taxableSalLabCell.setRowspan(2);
            bodyTable.addCell(taxableSalLabCell);
            PdfPCell irppLabCell = new PdfPCell(new Phrase("IRPP", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            irppLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            irppLabCell.setHorizontalAlignment(1);
            irppLabCell.setVerticalAlignment(5);
            irppLabCell.setRowspan(2);
            bodyTable.addCell(irppLabCell);
            PdfPCell cacLabCell = new PdfPCell(new Phrase("CAC", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            cacLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            cacLabCell.setHorizontalAlignment(1);
            cacLabCell.setVerticalAlignment(5);
            cacLabCell.setRowspan(2);
            bodyTable.addCell(cacLabCell);
            PdfPCell ravLabCell = new PdfPCell(new Phrase("RAV", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            ravLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            ravLabCell.setHorizontalAlignment(1);
            ravLabCell.setVerticalAlignment(5);
            ravLabCell.setRowspan(2);
            bodyTable.addCell(ravLabCell);
            PdfPCell tdlLabCell = new PdfPCell(new Phrase("TDL", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            tdlLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            tdlLabCell.setHorizontalAlignment(1);
            tdlLabCell.setVerticalAlignment(5);
            tdlLabCell.setRowspan(2);
            bodyTable.addCell(tdlLabCell);
            PdfPCell cfcLabCell = new PdfPCell(new Phrase("CFC", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            cfcLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            cfcLabCell.setHorizontalAlignment(1);
            cfcLabCell.setVerticalAlignment(5);
            cfcLabCell.setColspan(2);
            bodyTable.addCell(cfcLabCell);
            PdfPCell fneLabCell = new PdfPCell(new Phrase("FNE", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            fneLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            fneLabCell.setHorizontalAlignment(1);
            fneLabCell.setVerticalAlignment(5);
            fneLabCell.setRowspan(2);
            bodyTable.addCell(fneLabCell);
            PdfPCell cfcSalLabCell = new PdfPCell(new Phrase("Salarial", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            cfcSalLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            cfcSalLabCell.setHorizontalAlignment(1);
            cfcSalLabCell.setVerticalAlignment(5);
            bodyTable.addCell(cfcSalLabCell);
            PdfPCell cfcPatLabCell = new PdfPCell(new Phrase("Patronal", new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 1)));
            cfcPatLabCell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            cfcPatLabCell.setHorizontalAlignment(1);
            cfcPatLabCell.setVerticalAlignment(5);
            bodyTable.addCell(cfcPatLabCell);
            for (int index = 0; index < payslips.size(); ++index) {
                PayslipDTO payslip = payslips.get(index);
                PdfPCell _numCell = new PdfPCell(new Phrase(String.valueOf(index + 1), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _numCell.setHorizontalAlignment(1);
                bodyTable.addCell(_numCell);
                EmployeeDTO employee = payslip.getEmployee();
                PdfPCell _nameCell = new PdfPCell(new Phrase(employee.getLastName() + " " + employee.getFirstName(), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _nameCell.setHorizontalAlignment(0);
                bodyTable.addCell(_nameCell);
                BenefitItemDTO baseSalBenefit = payslip.getBenefitItems().stream().filter(item -> "200".equals(item.getElement().getCode())).findAny().orElseThrow();
                PdfPCell _baseSalCell = new PdfPCell(new Phrase(this.amountFormatter.format(baseSalBenefit.getAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _baseSalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_baseSalCell);
                ConstantValueDTO taxableSalaryValue = payslip.getConstantValues().stream().filter(constantValue -> "305".equals(constantValue.getConstant().getCode())).findAny().orElseThrow();
                PdfPCell _taxableCell = new PdfPCell(new Phrase(this.amountFormatter.format(taxableSalaryValue.getValue()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _taxableCell.setHorizontalAlignment(2);
                bodyTable.addCell(_taxableCell);
                DeductionItemDTO irppDeduct = payslip.getDeductionItems().stream().filter(item -> "400".equals(item.getElement().getCode())).findAny().orElseThrow();
                PdfPCell _irppSalCell = new PdfPCell(new Phrase(this.amountFormatter.format(irppDeduct.getEmployeeAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _irppSalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_irppSalCell);
                DeductionItemDTO cacDeduct = payslip.getDeductionItems().stream().filter(item -> "401".equals(item.getElement().getCode())).findAny().orElseThrow();
                PdfPCell _cacSalCell = new PdfPCell(new Phrase(this.amountFormatter.format(cacDeduct.getEmployeeAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _cacSalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_cacSalCell);
                DeductionItemDTO ravDeduct = payslip.getDeductionItems().stream().filter(item -> "403".equals(item.getElement().getCode())).findAny().orElseThrow();
                PdfPCell _ravSalCell = new PdfPCell(new Phrase(this.amountFormatter.format(ravDeduct.getEmployeeAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _ravSalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_ravSalCell);
                DeductionItemDTO tdlDeduct = payslip.getDeductionItems().stream().filter(item -> "402".equals(item.getElement().getCode())).findAny().orElseThrow();
                PdfPCell _tdlSalCell = new PdfPCell(new Phrase(this.amountFormatter.format(tdlDeduct.getEmployeeAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _tdlSalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_tdlSalCell);
                DeductionItemDTO cfcDeduct = payslip.getDeductionItems().stream().filter(item -> "404".equals(item.getElement().getCode())).findAny().orElseThrow();
                PdfPCell _cfcSalCell = new PdfPCell(new Phrase(this.amountFormatter.format(cfcDeduct.getEmployeeAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _cfcSalCell.setHorizontalAlignment(2);
                bodyTable.addCell(_cfcSalCell);
                PdfPCell _cfcPatCell = new PdfPCell(new Phrase(this.amountFormatter.format(cfcDeduct.getEmployerAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _cfcPatCell.setHorizontalAlignment(2);
                bodyTable.addCell(_cfcPatCell);
                DeductionItemDTO fneDeduct = payslip.getDeductionItems().stream().filter(item -> "425".equals(item.getElement().getCode())).findAny().orElseThrow();
                PdfPCell _fnePatCell = new PdfPCell(new Phrase(this.amountFormatter.format(fneDeduct.getEmployerAmount()), new Font(Font.FontFamily.TIMES_ROMAN, 11.0f, 0)));
                _fnePatCell.setHorizontalAlignment(2);
                bodyTable.addCell(_fnePatCell);
            }
            document.add(bodyTable);
            document.close();
            return reportDTO;
        }
        catch (Exception e) {
            log.log(Level.ERROR, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

