/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package tech.figure.eventstream.stream.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import tech.figure.eventstream.stream.models.DialResp
import tech.figure.eventstream.stream.models.ErrorResponse

import com.squareup.moshi.Json

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import tech.figure.eventstream.stream.infrastructure.ApiClient
import tech.figure.eventstream.stream.infrastructure.ApiResponse
import tech.figure.eventstream.stream.infrastructure.ClientException
import tech.figure.eventstream.stream.infrastructure.ClientError
import tech.figure.eventstream.stream.infrastructure.ServerException
import tech.figure.eventstream.stream.infrastructure.ServerError
import tech.figure.eventstream.stream.infrastructure.MultiValueMap
import tech.figure.eventstream.stream.infrastructure.PartConfig
import tech.figure.eventstream.stream.infrastructure.RequestConfig
import tech.figure.eventstream.stream.infrastructure.RequestMethod
import tech.figure.eventstream.stream.infrastructure.ResponseType
import tech.figure.eventstream.stream.infrastructure.Success
import tech.figure.eventstream.stream.infrastructure.toMultiValue

class UnsafeApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://rpc.cosmos.network")
        }
    }

    /**
     * Add Peers/Persistent Peers (unsafe)
     * Set a persistent peer, this route in under unsafe, and has to manually enabled to use.  **Example:** curl &#39;localhost:26657/dial_peers?peers&#x3D;\\[\&quot;f9baeaa15fedf5e1ef7448dd60f46c01f1a9e9c4@1.2.3.4:26656\&quot;,\&quot;0491d373a8e0fcf1023aaf18c51d6a1d0d4f31bd@5.6.7.8:26656\&quot;\\]&amp;persistent&#x3D;false&#39; 
     * @param persistent Have the peers you are dialing be persistent (optional)
     * @param unconditional Have the peers you are dialing be unconditional (optional)
     * @param `private` Have the peers you are dialing be private (optional)
     * @param peers array of peers to dial (optional)
     * @return DialResp
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun dialPeers(persistent: kotlin.Boolean? = null, unconditional: kotlin.Boolean? = null, `private`: kotlin.Boolean? = null, peers: kotlin.collections.List<kotlin.String>? = null) : DialResp = withContext(Dispatchers.IO) {
        val localVarResponse = dialPeersWithHttpInfo(persistent = persistent, unconditional = unconditional, `private` = `private`, peers = peers)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as DialResp
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Add Peers/Persistent Peers (unsafe)
     * Set a persistent peer, this route in under unsafe, and has to manually enabled to use.  **Example:** curl &#39;localhost:26657/dial_peers?peers&#x3D;\\[\&quot;f9baeaa15fedf5e1ef7448dd60f46c01f1a9e9c4@1.2.3.4:26656\&quot;,\&quot;0491d373a8e0fcf1023aaf18c51d6a1d0d4f31bd@5.6.7.8:26656\&quot;\\]&amp;persistent&#x3D;false&#39; 
     * @param persistent Have the peers you are dialing be persistent (optional)
     * @param unconditional Have the peers you are dialing be unconditional (optional)
     * @param `private` Have the peers you are dialing be private (optional)
     * @param peers array of peers to dial (optional)
     * @return ApiResponse<DialResp?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun dialPeersWithHttpInfo(persistent: kotlin.Boolean?, unconditional: kotlin.Boolean?, `private`: kotlin.Boolean?, peers: kotlin.collections.List<kotlin.String>?) : ApiResponse<DialResp?> = withContext(Dispatchers.IO) {
        val localVariableConfig = dialPeersRequestConfig(persistent = persistent, unconditional = unconditional, `private` = `private`, peers = peers)

        return@withContext request<Unit, DialResp>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation dialPeers
     *
     * @param persistent Have the peers you are dialing be persistent (optional)
     * @param unconditional Have the peers you are dialing be unconditional (optional)
     * @param `private` Have the peers you are dialing be private (optional)
     * @param peers array of peers to dial (optional)
     * @return RequestConfig
     */
    fun dialPeersRequestConfig(persistent: kotlin.Boolean?, unconditional: kotlin.Boolean?, `private`: kotlin.Boolean?, peers: kotlin.collections.List<kotlin.String>?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (persistent != null) {
                    put("persistent", listOf(persistent.toString()))
                }
                if (unconditional != null) {
                    put("unconditional", listOf(unconditional.toString()))
                }
                if (`private` != null) {
                    put("private", listOf(`private`.toString()))
                }
                if (peers != null) {
                    put("peers", toMultiValue(peers.toList(), "multi"))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/dial_peers",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Dial Seeds (Unsafe)
     * Dial a peer, this route in under unsafe, and has to manually enabled to use    **Example:** curl &#39;localhost:26657/dial_seeds?seeds&#x3D;\\[\&quot;f9baeaa15fedf5e1ef7448dd60f46c01f1a9e9c4@1.2.3.4:26656\&quot;,\&quot;0491d373a8e0fcf1023aaf18c51d6a1d0d4f31bd@5.6.7.8:26656\&quot;\\]&#39; 
     * @param peers list of seed nodes to dial (optional)
     * @return DialResp
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun dialSeeds(peers: kotlin.collections.List<kotlin.String>? = null) : DialResp = withContext(Dispatchers.IO) {
        val localVarResponse = dialSeedsWithHttpInfo(peers = peers)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as DialResp
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Dial Seeds (Unsafe)
     * Dial a peer, this route in under unsafe, and has to manually enabled to use    **Example:** curl &#39;localhost:26657/dial_seeds?seeds&#x3D;\\[\&quot;f9baeaa15fedf5e1ef7448dd60f46c01f1a9e9c4@1.2.3.4:26656\&quot;,\&quot;0491d373a8e0fcf1023aaf18c51d6a1d0d4f31bd@5.6.7.8:26656\&quot;\\]&#39; 
     * @param peers list of seed nodes to dial (optional)
     * @return ApiResponse<DialResp?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun dialSeedsWithHttpInfo(peers: kotlin.collections.List<kotlin.String>?) : ApiResponse<DialResp?> = withContext(Dispatchers.IO) {
        val localVariableConfig = dialSeedsRequestConfig(peers = peers)

        return@withContext request<Unit, DialResp>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation dialSeeds
     *
     * @param peers list of seed nodes to dial (optional)
     * @return RequestConfig
     */
    fun dialSeedsRequestConfig(peers: kotlin.collections.List<kotlin.String>?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (peers != null) {
                    put("peers", toMultiValue(peers.toList(), "multi"))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/dial_seeds",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
