/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package tech.figure.eventstream.stream.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import tech.figure.eventstream.stream.models.EmptyResponse
import tech.figure.eventstream.stream.models.ErrorResponse

import com.squareup.moshi.Json

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import tech.figure.eventstream.stream.infrastructure.ApiClient
import tech.figure.eventstream.stream.infrastructure.ApiResponse
import tech.figure.eventstream.stream.infrastructure.ClientException
import tech.figure.eventstream.stream.infrastructure.ClientError
import tech.figure.eventstream.stream.infrastructure.ServerException
import tech.figure.eventstream.stream.infrastructure.ServerError
import tech.figure.eventstream.stream.infrastructure.MultiValueMap
import tech.figure.eventstream.stream.infrastructure.PartConfig
import tech.figure.eventstream.stream.infrastructure.RequestConfig
import tech.figure.eventstream.stream.infrastructure.RequestMethod
import tech.figure.eventstream.stream.infrastructure.ResponseType
import tech.figure.eventstream.stream.infrastructure.Success
import tech.figure.eventstream.stream.infrastructure.toMultiValue

class WebsocketApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://rpc.cosmos.network")
        }
    }

    /**
     * Subscribe for events via WebSocket.
     * To tell which events you want, you need to provide a query. query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot; AND \&quot;EXISTS\&quot;. operand can be a string (escaped with single quotes), number, date or time.  Examples:       tm.event &#x3D; &#39;NewBlock&#39;               # new blocks       tm.event &#x3D; &#39;CompleteProposal&#39;       # node got a complete proposal       tm.event &#x3D; &#39;Tx&#39; AND tx.hash &#x3D; &#39;XYZ&#39; # single transaction       tm.event &#x3D; &#39;Tx&#39; AND tx.height &#x3D; 5   # all txs of the fifth block       tx.height &#x3D; 5                       # all txs of the fifth block  Tendermint provides a few predefined keys: tm.event, tx.hash and tx.height. Note for transactions, you can define additional keys by providing events with DeliverTx response.  import (     abci \&quot;github.com/tendermint/tendermint/abci/types\&quot;     \&quot;github.com/tendermint/tendermint/libs/pubsub/query\&quot; )  abci.ResponseDeliverTx{   Events: []abci.Event{       {           Type: \&quot;rewards.withdraw\&quot;,           Attributes: abci.EventAttribute{               {Key: []byte(\&quot;address\&quot;), Value: []byte(\&quot;AddrA\&quot;), Index: true},               {Key: []byte(\&quot;source\&quot;), Value: []byte(\&quot;SrcX\&quot;), Index: true},               {Key: []byte(\&quot;amount\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},               {Key: []byte(\&quot;balance\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},           },       },       {           Type: \&quot;rewards.withdraw\&quot;,           Attributes: abci.EventAttribute{               {Key: []byte(\&quot;address\&quot;), Value: []byte(\&quot;AddrB\&quot;), Index: true},               {Key: []byte(\&quot;source\&quot;), Value: []byte(\&quot;SrcY\&quot;), Index: true},               {Key: []byte(\&quot;amount\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},               {Key: []byte(\&quot;balance\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},           },       },       {           Type: \&quot;transfer\&quot;,           Attributes: abci.EventAttribute{               {Key: []byte(\&quot;sender\&quot;), Value: []byte(\&quot;AddrC\&quot;), Index: true},               {Key: []byte(\&quot;recipient\&quot;), Value: []byte(\&quot;AddrD\&quot;), Index: true},               {Key: []byte(\&quot;amount\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},           },       },   }, }  All events are indexed by a composite key of the form {eventType}.{evenAttrKey}. In the above examples, the following keys would be indexed:    - rewards.withdraw.address    - rewards.withdraw.source    - rewards.withdraw.amount    - rewards.withdraw.balance    - transfer.sender    - transfer.recipient    - transfer.amount  Multiple event types with duplicate keys are allowed and are meant to categorize unique and distinct events. In the above example, all events indexed under the key &#x60;rewards.withdraw.address&#x60; will have the following values stored and queryable:     - AddrA    - AddrB  To create a query for txs where address AddrA withdrew rewards: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.address &#x3D; &#39;AddrA&#39;\&quot;)  To create a query for txs where address AddrA withdrew rewards from source Y: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.address &#x3D; &#39;AddrA&#39; AND rewards.withdraw.source &#x3D; &#39;Y&#39;\&quot;)  To create a query for txs where AddrA transferred funds: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND transfer.sender &#x3D; &#39;AddrA&#39;\&quot;)  The following queries would return no results: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND transfer.sender &#x3D; &#39;AddrZ&#39;\&quot;) query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.address &#x3D; &#39;AddrZ&#39;\&quot;) query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.source &#x3D; &#39;W&#39;\&quot;)  See list of all possible events here https://godoc.org/github.com/tendermint/tendermint/types#pkg-constants  For complete query syntax, check out https://godoc.org/github.com/tendermint/tendermint/libs/pubsub/query.  &#x60;&#x60;&#x60;go import rpchttp \&quot;github.com/tendermint/rpc/client/http\&quot; import \&quot;github.com/tendermint/tendermint/types\&quot;  client :&#x3D; rpchttp.New(\&quot;tcp:0.0.0.0:26657\&quot;, \&quot;/websocket\&quot;) err :&#x3D; client.Start() if err !&#x3D; nil {   handle error } defer client.Stop() ctx, cancel :&#x3D; context.WithTimeout(context.Background(), 1 * time.Second) defer cancel() query :&#x3D; \&quot;tm.event &#x3D; &#39;Tx&#39; AND tx.height &#x3D; 3\&quot; txs, err :&#x3D; client.Subscribe(ctx, \&quot;test-client\&quot;, query) if err !&#x3D; nil {   handle error }  go func() {  for e :&#x3D; range txs {    fmt.Println(\&quot;got \&quot;, e.Data.(types.EventDataTx))    } }() &#x60;&#x60;&#x60;  NOTE: if you&#39;re not reading events fast enough, Tendermint might terminate the subscription. 
     * @param query query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot;. operand can be a string (escaped with single quotes), number, date or time. 
     * @return EmptyResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun subscribe(query: kotlin.String) : EmptyResponse = withContext(Dispatchers.IO) {
        val localVarResponse = subscribeWithHttpInfo(query = query)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptyResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Subscribe for events via WebSocket.
     * To tell which events you want, you need to provide a query. query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot; AND \&quot;EXISTS\&quot;. operand can be a string (escaped with single quotes), number, date or time.  Examples:       tm.event &#x3D; &#39;NewBlock&#39;               # new blocks       tm.event &#x3D; &#39;CompleteProposal&#39;       # node got a complete proposal       tm.event &#x3D; &#39;Tx&#39; AND tx.hash &#x3D; &#39;XYZ&#39; # single transaction       tm.event &#x3D; &#39;Tx&#39; AND tx.height &#x3D; 5   # all txs of the fifth block       tx.height &#x3D; 5                       # all txs of the fifth block  Tendermint provides a few predefined keys: tm.event, tx.hash and tx.height. Note for transactions, you can define additional keys by providing events with DeliverTx response.  import (     abci \&quot;github.com/tendermint/tendermint/abci/types\&quot;     \&quot;github.com/tendermint/tendermint/libs/pubsub/query\&quot; )  abci.ResponseDeliverTx{   Events: []abci.Event{       {           Type: \&quot;rewards.withdraw\&quot;,           Attributes: abci.EventAttribute{               {Key: []byte(\&quot;address\&quot;), Value: []byte(\&quot;AddrA\&quot;), Index: true},               {Key: []byte(\&quot;source\&quot;), Value: []byte(\&quot;SrcX\&quot;), Index: true},               {Key: []byte(\&quot;amount\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},               {Key: []byte(\&quot;balance\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},           },       },       {           Type: \&quot;rewards.withdraw\&quot;,           Attributes: abci.EventAttribute{               {Key: []byte(\&quot;address\&quot;), Value: []byte(\&quot;AddrB\&quot;), Index: true},               {Key: []byte(\&quot;source\&quot;), Value: []byte(\&quot;SrcY\&quot;), Index: true},               {Key: []byte(\&quot;amount\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},               {Key: []byte(\&quot;balance\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},           },       },       {           Type: \&quot;transfer\&quot;,           Attributes: abci.EventAttribute{               {Key: []byte(\&quot;sender\&quot;), Value: []byte(\&quot;AddrC\&quot;), Index: true},               {Key: []byte(\&quot;recipient\&quot;), Value: []byte(\&quot;AddrD\&quot;), Index: true},               {Key: []byte(\&quot;amount\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},           },       },   }, }  All events are indexed by a composite key of the form {eventType}.{evenAttrKey}. In the above examples, the following keys would be indexed:    - rewards.withdraw.address    - rewards.withdraw.source    - rewards.withdraw.amount    - rewards.withdraw.balance    - transfer.sender    - transfer.recipient    - transfer.amount  Multiple event types with duplicate keys are allowed and are meant to categorize unique and distinct events. In the above example, all events indexed under the key &#x60;rewards.withdraw.address&#x60; will have the following values stored and queryable:     - AddrA    - AddrB  To create a query for txs where address AddrA withdrew rewards: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.address &#x3D; &#39;AddrA&#39;\&quot;)  To create a query for txs where address AddrA withdrew rewards from source Y: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.address &#x3D; &#39;AddrA&#39; AND rewards.withdraw.source &#x3D; &#39;Y&#39;\&quot;)  To create a query for txs where AddrA transferred funds: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND transfer.sender &#x3D; &#39;AddrA&#39;\&quot;)  The following queries would return no results: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND transfer.sender &#x3D; &#39;AddrZ&#39;\&quot;) query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.address &#x3D; &#39;AddrZ&#39;\&quot;) query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.source &#x3D; &#39;W&#39;\&quot;)  See list of all possible events here https://godoc.org/github.com/tendermint/tendermint/types#pkg-constants  For complete query syntax, check out https://godoc.org/github.com/tendermint/tendermint/libs/pubsub/query.  &#x60;&#x60;&#x60;go import rpchttp \&quot;github.com/tendermint/rpc/client/http\&quot; import \&quot;github.com/tendermint/tendermint/types\&quot;  client :&#x3D; rpchttp.New(\&quot;tcp:0.0.0.0:26657\&quot;, \&quot;/websocket\&quot;) err :&#x3D; client.Start() if err !&#x3D; nil {   handle error } defer client.Stop() ctx, cancel :&#x3D; context.WithTimeout(context.Background(), 1 * time.Second) defer cancel() query :&#x3D; \&quot;tm.event &#x3D; &#39;Tx&#39; AND tx.height &#x3D; 3\&quot; txs, err :&#x3D; client.Subscribe(ctx, \&quot;test-client\&quot;, query) if err !&#x3D; nil {   handle error }  go func() {  for e :&#x3D; range txs {    fmt.Println(\&quot;got \&quot;, e.Data.(types.EventDataTx))    } }() &#x60;&#x60;&#x60;  NOTE: if you&#39;re not reading events fast enough, Tendermint might terminate the subscription. 
     * @param query query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot;. operand can be a string (escaped with single quotes), number, date or time. 
     * @return ApiResponse<EmptyResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun subscribeWithHttpInfo(query: kotlin.String) : ApiResponse<EmptyResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = subscribeRequestConfig(query = query)

        return@withContext request<Unit, EmptyResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation subscribe
     *
     * @param query query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot;. operand can be a string (escaped with single quotes), number, date or time. 
     * @return RequestConfig
     */
    fun subscribeRequestConfig(query: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("query", listOf(query.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/subscribe",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Unsubscribe from event on Websocket
     * &#x60;&#x60;&#x60;go client :&#x3D; rpchttp.New(\&quot;tcp:0.0.0.0:26657\&quot;, \&quot;/websocket\&quot;) err :&#x3D; client.Start() if err !&#x3D; nil {    handle error } defer client.Stop() query :&#x3D; \&quot;tm.event &#x3D; &#39;Tx&#39; AND tx.height &#x3D; 3\&quot; err &#x3D; client.Unsubscribe(context.Background(), \&quot;test-client\&quot;, query) if err !&#x3D; nil {    handle error } &#x60;&#x60;&#x60; 
     * @param query query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot;. operand can be a string (escaped with single quotes), number, date or time. 
     * @return EmptyResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun unsubscribe(query: kotlin.String) : EmptyResponse = withContext(Dispatchers.IO) {
        val localVarResponse = unsubscribeWithHttpInfo(query = query)

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptyResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Unsubscribe from event on Websocket
     * &#x60;&#x60;&#x60;go client :&#x3D; rpchttp.New(\&quot;tcp:0.0.0.0:26657\&quot;, \&quot;/websocket\&quot;) err :&#x3D; client.Start() if err !&#x3D; nil {    handle error } defer client.Stop() query :&#x3D; \&quot;tm.event &#x3D; &#39;Tx&#39; AND tx.height &#x3D; 3\&quot; err &#x3D; client.Unsubscribe(context.Background(), \&quot;test-client\&quot;, query) if err !&#x3D; nil {    handle error } &#x60;&#x60;&#x60; 
     * @param query query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot;. operand can be a string (escaped with single quotes), number, date or time. 
     * @return ApiResponse<EmptyResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun unsubscribeWithHttpInfo(query: kotlin.String) : ApiResponse<EmptyResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = unsubscribeRequestConfig(query = query)

        return@withContext request<Unit, EmptyResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation unsubscribe
     *
     * @param query query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot;. operand can be a string (escaped with single quotes), number, date or time. 
     * @return RequestConfig
     */
    fun unsubscribeRequestConfig(query: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("query", listOf(query.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/unsubscribe",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Unsubscribe from all events via WebSocket
     * Unsubscribe from all events via WebSocket 
     * @return EmptyResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun unsubscribeAll() : EmptyResponse = withContext(Dispatchers.IO) {
        val localVarResponse = unsubscribeAllWithHttpInfo()

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptyResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Unsubscribe from all events via WebSocket
     * Unsubscribe from all events via WebSocket 
     * @return ApiResponse<EmptyResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    suspend fun unsubscribeAllWithHttpInfo() : ApiResponse<EmptyResponse?> = withContext(Dispatchers.IO) {
        val localVariableConfig = unsubscribeAllRequestConfig()

        return@withContext request<Unit, EmptyResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation unsubscribeAll
     *
     * @return RequestConfig
     */
    fun unsubscribeAllRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/unsubscribe_all",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
