/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.eventstream.stream.infrastructure;

import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.eventstream.stream.infrastructure.ApiAbstractionsKt;
import tech.figure.eventstream.stream.infrastructure.ApiClient;
import tech.figure.eventstream.stream.infrastructure.ApiResponse;
import tech.figure.eventstream.stream.infrastructure.ClientError;
import tech.figure.eventstream.stream.infrastructure.Informational;
import tech.figure.eventstream.stream.infrastructure.PartConfig;
import tech.figure.eventstream.stream.infrastructure.Redirection;
import tech.figure.eventstream.stream.infrastructure.RequestConfig;
import tech.figure.eventstream.stream.infrastructure.RequestMethod;
import tech.figure.eventstream.stream.infrastructure.ResponseExtensionsKt;
import tech.figure.eventstream.stream.infrastructure.Serializer;
import tech.figure.eventstream.stream.infrastructure.ServerError;
import tech.figure.eventstream.stream.infrastructure.Success;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0004J\u0012\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0004J\"\u0010\u0010\u001a\u00020\u0003\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u0002H\u0011H\u0084\b\u00a2\u0006\u0002\u0010\u0012J7\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00110\u0014\"\u0006\b\u0000\u0010\u0015\u0018\u0001\"\u0006\b\u0001\u0010\u0011\u0018\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0084H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J(\u0010\u0019\u001a\u00020\u001a\"\u0006\b\u0000\u0010\u0011\u0018\u00012\u0006\u0010\u001b\u001a\u0002H\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010\u001dJ.\u0010\u001e\u001a\u0004\u0018\u0001H\u0011\"\u0006\b\u0000\u0010\u0011\u0018\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Ltech/figure/eventstream/stream/infrastructure/ApiClient;", "", "baseUrl", "", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "getBaseUrl", "()Ljava/lang/String;", "getClient", "()Lokhttp3/OkHttpClient;", "guessContentTypeFromFile", "file", "Ljava/io/File;", "parameterToString", "value", "parseDateToQueryString", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "request", "Ltech/figure/eventstream/stream/infrastructure/ApiResponse;", "I", "requestConfig", "Ltech/figure/eventstream/stream/infrastructure/RequestConfig;", "(Ltech/figure/eventstream/stream/infrastructure/RequestConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requestBody", "Lokhttp3/RequestBody;", "content", "mediaType", "(Ljava/lang/Object;Ljava/lang/String;)Lokhttp3/RequestBody;", "responseBody", "body", "Lokhttp3/ResponseBody;", "(Lokhttp3/ResponseBody;Ljava/lang/String;)Ljava/lang/Object;", "Companion", "es-api-model"})
@SourceDebugExtension(value={"SMAP\nApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiClient.kt\ntech/figure/eventstream/stream/infrastructure/ApiClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,266:1\n74#1,9:276\n83#1,17:286\n100#1,6:304\n106#1,2:311\n108#1,15:314\n74#1,9:329\n83#1,17:339\n100#1,6:357\n106#1,2:364\n108#1,15:367\n74#1,9:382\n83#1,17:392\n100#1,6:410\n106#1,2:417\n108#1,15:420\n74#1,9:435\n83#1,17:445\n100#1,6:463\n106#1,2:470\n108#1,15:473\n126#1,23:501\n150#1,2:525\n263#1:527\n215#2,2:267\n215#2,2:269\n215#2:272\n216#2:275\n215#2:285\n216#2:303\n215#2:310\n216#2:313\n215#2:338\n216#2:356\n215#2:363\n216#2:366\n215#2:391\n216#2:409\n215#2:416\n216#2:419\n215#2:444\n216#2:462\n215#2:469\n216#2:472\n215#2,2:488\n29#3:271\n29#3:524\n1855#4,2:273\n314#5,11:490\n*S KotlinDebug\n*F\n+ 1 ApiClient.kt\ntech/figure/eventstream/stream/infrastructure/ApiClient\n*L\n190#1:276,9\n190#1:286,17\n190#1:304,6\n190#1:311,2\n190#1:314,15\n193#1:329,9\n193#1:339,17\n193#1:357,6\n193#1:364,2\n193#1:367,15\n194#1:382,9\n194#1:392,17\n194#1:410,6\n194#1:417,2\n194#1:420,15\n195#1:435,9\n195#1:445,17\n195#1:463,6\n195#1:470,2\n195#1:473,15\n228#1:501,23\n228#1:525,2\n252#1:527\n82#1:267,2\n105#1:269,2\n162#1:272\n162#1:275\n190#1:285\n190#1:303\n190#1:310\n190#1:313\n193#1:338\n193#1:356\n193#1:363\n193#1:366\n194#1:391\n194#1:409\n194#1:416\n194#1:419\n195#1:444\n195#1:462\n195#1:469\n195#1:472\n198#1:488,2\n148#1:271\n228#1:524\n163#1:273,2\n201#1:490,11\n*E\n"})
public class ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    protected static final String ContentType = "Content-Type";
    @NotNull
    protected static final String Accept = "Accept";
    @NotNull
    protected static final String Authorization = "Authorization";
    @NotNull
    protected static final String JsonMediaType = "application/json";
    @NotNull
    protected static final String FormDataMediaType = "multipart/form-data";
    @NotNull
    protected static final String FormUrlEncMediaType = "application/x-www-form-urlencoded";
    @NotNull
    protected static final String XmlMediaType = "application/xml";
    @NotNull
    protected static final String OctetMediaType = "application/octet-stream";
    @NotNull
    private static final Map<String, String> apiKey = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> apiKeyPrefix = new LinkedHashMap();
    @Nullable
    private static String username;
    @Nullable
    private static String password;
    @Nullable
    private static String accessToken;
    @NotNull
    public static final String baseUrlKey = "tech.figure.eventstream.stream.baseUrl";
    @NotNull
    private static final Lazy<OkHttpClient> defaultClient$delegate;
    @NotNull
    private static final OkHttpClient.Builder builder;

    public ApiClient(@NotNull String baseUrl, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.baseUrl = baseUrl;
        this.client = client;
    }

    public /* synthetic */ ApiClient(String string, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            okHttpClient = Companion.getDefaultClient();
        }
        this(string, okHttpClient);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @NotNull
    protected final String guessContentTypeFromFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        String string = contentType;
        if (string == null) {
            string = OctetMediaType;
        }
        return string;
    }

    protected final /* synthetic */ <T> RequestBody requestBody(T content, String mediaType) {
        RequestBody requestBody;
        boolean $i$f$requestBody = false;
        if (content instanceof File) {
            File file = (File)content;
            String string = mediaType;
            if (string == null) {
                string = this.guessContentTypeFromFile((File)content);
            }
            requestBody = RequestBody.Companion.create(file, MediaType.Companion.parse(string));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormDataMediaType)) {
            MultipartBody.Builder builder;
            MultipartBody.Builder $this$requestBody_u24lambda_u241 = builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            boolean bl = false;
            Intrinsics.checkNotNull(content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.figure.eventstream.stream.infrastructure.PartConfig<*>>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map partHeaders;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                String name = (String)entry.getKey();
                PartConfig part = (PartConfig)entry.getValue();
                if (part.getBody() instanceof File) {
                    partHeaders = MapsKt.plus((Map)MapsKt.toMutableMap(part.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name + "\"; filename=\"" + ((File)part.getBody()).getName() + "\"")));
                    MediaType fileMediaType = MediaType.Companion.parse(this.guessContentTypeFromFile((File)part.getBody()));
                    $this$requestBody_u24lambda_u241.addPart(Headers.Companion.of(partHeaders), RequestBody.Companion.create((File)part.getBody(), fileMediaType));
                    continue;
                }
                partHeaders = MapsKt.plus((Map)MapsKt.toMutableMap(part.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name + "\"")));
                $this$requestBody_u24lambda_u241.addPart(Headers.Companion.of(partHeaders), RequestBody.Companion.create(this.parameterToString(part.getBody()), null));
            }
            requestBody = (RequestBody)builder.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormUrlEncMediaType)) {
            FormBody.Builder builder;
            FormBody.Builder $this$requestBody_u24lambda_u243 = builder = new FormBody.Builder(null, 1, null);
            boolean bl = false;
            Intrinsics.checkNotNull(content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.figure.eventstream.stream.infrastructure.PartConfig<*>>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl3 = false;
                String name = (String)entry.getKey();
                PartConfig part = (PartConfig)entry.getValue();
                $this$requestBody_u24lambda_u243.add(name, this.parameterToString(part.getBody()));
            }
            requestBody = (RequestBody)builder.build();
        } else if (mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            if (content == null) {
                requestBody = Util.EMPTY_REQUEST;
            } else {
                Moshi moshi2 = Serializer.getMoshi();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string = moshi2.adapter(Object.class).toJson(content);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                String string2 = mediaType;
                if (string2 == null) {
                    string2 = JsonMediaType;
                }
                requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(string2));
            }
        } else {
            if (Intrinsics.areEqual((Object)mediaType, (Object)XmlMediaType)) {
                throw new UnsupportedOperationException("xml not currently supported.");
            }
            if (Intrinsics.areEqual((Object)mediaType, (Object)OctetMediaType) && content instanceof byte[]) {
                requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content), (MediaType)MediaType.Companion.parse(OctetMediaType), (int)0, (int)0, (int)6, null);
            } else {
                throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
            }
        }
        return requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final /* synthetic */ <T> T responseBody(ResponseBody body, String mediaType) {
        Object object;
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File tempFile = Files.createTempFile("tmp.tech.figure.eventstream.stream", null, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            Closeable closeable = body.byteStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)tempFile);
                Closeable closeable2 = new FileOutputStream(tempFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream tempFileOutputStream = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)tempFileOutputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)tempFile;
        }
        if (mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            String bodyContent = body.string();
            if (((CharSequence)bodyContent).length() == 0) {
                return null;
            }
            Moshi $this$adapter$iv = Serializer.getMoshi();
            boolean $i$f$adapter = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            object = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)OctetMediaType)) {
            byte[] byArray = body.bytes();
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            object = byArray;
        } else {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object responseBody$default(ApiClient $this, ResponseBody body, String mediaType, int n, Object object) {
        Object object2;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: responseBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File tempFile = Files.createTempFile("tmp.tech.figure.eventstream.stream", null, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            Closeable closeable = body.byteStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)tempFile);
                Closeable closeable2 = new FileOutputStream(tempFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream tempFileOutputStream = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)tempFileOutputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return tempFile;
        }
        if (mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            String bodyContent = body.string();
            if (((CharSequence)bodyContent).length() == 0) {
                return null;
            }
            Moshi $this$adapter$iv = Serializer.getMoshi();
            boolean $i$f$adapter = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            object2 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)OctetMediaType)) {
            byte[] byArray = body.bytes();
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            object2 = byArray;
        } else {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final /* synthetic */ <I, T> Object request(RequestConfig<I> requestConfig, Continuation<? super ApiResponse<T>> $completion) {
        ApiResponse apiResponse;
        String string;
        Object object;
        String string2;
        Map.Entry<String, List<String>> element$iv;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl2 = httpUrl;
        Object object2 = new char[]{'/'};
        object2 = httpUrl2.newBuilder().addEncodedPathSegments(StringsKt.trimStart((String)requestConfig.getPath(), (char[])object2));
        Object $this$request_u24lambda_u248 = (HttpUrl.Builder)object2;
        boolean bl7 = false;
        Object $this$forEach$iv = requestConfig.getQuery();
        int $i$f$forEach = 0;
        Object object3 = $this$forEach$iv.entrySet().iterator();
        while (object3.hasNext()) {
            Map.Entry<String, List<String>> query = element$iv = object3.next();
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = query.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String queryValue = (String)element$iv2;
                boolean bl3 = false;
                $this$request_u24lambda_u248.addQueryParameter(query.getKey(), queryValue);
            }
        }
        HttpUrl url = ((HttpUrl.Builder)object2).build();
        if (requestConfig.getBody() != null) {
            object2 = requestConfig.getHeaders().get(ContentType);
            boolean bl4 = object2 == null || object2.length() == 0;
            if (bl4) {
                requestConfig.getHeaders().put(ContentType, JsonMediaType);
            }
        }
        object2 = requestConfig.getHeaders().get(Accept);
        boolean bl5 = object2 == null || object2.length() == 0;
        if (bl5) {
            requestConfig.getHeaders().put(Accept, JsonMediaType);
        }
        Map<String, String> headers = requestConfig.getHeaders();
        $this$request_u24lambda_u248 = headers.get(Accept);
        boolean bl6 = $this$request_u24lambda_u248 == null || $this$request_u24lambda_u248.length() == 0;
        if (bl6) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        if (headers.get(ContentType) != null) {
            String bl7 = headers.get(ContentType);
            Intrinsics.checkNotNull((Object)bl7, (String)"null cannot be cast to non-null type kotlin.String");
            bl7 = StringsKt.substringBefore$default((String)bl7, (String)";", null, (int)2, null);
            $this$forEach$iv = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"US");
            $this$forEach$iv = (Locale)$this$forEach$iv;
            String string3 = bl7.toLowerCase((Locale)$this$forEach$iv);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string2 = null;
        }
        String contentType = string2;
        $this$forEach$iv = requestConfig.getMethod();
        $i$f$forEach = WhenMappings.$EnumSwitchMapping$0[((Enum)$this$forEach$iv).ordinal()];
        $this$forEach$iv = switch ($i$f$forEach) {
            case 1 -> {
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv;
                RequestBody v7;
                ApiClient this_$iv;
                I content$iv;
                object3 = this;
                element$iv = requestConfig.getBody();
                Request.Builder var27_75 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File v5 = (File)content$iv;
                    String v6 = contentType;
                    if (v6 == null) {
                        v6 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v7 = RequestBody.Companion.create(v5, MediaType.Companion.parse(v6));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $this$requestBody_u24lambda_u241$iv = bl2;
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.figure.eventstream.stream.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        object = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)object.getKey();
                        part$iv = (PartConfig)object.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            $this$requestBody_u24lambda_u241$iv.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"")));
                        $this$requestBody_u24lambda_u241$iv.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    v7 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    $this$requestBody_u24lambda_u243$iv = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.figure.eventstream.stream.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        object = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)object.getKey();
                        part$iv = (PartConfig)object.getValue();
                        $this$requestBody_u24lambda_u243$iv.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v7 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v7 = Util.EMPTY_REQUEST;
                    } else {
                        Moshi v8 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v9 = v8.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"toJson(...)");
                        String v10 = contentType;
                        if (v10 == null) {
                            v10 = JsonMediaType;
                        }
                        v7 = RequestBody.Companion.create(v9, MediaType.Companion.parse(v10));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)OctetMediaType) && content$iv instanceof byte[]) {
                        v7 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv), (MediaType)MediaType.Companion.parse(OctetMediaType), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                RequestBody var28_84 = v7;
                yield var27_75.delete(var28_84);
            }
            case 2 -> new Request.Builder().url(url);
            case 3 -> new Request.Builder().url(url).head();
            case 4 -> {
                RequestBody v14;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder var27_75 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File v12 = (File)content$iv;
                    String v13 = contentType;
                    if (v13 == null) {
                        v13 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v14 = RequestBody.Companion.create(v12, MediaType.Companion.parse(v13));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $this$requestBody_u24lambda_u241$iv = bl2;
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.figure.eventstream.stream.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        object = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)object.getKey();
                        part$iv = (PartConfig)object.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            $this$requestBody_u24lambda_u241$iv.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"")));
                        $this$requestBody_u24lambda_u241$iv.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    v14 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    $this$requestBody_u24lambda_u243$iv = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.figure.eventstream.stream.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        object = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)object.getKey();
                        part$iv = (PartConfig)object.getValue();
                        $this$requestBody_u24lambda_u243$iv.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v14 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v14 = Util.EMPTY_REQUEST;
                    } else {
                        Moshi v15 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v16 = v15.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"toJson(...)");
                        String v17 = contentType;
                        if (v17 == null) {
                            v17 = JsonMediaType;
                        }
                        v14 = RequestBody.Companion.create(v16, MediaType.Companion.parse(v17));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)OctetMediaType) && content$iv instanceof byte[]) {
                        v14 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv), (MediaType)MediaType.Companion.parse(OctetMediaType), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                RequestBody var28_84 = v14;
                yield var27_75.patch(var28_84);
            }
            case 5 -> {
                RequestBody v20;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder var27_75 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File v18 = (File)content$iv;
                    String v19 = contentType;
                    if (v19 == null) {
                        v19 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v20 = RequestBody.Companion.create(v18, MediaType.Companion.parse(v19));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $this$requestBody_u24lambda_u241$iv = bl2;
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.figure.eventstream.stream.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        object = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)object.getKey();
                        part$iv = (PartConfig)object.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            $this$requestBody_u24lambda_u241$iv.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"")));
                        $this$requestBody_u24lambda_u241$iv.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    v20 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    $this$requestBody_u24lambda_u243$iv = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.figure.eventstream.stream.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        object = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)object.getKey();
                        part$iv = (PartConfig)object.getValue();
                        $this$requestBody_u24lambda_u243$iv.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v20 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v20 = Util.EMPTY_REQUEST;
                    } else {
                        Moshi v21 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v22 = v21.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"toJson(...)");
                        String v23 = contentType;
                        if (v23 == null) {
                            v23 = JsonMediaType;
                        }
                        v20 = RequestBody.Companion.create(v22, MediaType.Companion.parse(v23));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)OctetMediaType) && content$iv instanceof byte[]) {
                        v20 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv), (MediaType)MediaType.Companion.parse(OctetMediaType), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                RequestBody var28_84 = v20;
                yield var27_75.put(var28_84);
            }
            case 6 -> {
                RequestBody v26;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder var27_75 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File v24 = (File)content$iv;
                    String v25 = contentType;
                    if (v25 == null) {
                        v25 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v26 = RequestBody.Companion.create(v24, MediaType.Companion.parse(v25));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $this$requestBody_u24lambda_u241$iv = bl2;
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.figure.eventstream.stream.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        object = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)object.getKey();
                        part$iv = (PartConfig)object.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            $this$requestBody_u24lambda_u241$iv.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"")));
                        $this$requestBody_u24lambda_u241$iv.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    v26 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    $this$requestBody_u24lambda_u243$iv = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.figure.eventstream.stream.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        object = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)object.getKey();
                        part$iv = (PartConfig)object.getValue();
                        $this$requestBody_u24lambda_u243$iv.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v26 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v26 = Util.EMPTY_REQUEST;
                    } else {
                        Moshi v27 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v28 = v27.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"toJson(...)");
                        String v29 = contentType;
                        if (v29 == null) {
                            v29 = JsonMediaType;
                        }
                        v26 = RequestBody.Companion.create(v28, MediaType.Companion.parse(v29));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)OctetMediaType) && content$iv instanceof byte[]) {
                        v26 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv), (MediaType)MediaType.Companion.parse(OctetMediaType), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                RequestBody var28_84 = v26;
                yield var27_75.post(var28_84);
            }
            case 7 -> new Request.Builder().url(url).method("OPTIONS", null);
            default -> throw new NoWhenBranchMatchedException();
        };
        Request.Builder $this$request_u24lambda_u2410 = (Request.Builder)$this$forEach$iv;
        boolean bl8 = false;
        Map<String, String> $this$forEach$iv3 = headers;
        boolean $i$f$forEach3 = false;
        Iterator<Map.Entry<String, String>> bl2 = $this$forEach$iv3.entrySet().iterator();
        while (bl2.hasNext()) {
            Map.Entry<String, String> element$iv3;
            Map.Entry<String, String> header = element$iv3 = bl2.next();
            boolean bl9 = false;
            $this$request_u24lambda_u2410.addHeader(header.getKey(), header.getValue());
        }
        Request request2 = ((Request.Builder)$this$forEach$iv).build();
        boolean $i$f$suspendCancellableCoroutine = false;
        InlineMarker.mark((int)0);
        Object uCont$iv = $completion;
        boolean bl102 = false;
        Object cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        Object continuation = (CancellableContinuation)cancellable$iv;
        boolean bl112 = false;
        Object call = this.getClient().newCall(request2);
        continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(call){
            final /* synthetic */ Call $call;
            {
                this.$call = $call;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                this.$call.cancel();
            }
        });
        call.enqueue(new Callback((CancellableContinuation<? super Response>)continuation){
            final /* synthetic */ CancellableContinuation<Response> $continuation;
            {
                this.$continuation = $continuation;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)response2));
            }
        });
        Object object4 = cancellable$iv.getResult();
        if (object4 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        InlineMarker.mark((int)1);
        Response response2 = (Response)object4;
        uCont$iv = Response.header$default((Response)response2, (String)ContentType, null, (int)2, null);
        if (uCont$iv != null && (bl102 = StringsKt.substringBefore$default(uCont$iv, (String)";", null, (int)2, null)) != null) {
            cancellable$iv = bl102;
            continuation = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)continuation, (String)"US");
            continuation = (Locale)continuation;
            String string4 = ((String)cancellable$iv).toLowerCase((Locale)continuation);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept = string;
        if (response2.isRedirect()) {
            apiResponse = new Redirection(response2.code(), response2.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response2)) {
            apiResponse = new Informational(response2.message(), response2.code(), response2.headers().toMultimap());
        } else if (response2.isSuccessful()) {
            Object object5;
            void body$iv;
            uCont$iv = this;
            ResponseBody bl102 = response2.body();
            boolean $i$f$responseBody = false;
            if (body$iv == null) {
                object5 = null;
            } else {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                if (Intrinsics.areEqual(Object.class, File.class)) {
                    File tempFile$iv = Files.createTempFile("tmp.tech.figure.eventstream.stream", null, new FileAttribute[0]).toFile();
                    tempFile$iv.deleteOnExit();
                    Closeable bl112 = body$iv.byteStream();
                    call = null;
                    try {
                        InputStream inputStream$iv = (InputStream)bl112;
                        boolean bl12 = false;
                        Intrinsics.checkNotNull((Object)tempFile$iv);
                        Closeable closeable = new FileOutputStream(tempFile$iv);
                        Throwable throwable = null;
                        try {
                            FileOutputStream tempFileOutputStream$iv = (FileOutputStream)closeable;
                            boolean bl13 = false;
                            object = ByteStreamsKt.copyTo$default((InputStream)inputStream$iv, (OutputStream)tempFileOutputStream$iv, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            InlineMarker.finallyStart((int)1);
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            InlineMarker.finallyEnd((int)1);
                        }
                        Long l = ((Number)object).longValue();
                    }
                    catch (Throwable throwable) {
                        call = throwable;
                        throw throwable;
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        CloseableKt.closeFinally((Closeable)bl112, (Throwable)call);
                        InlineMarker.finallyEnd((int)1);
                    }
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                    object5 = tempFile$iv;
                } else if (accept == null || StringsKt.startsWith$default((String)accept, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept, (String)"json", (boolean)false, (int)2, null)) {
                    String bodyContent$iv = body$iv.string();
                    if (((CharSequence)bodyContent$iv).length() == 0) {
                        object5 = null;
                    } else {
                        Moshi $this$adapter$iv$iv = Serializer.getMoshi();
                        boolean $i$f$adapter = false;
                        Intrinsics.reifiedOperationMarker((int)6, (String)"T?");
                        object5 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv, null).fromJson(bodyContent$iv);
                    }
                } else if (Intrinsics.areEqual((Object)accept, (Object)OctetMediaType)) {
                    byte[] byArray = body$iv.bytes();
                    Intrinsics.reifiedOperationMarker((int)2, (String)"T?");
                    object5 = byArray;
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            Object object6 = object5;
            Map map = response2.headers().toMultimap();
            int n = response2.code();
            Object object7 = object6;
            apiResponse = new Success<Object>(object7, n, (Map<String, List<String>>)((Map<String, ? extends List<String>>)map));
        } else {
            ResponseBody responseBody;
            apiResponse = ResponseExtensionsKt.isClientError(response2) ? (ApiResponse)new ClientError(response2.message(), (responseBody = response2.body()) != null ? responseBody.string() : null, response2.code(), response2.headers().toMultimap()) : (ApiResponse)new ServerError(response2.message(), (responseBody = response2.body()) != null ? responseBody.string() : null, response2.code(), response2.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    protected final String parameterToString(@Nullable Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "";
        } else if (object instanceof Object[]) {
            string = ApiAbstractionsKt.toMultiValue$default((Object[])value, "csv", null, 4, null).toString();
        } else if (object instanceof Iterable) {
            string = ApiAbstractionsKt.toMultiValue$default((Iterable)value, "csv", null, 4, null).toString();
        } else if ((((object instanceof OffsetDateTime ? true : object instanceof OffsetTime) ? true : object instanceof LocalDateTime) ? true : object instanceof LocalDate) ? true : object instanceof LocalTime) {
            ApiClient this_$iv = this;
            boolean $i$f$parseDateToQueryString = false;
            String string2 = Serializer.getMoshi().adapter(Object.class).toJson(value);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
            string = StringsKt.replace$default((String)string2, (String)"\"", (String)"", (boolean)false, (int)4, null);
        } else {
            string = value.toString();
        }
        return string;
    }

    protected final /* synthetic */ <T> String parseDateToQueryString(T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        boolean $i$f$parseDateToQueryString = false;
        Moshi moshi2 = Serializer.getMoshi();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = moshi2.adapter(Object.class).toJson(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final OkHttpClient getDefaultClient() {
        return Companion.getDefaultClient();
    }

    @NotNull
    public static final OkHttpClient.Builder getBuilder() {
        return Companion.getBuilder();
    }

    static {
        defaultClient$delegate = LazyKt.lazy((Function0)Companion.defaultClient.2.INSTANCE);
        builder = new OkHttpClient.Builder();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\u00020\u001e8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u0012\u0004\b\u001f\u0010\u0002\u001a\u0004\b \u0010!R\u001c\u0010$\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000e\"\u0004\b&\u0010\u0010R\u001c\u0010'\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000e\"\u0004\b)\u0010\u0010\u00a8\u0006*"}, d2={"Ltech/figure/eventstream/stream/infrastructure/ApiClient$Companion;", "", "()V", "Accept", "", "Authorization", "ContentType", "FormDataMediaType", "FormUrlEncMediaType", "JsonMediaType", "OctetMediaType", "XmlMediaType", "accessToken", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "(Ljava/lang/String;)V", "apiKey", "", "getApiKey", "()Ljava/util/Map;", "apiKeyPrefix", "getApiKeyPrefix", "baseUrlKey", "builder", "Lokhttp3/OkHttpClient$Builder;", "getBuilder$annotations", "getBuilder", "()Lokhttp3/OkHttpClient$Builder;", "defaultClient", "Lokhttp3/OkHttpClient;", "getDefaultClient$annotations", "getDefaultClient", "()Lokhttp3/OkHttpClient;", "defaultClient$delegate", "Lkotlin/Lazy;", "password", "getPassword", "setPassword", "username", "getUsername", "setUsername", "es-api-model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getApiKey() {
            return apiKey;
        }

        @NotNull
        public final Map<String, String> getApiKeyPrefix() {
            return apiKeyPrefix;
        }

        @Nullable
        public final String getUsername() {
            return username;
        }

        public final void setUsername(@Nullable String string) {
            username = string;
        }

        @Nullable
        public final String getPassword() {
            return password;
        }

        public final void setPassword(@Nullable String string) {
            password = string;
        }

        @Nullable
        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(@Nullable String string) {
            accessToken = string;
        }

        @NotNull
        public final OkHttpClient getDefaultClient() {
            Lazy lazy = defaultClient$delegate;
            return (OkHttpClient)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultClient$annotations() {
        }

        @NotNull
        public final OkHttpClient.Builder getBuilder() {
            return builder;
        }

        @JvmStatic
        public static /* synthetic */ void getBuilder$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=176)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMethod.values().length];
            try {
                nArray[RequestMethod.DELETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.GET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.HEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.POST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.OPTIONS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

