/*
 * Decompiled with CFR 0.152.
 */
package tech.figure.hdwallet.bip32;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.KeyException;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.figure.hdwallet.bip32.AccountType;
import tech.figure.hdwallet.bip32.ConstantsKt;
import tech.figure.hdwallet.bip32.ExtKeyChainCode;
import tech.figure.hdwallet.bip32.ExtKeyFingerprint;
import tech.figure.hdwallet.bip32.ExtKeyVersion;
import tech.figure.hdwallet.bip32.MasterKeyKt;
import tech.figure.hdwallet.bip44.PathElement;
import tech.figure.hdwallet.bip44.PathElements;
import tech.figure.hdwallet.common.hashing.HashKt;
import tech.figure.hdwallet.ec.CompressionKt;
import tech.figure.hdwallet.ec.Curve;
import tech.figure.hdwallet.ec.CurveKt;
import tech.figure.hdwallet.ec.CurvePoint;
import tech.figure.hdwallet.ec.ECKeyPair;
import tech.figure.hdwallet.ec.PrivateKey;
import tech.figure.hdwallet.ec.PublicKey;
import tech.figure.hdwallet.ec.extensions.BigIntegerKt;
import tech.figure.hdwallet.ec.extensions.BytesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017B8\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u0014\u0010\u001c\u001a\u00020\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00020#0\"J\u0019\u0010$\u001a\u00020\u0003H\u00c6\u0003\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b%\u0010\u0010J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\u0019\u0010'\u001a\u00020\u0007H\u00c6\u0003\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b(\u0010\u0010J\t\u0010)\u001a\u00020\tH\u00c6\u0003J\u0019\u0010*\u001a\u00020\u000bH\u00c6\u0003\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010\u0010J\t\u0010,\u001a\u00020\rH\u00c6\u0003JR\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b.\u0010/J\u0013\u00100\u001a\u00020\u001f2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\tH\u00d6\u0001J\u0010\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\u001fJ\t\u00106\u001a\u00020!H\u00d6\u0001R\u001c\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u001a\u0010\u0010R\u001c\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u001b\u0010\u0010\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00068"}, d2={"Ltech/figure/hdwallet/bip32/ExtKey;", "", "versionBytes", "Ltech/figure/hdwallet/bip32/ExtKeyVersion;", "depth", "Ltech/figure/hdwallet/bip32/AccountType;", "parentKeyFingerprint", "Ltech/figure/hdwallet/bip32/ExtKeyFingerprint;", "childNumber", "", "chainCode", "Ltech/figure/hdwallet/bip32/ExtKeyChainCode;", "keyPair", "Ltech/figure/hdwallet/ec/ECKeyPair;", "([BLtech/figure/hdwallet/bip32/AccountType;[BI[BLtech/figure/hdwallet/ec/ECKeyPair;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getChainCode-69Snlsg", "()[B", "[B", "getChildNumber", "()I", "curve", "Ltech/figure/hdwallet/ec/Curve;", "getDepth", "()Ltech/figure/hdwallet/bip32/AccountType;", "getKeyPair", "()Ltech/figure/hdwallet/ec/ECKeyPair;", "getParentKeyFingerprint-qxchSR4", "getVersionBytes-6_FmcGI", "childKey", "index", "hardened", "", "path", "", "", "Ltech/figure/hdwallet/bip44/PathElement;", "component1", "component1-6_FmcGI", "component2", "component3", "component3-qxchSR4", "component4", "component5", "component5-69Snlsg", "component6", "copy", "copy-7qw8rLs", "([BLtech/figure/hdwallet/bip32/AccountType;[BI[BLtech/figure/hdwallet/ec/ECKeyPair;)Ltech/figure/hdwallet/bip32/ExtKey;", "equals", "other", "hashCode", "serialize", "", "publicKeyOnly", "toString", "Companion", "bip32"})
public final class ExtKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] versionBytes;
    @NotNull
    private final AccountType depth;
    @NotNull
    private final byte[] parentKeyFingerprint;
    private final int childNumber;
    @NotNull
    private final byte[] chainCode;
    @NotNull
    private final ECKeyPair keyPair;
    @NotNull
    private final Curve curve;

    private ExtKey(byte[] versionBytes, AccountType depth, byte[] parentKeyFingerprint, int childNumber, byte[] chainCode, ECKeyPair keyPair) {
        this.versionBytes = versionBytes;
        this.depth = depth;
        this.parentKeyFingerprint = parentKeyFingerprint;
        this.childNumber = childNumber;
        this.chainCode = chainCode;
        this.keyPair = keyPair;
        this.curve = this.keyPair.getPrivateKey().getCurve();
    }

    @NotNull
    public final byte[] getVersionBytes-6_FmcGI() {
        return this.versionBytes;
    }

    @NotNull
    public final AccountType getDepth() {
        return this.depth;
    }

    @NotNull
    public final byte[] getParentKeyFingerprint-qxchSR4() {
        return this.parentKeyFingerprint;
    }

    public final int getChildNumber() {
        return this.childNumber;
    }

    @NotNull
    public final byte[] getChainCode-69Snlsg() {
        return this.chainCode;
    }

    @NotNull
    public final ECKeyPair getKeyPair() {
        return this.keyPair;
    }

    @NotNull
    public final byte[] serialize(boolean publicKeyOnly) {
        if (!(publicKeyOnly || Arrays.equals(this.versionBytes, ConstantsKt.getXprv()) || Arrays.equals(this.versionBytes, ConstantsKt.getTprv()))) {
            throw new KeyException("The extended version bytes dedicated to public keys. Suggest using publicKeyOnly mode");
        }
        if (!publicKeyOnly && Intrinsics.areEqual((Object)this.keyPair.getPrivateKey().getKey(), (Object)BigInteger.ZERO)) {
            throw new KeyException("The extended key doesn't provide any private key. Suggest using publicKeyOnly mode");
        }
        ByteBuffer bb = ByteBuffer.allocate(78);
        bb.put(publicKeyOnly && Arrays.equals(this.versionBytes, ConstantsKt.getXprv()) ? ConstantsKt.getXpub() : (publicKeyOnly && Arrays.equals(this.versionBytes, ConstantsKt.getTprv()) ? ConstantsKt.getTpub() : this.versionBytes));
        bb.put((byte)this.depth.ordinal());
        bb.put(this.parentKeyFingerprint);
        bb.putInt(this.childNumber);
        bb.put(this.chainCode);
        if (publicKeyOnly) {
            bb.put(this.keyPair.getPublicKey().compressed());
        } else {
            bb.put((byte)0);
            bb.put(BigIntegerKt.toBytesPadded((BigInteger)this.keyPair.getPrivateKey().getKey(), (int)32));
        }
        byte[] byArray = bb.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bb.array()");
        return byArray;
    }

    public static /* synthetic */ byte[] serialize$default(ExtKey extKey, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return extKey.serialize(bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExtKey childKey(@NotNull List<? extends PathElement> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Iterable $this$fold$iv = path;
        boolean $i$f$fold = false;
        ExtKey accumulator$iv = this;
        for (Object element$iv : $this$fold$iv) {
            void i;
            PathElement pathElement = (PathElement)element$iv;
            ExtKey acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.childKey(i.getNumber(), i.getHardened());
        }
        return accumulator$iv;
    }

    @NotNull
    public final ExtKey childKey(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.childKey(PathElements.INSTANCE.from(path));
    }

    @NotNull
    public final ExtKey childKey(int index, boolean hardened) {
        ExtKey extKey;
        byte[] lr;
        byte[] byArray;
        if (this.depth == AccountType.ADDRESS) {
            throw new KeyException("cannot create key beyond current scope " + this.depth);
        }
        if (hardened && Intrinsics.areEqual((Object)this.keyPair.getPrivateKey().getKey(), (Object)BigInteger.ZERO)) {
            throw new KeyException("private key required for hardened child keys");
        }
        int account = hardened ? index | Integer.MIN_VALUE : index;
        byte[] pub = this.keyPair.getPublicKey().compressed();
        if (hardened) {
            byte[] pkb = BigIntegerKt.toBytesPadded((BigInteger)this.keyPair.getPrivateKey().getKey(), (int)32);
            byArray = ByteBuffer.allocate(pkb.length + 5).order(ByteOrder.BIG_ENDIAN).put((byte)0).put(pkb).putInt(account).array();
        } else {
            byArray = ByteBuffer.allocate(pub.length + 4).order(ByteOrder.BIG_ENDIAN).put(pub).putInt(account).array();
        }
        byte[] ext = byArray;
        Intrinsics.checkNotNullExpressionValue((Object)ext, (String)"ext");
        byte[] byArray2 = lr = MasterKeyKt.access$hmacSha512(this.chainCode, ext);
        int n = 0;
        int n2 = 32;
        byte[] l = ArraysKt.copyOfRange((byte[])byArray2, (int)n, (int)n2);
        byte[] byArray3 = lr;
        n2 = 32;
        int n3 = 64;
        byte[] r = ArraysKt.copyOfRange((byte[])byArray3, (int)n2, (int)n3);
        BigInteger ib = BytesKt.packIntoBigInteger((byte[])l);
        if (!(!Intrinsics.areEqual((Object)ib, (Object)BigInteger.ZERO) && ib.compareTo(this.curve.getN()) < 0)) {
            boolean $i$a$-require-ExtKey$childKey$52 = false;
            String $i$a$-require-ExtKey$childKey$52 = "invalid derived key";
            throw new IllegalArgumentException($i$a$-require-ExtKey$childKey$52.toString());
        }
        byte[] $i$a$-require-ExtKey$childKey$52 = HashKt.sha256hash160((byte[])pub);
        int n4 = 0;
        int n5 = 4;
        byte[] fingerprint = ExtKeyFingerprint.constructor-impl(ArraysKt.copyOfRange((byte[])$i$a$-require-ExtKey$childKey$52, (int)n4, (int)n5));
        AccountType nextDepth = this.depth.next();
        byte[] nextChainCode = ExtKeyChainCode.constructor-impl(r);
        if (!Intrinsics.areEqual((Object)this.keyPair.getPrivateKey().getKey(), (Object)BigInteger.ZERO)) {
            BigInteger k = ib.add(this.keyPair.getPrivateKey().getKey()).mod(this.curve.getN());
            if (!(!Intrinsics.areEqual((Object)k, (Object)BigInteger.ZERO))) {
                boolean $i$a$-require-ExtKey$childKey$62 = false;
                String $i$a$-require-ExtKey$childKey$62 = "invalid derived key";
                throw new IllegalArgumentException($i$a$-require-ExtKey$childKey$62.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)k, (String)"k");
            extKey = new ExtKey(this.versionBytes, nextDepth, fingerprint, account, nextChainCode, new PrivateKey(k, this.curve).toECKeyPair(), null);
        } else {
            byte[] pt;
            CurvePoint q = this.curve.getG().mul(ib).add(this.curve.decodePoint(pub)).normalize();
            if (!(!q.isInfinity())) {
                boolean $i$a$-require-ExtKey$childKey$72 = false;
                String $i$a$-require-ExtKey$childKey$72 = "invalid derived key is zeros";
                throw new IllegalArgumentException($i$a$-require-ExtKey$childKey$72.toString());
            }
            byte[] byArray4 = pt = this.curve.createPoint(q.getX(), q.getY()).encoded(false);
            int n6 = 1;
            int n7 = pt.length;
            PublicKey pubk = new PublicKey(BytesKt.packIntoBigInteger((byte[])ArraysKt.copyOfRange((byte[])byArray4, (int)n6, (int)n7)), this.curve);
            BigInteger bigInteger = BigInteger.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
            PrivateKey prvk = new PrivateKey(bigInteger, this.curve);
            extKey = new ExtKey(this.versionBytes, nextDepth, fingerprint, account, nextChainCode, new ECKeyPair(prvk, pubk), null);
        }
        return extKey;
    }

    public static /* synthetic */ ExtKey childKey$default(ExtKey extKey, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return extKey.childKey(n, bl);
    }

    @NotNull
    public final byte[] component1-6_FmcGI() {
        return this.versionBytes;
    }

    @NotNull
    public final AccountType component2() {
        return this.depth;
    }

    @NotNull
    public final byte[] component3-qxchSR4() {
        return this.parentKeyFingerprint;
    }

    public final int component4() {
        return this.childNumber;
    }

    @NotNull
    public final byte[] component5-69Snlsg() {
        return this.chainCode;
    }

    @NotNull
    public final ECKeyPair component6() {
        return this.keyPair;
    }

    @NotNull
    public final ExtKey copy-7qw8rLs(@NotNull byte[] versionBytes, @NotNull AccountType depth, @NotNull byte[] parentKeyFingerprint, int childNumber, @NotNull byte[] chainCode, @NotNull ECKeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)versionBytes, (String)"versionBytes");
        Intrinsics.checkNotNullParameter((Object)((Object)depth), (String)"depth");
        Intrinsics.checkNotNullParameter((Object)parentKeyFingerprint, (String)"parentKeyFingerprint");
        Intrinsics.checkNotNullParameter((Object)chainCode, (String)"chainCode");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        return new ExtKey(versionBytes, depth, parentKeyFingerprint, childNumber, chainCode, keyPair, null);
    }

    public static /* synthetic */ ExtKey copy-7qw8rLs$default(ExtKey extKey, byte[] byArray, AccountType accountType, byte[] byArray2, int n, byte[] byArray3, ECKeyPair eCKeyPair, int n2, Object object) {
        if ((n2 & 1) != 0) {
            byArray = extKey.versionBytes;
        }
        if ((n2 & 2) != 0) {
            accountType = extKey.depth;
        }
        if ((n2 & 4) != 0) {
            byArray2 = extKey.parentKeyFingerprint;
        }
        if ((n2 & 8) != 0) {
            n = extKey.childNumber;
        }
        if ((n2 & 0x10) != 0) {
            byArray3 = extKey.chainCode;
        }
        if ((n2 & 0x20) != 0) {
            eCKeyPair = extKey.keyPair;
        }
        return extKey.copy-7qw8rLs(byArray, accountType, byArray2, n, byArray3, eCKeyPair);
    }

    @NotNull
    public String toString() {
        return "ExtKey(versionBytes=" + ExtKeyVersion.toString-impl(this.versionBytes) + ", depth=" + this.depth + ", parentKeyFingerprint=" + ExtKeyFingerprint.toString-impl(this.parentKeyFingerprint) + ", childNumber=" + this.childNumber + ", chainCode=" + ExtKeyChainCode.toString-impl(this.chainCode) + ", keyPair=" + this.keyPair + ")";
    }

    public int hashCode() {
        int result = ExtKeyVersion.hashCode-impl(this.versionBytes);
        result = result * 31 + this.depth.hashCode();
        result = result * 31 + ExtKeyFingerprint.hashCode-impl(this.parentKeyFingerprint);
        result = result * 31 + Integer.hashCode(this.childNumber);
        result = result * 31 + ExtKeyChainCode.hashCode-impl(this.chainCode);
        result = result * 31 + this.keyPair.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExtKey)) {
            return false;
        }
        ExtKey extKey = (ExtKey)other;
        if (!ExtKeyVersion.equals-impl0(this.versionBytes, extKey.versionBytes)) {
            return false;
        }
        if (this.depth != extKey.depth) {
            return false;
        }
        if (!ExtKeyFingerprint.equals-impl0(this.parentKeyFingerprint, extKey.parentKeyFingerprint)) {
            return false;
        }
        if (this.childNumber != extKey.childNumber) {
            return false;
        }
        if (!ExtKeyChainCode.equals-impl0(this.chainCode, extKey.chainCode)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keyPair, (Object)extKey.keyPair);
    }

    public /* synthetic */ ExtKey(byte[] versionBytes, AccountType depth, byte[] parentKeyFingerprint, int childNumber, byte[] chainCode, ECKeyPair keyPair, DefaultConstructorMarker $constructor_marker) {
        this(versionBytes, depth, parentKeyFingerprint, childNumber, chainCode, keyPair);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0005"}, d2={"Ltech/figure/hdwallet/bip32/ExtKey$Companion;", "", "()V", "deserialize", "Ltech/figure/hdwallet/bip32/ExtKey;", "bip32", "", "curve", "Ltech/figure/hdwallet/ec/Curve;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtKey deserialize(@NotNull byte[] bip32, @NotNull Curve curve) {
            ECKeyPair eCKeyPair;
            boolean testnet;
            Intrinsics.checkNotNullParameter((Object)bip32, (String)"bip32");
            Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
            ByteBuffer bb = ByteBuffer.wrap(bip32);
            Intrinsics.checkNotNullExpressionValue((Object)bb, (String)"bb");
            byte[] ver = MasterKeyKt.getByteArray(bb, 4);
            byte depth = bb.get();
            byte[] parent = MasterKeyKt.getByteArray(bb, 4);
            int sequence = bb.getInt();
            boolean hardened = (sequence & Integer.MIN_VALUE) != 0;
            int accountNumber = hardened ? sequence ^ Integer.MIN_VALUE : sequence;
            byte[] chainCode = MasterKeyKt.getByteArray(bb, 32);
            boolean hasPrivate = Arrays.equals(ver, ConstantsKt.getXprv()) || Arrays.equals(ver, ConstantsKt.getTprv());
            boolean bl = testnet = Arrays.equals(ver, ConstantsKt.getTprv()) || Arrays.equals(ver, ConstantsKt.getTpub());
            if (depth == 2 && accountNumber != 1 && !(!testnet)) {
                boolean bl2 = false;
                String string = "no test coins in mainnet";
                throw new IllegalArgumentException(string.toString());
            }
            if (hasPrivate) {
                bb.get();
                eCKeyPair = PrivateKey.Companion.fromBytes(MasterKeyKt.getByteArray(bb, 32), curve).toECKeyPair();
            } else {
                BigInteger bigInteger = BigInteger.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
                eCKeyPair = new ECKeyPair(new PrivateKey(bigInteger, curve), new PublicKey(CompressionKt.decompressPublicKey$default((byte[])MasterKeyKt.getByteArray(bb, 33), (Curve)curve, (boolean)false, (int)4, null), curve));
            }
            ECKeyPair keyPair = eCKeyPair;
            return new ExtKey(ExtKeyVersion.constructor-impl(ver), AccountType.Companion.from(depth), ExtKeyFingerprint.constructor-impl(parent), sequence, ExtKeyChainCode.constructor-impl(chainCode), keyPair, null);
        }

        public static /* synthetic */ ExtKey deserialize$default(Companion companion, byte[] byArray, Curve curve, int n, Object object) {
            if ((n & 2) != 0) {
                curve = CurveKt.getDEFAULT_CURVE();
            }
            return companion.deserialize(byArray, curve);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

