/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import tech.grasshopper.display.HtmlSnippets;

public class AttachmentContentProcessor {
    private String fileNamePrefix;
    private String reportDirectory;

    public void processBodyContent(String content) throws IOException {
        this.createDisplayFiles(HtmlSnippets.bodyContent(content), "Body");
    }

    public void processHeadersAndCookiesContent(Map<String, Map<String, String>> data) throws IOException {
        StringBuffer sbr = new StringBuffer();
        data.forEach((k, v) -> sbr.append(HtmlSnippets.headersCookiesParametersContent(v, k)));
        this.createDisplayFiles(sbr, "Headers And Cookies");
    }

    public void processAllParametersContent(Map<String, Map<String, String>> parameters, List<Map<String, String>> parts) throws IOException {
        StringBuffer sbr = new StringBuffer();
        parameters.forEach((k, v) -> sbr.append(HtmlSnippets.headersCookiesParametersContent(v, k)));
        if (!parts.isEmpty()) {
            sbr.append(HtmlSnippets.multiPartsContent(parts));
        }
        if (sbr.length() == 0) {
            return;
        }
        this.createDisplayFiles(sbr, "All Parameters");
    }

    private void createDisplayFiles(StringBuffer content, String fileNameSuffix) throws IOException {
        StringBuffer sbr = new StringBuffer();
        sbr.append(HtmlSnippets.addHtmlBodyTag(content));
        StringBuffer sbrFile = new StringBuffer().append(this.fileNamePrefix).append("-").append(fileNameSuffix).append(".html");
        Path path = Paths.get(this.reportDirectory, "data", sbrFile.toString());
        try (FileOutputStream outputStream = new FileOutputStream(path.toString());){
            outputStream.write(sbr.toString().getBytes());
        }
        catch (IOException e) {
            throw new IOException(String.format("Unable to process %s%s%s content for display.", this.fileNamePrefix, "-", fileNameSuffix));
        }
    }

    AttachmentContentProcessor(String fileNamePrefix, String reportDirectory) {
        this.fileNamePrefix = fileNamePrefix;
        this.reportDirectory = reportDirectory;
    }

    public static AttachmentContentProcessorBuilder builder() {
        return new AttachmentContentProcessorBuilder();
    }

    public static class AttachmentContentProcessorBuilder {
        private String fileNamePrefix;
        private String reportDirectory;

        AttachmentContentProcessorBuilder() {
        }

        public AttachmentContentProcessorBuilder fileNamePrefix(String fileNamePrefix) {
            this.fileNamePrefix = fileNamePrefix;
            return this;
        }

        public AttachmentContentProcessorBuilder reportDirectory(String reportDirectory) {
            this.reportDirectory = reportDirectory;
            return this;
        }

        public AttachmentContentProcessor build() {
            return new AttachmentContentProcessor(this.fileNamePrefix, this.reportDirectory);
        }

        public String toString() {
            return "AttachmentContentProcessor.AttachmentContentProcessorBuilder(fileNamePrefix=" + this.fileNamePrefix + ", reportDirectory=" + this.reportDirectory + ")";
        }
    }
}

