/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pojo;

import java.util.Map;
import tech.grasshopper.display.HtmlSnippets;
import tech.grasshopper.pojo.AttachmentData;
import tech.grasshopper.pojo.HttpRequestData;
import tech.grasshopper.pojo.HttpResponseData;

public abstract class HttpData {
    private String bodyContentFile;
    private String headersAndCookiesContentFile;
    private String allParametersContentFile;

    public void setBodyContentFile(String fileNamePrefix) {
        this.bodyContentFile = this.contentFileName(fileNamePrefix, "Body");
    }

    public void setHeadersAndCookiesContentFile(String fileNamePrefix) {
        this.headersAndCookiesContentFile = this.contentFileName(fileNamePrefix, "Headers And Cookies");
    }

    public void setAllParametersContentFile(String fileNamePrefix) {
        this.allParametersContentFile = this.contentFileName(fileNamePrefix, "All Parameters");
    }

    private String contentFileName(String fileNamePrefix, String type) {
        StringBuffer sbr = new StringBuffer("data");
        return sbr.append("/").append(fileNamePrefix).append("-").append(type).append(".html").toString();
    }

    public static HttpData createHttpData(AttachmentData data) {
        if (data.getName().equalsIgnoreCase("Response")) {
            return ((HttpResponseData.HttpResponseDataBuilder)HttpResponseData.builder().statusCode(data.getResponseCode())).build();
        }
        if (data.getName().equalsIgnoreCase("Request")) {
            return ((HttpRequestData.HttpRequestDataBuilder)((HttpRequestData.HttpRequestDataBuilder)HttpRequestData.builder().httpMethod(data.getMethod())).endpoint(data.getUrl())).build();
        }
        throw new IllegalArgumentException("Attachment data name is invalid.");
    }

    protected int rowCount() {
        if (this.containsHttpContentFiles()) {
            return 1;
        }
        return 0;
    }

    public boolean containsHttpContentFiles() {
        return !this.bodyContentFile.isEmpty() || !this.headersAndCookiesContentFile.isEmpty() || !this.allParametersContentFile.isEmpty();
    }

    public abstract void addPropertiesDisplay(Map<String, String> var1);

    public abstract void addHttpContentFilesDisplay(Map<String, String> var1);

    protected void createFileLinks(String type, Map<String, String> details) {
        StringBuffer sbr = new StringBuffer();
        if (this.containsHttpContentFiles()) {
            if (!this.bodyContentFile.isEmpty()) {
                sbr.append(HtmlSnippets.dataFileLink(this.bodyContentFile, "Body"));
                details.put(type + " Body", this.bodyContentFile);
            }
            if (!this.headersAndCookiesContentFile.isEmpty()) {
                sbr.append(HtmlSnippets.dataFileLink(this.headersAndCookiesContentFile, "Headers & Cookies"));
                details.put(type + " Headers & Cookies", this.headersAndCookiesContentFile);
            }
            if (!this.allParametersContentFile.isEmpty()) {
                sbr.append(HtmlSnippets.dataFileLink(this.allParametersContentFile, "Parameters"));
                details.put(type + " Parameters", this.allParametersContentFile);
            }
        }
        details.put(type, sbr.toString());
    }

    private static String $default$bodyContentFile() {
        return "";
    }

    private static String $default$headersAndCookiesContentFile() {
        return "";
    }

    private static String $default$allParametersContentFile() {
        return "";
    }

    protected HttpData(HttpDataBuilder<?, ?> b) {
        this.bodyContentFile = ((HttpDataBuilder)b).bodyContentFile$set ? ((HttpDataBuilder)b).bodyContentFile$value : HttpData.$default$bodyContentFile();
        this.headersAndCookiesContentFile = ((HttpDataBuilder)b).headersAndCookiesContentFile$set ? ((HttpDataBuilder)b).headersAndCookiesContentFile$value : HttpData.$default$headersAndCookiesContentFile();
        this.allParametersContentFile = ((HttpDataBuilder)b).allParametersContentFile$set ? ((HttpDataBuilder)b).allParametersContentFile$value : HttpData.$default$allParametersContentFile();
    }

    public String getBodyContentFile() {
        return this.bodyContentFile;
    }

    public String getHeadersAndCookiesContentFile() {
        return this.headersAndCookiesContentFile;
    }

    public String getAllParametersContentFile() {
        return this.allParametersContentFile;
    }

    public static abstract class HttpDataBuilder<C extends HttpData, B extends HttpDataBuilder<C, B>> {
        private boolean bodyContentFile$set;
        private String bodyContentFile$value;
        private boolean headersAndCookiesContentFile$set;
        private String headersAndCookiesContentFile$value;
        private boolean allParametersContentFile$set;
        private String allParametersContentFile$value;

        protected abstract B self();

        public abstract C build();

        public B bodyContentFile(String bodyContentFile) {
            this.bodyContentFile$value = bodyContentFile;
            this.bodyContentFile$set = true;
            return this.self();
        }

        public B headersAndCookiesContentFile(String headersAndCookiesContentFile) {
            this.headersAndCookiesContentFile$value = headersAndCookiesContentFile;
            this.headersAndCookiesContentFile$set = true;
            return this.self();
        }

        public B allParametersContentFile(String allParametersContentFile) {
            this.allParametersContentFile$value = allParametersContentFile;
            this.allParametersContentFile$set = true;
            return this.self();
        }

        public String toString() {
            return "HttpData.HttpDataBuilder(bodyContentFile$value=" + this.bodyContentFile$value + ", headersAndCookiesContentFile$value=" + this.headersAndCookiesContentFile$value + ", allParametersContentFile$value=" + this.allParametersContentFile$value + ")";
        }
    }
}

