/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import tech.grasshopper.pojo.Attachment;
import tech.grasshopper.pojo.AttachmentData;
import tech.grasshopper.pojo.HttpData;
import tech.grasshopper.pojo.HttpLogData;
import tech.grasshopper.pojo.HttpRequestData;
import tech.grasshopper.pojo.HttpResponseData;
import tech.grasshopper.processor.AttachmentContentProcessor;

public class AttachmentProcessor {
    private HttpData httpData;
    private HttpLogData log;
    private List<HttpLogData> httpLogData;
    private String fileNamePrefix = "";
    private AttachmentData data;
    private String allureResultsDirectory;
    private String reportDirectory;
    private Set<String> requestHeadersBlacklist;
    private Set<String> responseHeadersBlacklist;
    private static final Logger logger = Logger.getLogger(AttachmentProcessor.class.getName());

    public AttachmentProcessor(String allureResultsDirectory, String reportDirectory, Set<String> requestHeadersBlacklist, Set<String> responseHeadersBlacklist) {
        this.allureResultsDirectory = allureResultsDirectory;
        this.reportDirectory = reportDirectory;
        this.requestHeadersBlacklist = requestHeadersBlacklist;
        this.responseHeadersBlacklist = responseHeadersBlacklist;
    }

    public List<HttpLogData> process(List<Attachment> attachments) {
        this.httpLogData = new ArrayList<HttpLogData>();
        for (Attachment attachment : attachments) {
            Path path = Paths.get(this.allureResultsDirectory, attachment.getSource());
            if (!attachment.getSource().endsWith("-attachment.json")) {
                logger.info("Skipping attachment as file name not correct - " + path.toString());
                continue;
            }
            try {
                Gson gson = new Gson();
                this.data = (AttachmentData)gson.fromJson((Reader)Files.newBufferedReader(path), AttachmentData.class);
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                logger.info(String.format("Skipping attachment at '%s', as unable to parse result to AttachmentData pojo.", path));
                continue;
            }
            try {
                this.httpData = HttpData.createHttpData(this.data);
            }
            catch (IllegalArgumentException e) {
                logger.info(String.format("Skipping attachment at '%s', due to invalid name.", path));
                continue;
            }
            this.fileNamePrefix = this.retrieveFileNamePrefix(attachment.getSource());
            this.createOrUpdateHttpLogData();
            this.processContent(path);
        }
        return this.httpLogData;
    }

    private void processContent(Path path) {
        try {
            this.processBodyContent();
        }
        catch (IOException e) {
            logger.info(e.getMessage() + " Skipping body for - " + path.toString());
        }
        try {
            this.processHeadersAndCookies();
        }
        catch (IOException e) {
            logger.info(e.getMessage() + " Skipping headers and cookies for - " + path.toString());
        }
        try {
            this.processAllParameters();
        }
        catch (IOException e) {
            logger.info(e.getMessage() + " Skipping parameters for - " + path.toString());
        }
    }

    private String retrieveFileNamePrefix(String source) {
        return source.substring(0, source.lastIndexOf(45));
    }

    private void createOrUpdateHttpLogData() {
        if (this.httpData instanceof HttpRequestData) {
            this.log = HttpLogData.builder().build();
            this.log.setHttpRequestData((HttpRequestData)this.httpData);
            this.httpLogData.add(this.log);
        } else {
            this.log.setHttpResponseData((HttpResponseData)this.httpData);
        }
    }

    private void processBodyContent() throws IOException {
        String content = this.data.getBody();
        if (content.length() > 0) {
            AttachmentContentProcessor.builder().fileNamePrefix(this.fileNamePrefix).reportDirectory(this.reportDirectory).build().processBodyContent(content);
            this.httpData.setBodyContentFile(this.fileNamePrefix);
        }
    }

    private void processHeadersAndCookies() throws IOException {
        if (this.data.getHeaders().isEmpty() && this.data.getCookies().isEmpty()) {
            return;
        }
        Map<String, String> headers = this.processHeaders();
        Map<String, String> cookies = this.data.getCookies();
        HashMap<String, Map<String, String>> headersAndCookies = new HashMap<String, Map<String, String>>();
        if (!headers.isEmpty()) {
            headersAndCookies.put("Headers", headers);
        }
        if (!cookies.isEmpty()) {
            headersAndCookies.put("Cookies", cookies);
        }
        AttachmentContentProcessor.builder().fileNamePrefix(this.fileNamePrefix).reportDirectory(this.reportDirectory).build().processHeadersAndCookiesContent(headersAndCookies);
        this.httpData.setHeadersAndCookiesContentFile(this.fileNamePrefix);
    }

    private Map<String, String> processHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.data.getHeaders().forEach((k, v) -> headers.put((String)k, (String)v));
        if (this.httpData instanceof HttpRequestData && !this.requestHeadersBlacklist.isEmpty()) {
            this.blackListHeaders(this.requestHeadersBlacklist, headers);
        }
        if (this.httpData instanceof HttpResponseData && !this.responseHeadersBlacklist.isEmpty()) {
            this.blackListHeaders(this.responseHeadersBlacklist, headers);
        }
        return headers;
    }

    private void blackListHeaders(Set<String> headerReqResBlacklist, Map<String, String> headers) {
        headerReqResBlacklist.forEach(h -> {
            if (headers.containsKey(h)) {
                headers.replace((String)h, "[BLACKLIST]");
            }
        });
    }

    private void processAllParameters() throws IOException {
        Map<String, Map<String, String>> parameters = this.data.getAllParameters();
        List<Map<String, String>> parts = this.data.getMultiParts();
        if (parameters.isEmpty() && parts.isEmpty()) {
            return;
        }
        AttachmentContentProcessor.builder().fileNamePrefix(this.fileNamePrefix).reportDirectory(this.reportDirectory).build().processAllParametersContent(parameters, parts);
        this.httpData.setAllParametersContentFile(this.fileNamePrefix);
    }

    public static AttachmentProcessorBuilder builder() {
        return new AttachmentProcessorBuilder();
    }

    public static class AttachmentProcessorBuilder {
        private String allureResultsDirectory;
        private String reportDirectory;
        private Set<String> requestHeadersBlacklist;
        private Set<String> responseHeadersBlacklist;

        AttachmentProcessorBuilder() {
        }

        public AttachmentProcessorBuilder allureResultsDirectory(String allureResultsDirectory) {
            this.allureResultsDirectory = allureResultsDirectory;
            return this;
        }

        public AttachmentProcessorBuilder reportDirectory(String reportDirectory) {
            this.reportDirectory = reportDirectory;
            return this;
        }

        public AttachmentProcessorBuilder requestHeadersBlacklist(Set<String> requestHeadersBlacklist) {
            this.requestHeadersBlacklist = requestHeadersBlacklist;
            return this;
        }

        public AttachmentProcessorBuilder responseHeadersBlacklist(Set<String> responseHeadersBlacklist) {
            this.responseHeadersBlacklist = responseHeadersBlacklist;
            return this;
        }

        public AttachmentProcessor build() {
            return new AttachmentProcessor(this.allureResultsDirectory, this.reportDirectory, this.requestHeadersBlacklist, this.responseHeadersBlacklist);
        }

        public String toString() {
            return "AttachmentProcessor.AttachmentProcessorBuilder(allureResultsDirectory=" + this.allureResultsDirectory + ", reportDirectory=" + this.reportDirectory + ", requestHeadersBlacklist=" + this.requestHeadersBlacklist + ", responseHeadersBlacklist=" + this.responseHeadersBlacklist + ")";
        }
    }
}

