/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import com.aventstack.extentreports.ExtentTest;
import tech.grasshopper.pojo.AdditionalData;

public interface AdditionalInformationProcessor {
    public static AdditionalInformationProcessor noAddInfoProcessor() {
        return NoAddInfoProcessor.builder().build();
    }

    default public void process(ExtentTest extentTest, AdditionalData additionalData) {
    }

    public static class NoAddInfoProcessor
    implements AdditionalInformationProcessor {
        NoAddInfoProcessor() {
        }

        public static NoAddInfoProcessorBuilder builder() {
            return new NoAddInfoProcessorBuilder();
        }

        public static class NoAddInfoProcessorBuilder {
            NoAddInfoProcessorBuilder() {
            }

            public NoAddInfoProcessor build() {
                return new NoAddInfoProcessor();
            }

            public String toString() {
                return "AdditionalInformationProcessor.NoAddInfoProcessor.NoAddInfoProcessorBuilder()";
            }
        }
    }

    public static class DefaultAddInfoProcessor
    implements AdditionalInformationProcessor {
        @Override
        public void process(ExtentTest extentTest, AdditionalData additionalData) {
            extentTest.getModel().getInfoMap().putAll(additionalData.getInfo());
        }

        DefaultAddInfoProcessor() {
        }

        public static DefaultAddInfoProcessorBuilder builder() {
            return new DefaultAddInfoProcessorBuilder();
        }

        public static class DefaultAddInfoProcessorBuilder {
            DefaultAddInfoProcessorBuilder() {
            }

            public DefaultAddInfoProcessor build() {
                return new DefaultAddInfoProcessor();
            }

            public String toString() {
                return "AdditionalInformationProcessor.DefaultAddInfoProcessor.DefaultAddInfoProcessorBuilder()";
            }
        }
    }
}

