/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.MediaEntityBuilder;
import java.util.List;
import java.util.logging.Logger;
import tech.grasshopper.pojo.Embedded;

public class EmbeddedProcessor {
    private ExtentTest test;
    private List<Embedded> embeddings;
    private static final Logger logger = Logger.getLogger(EmbeddedProcessor.class.getName());

    public void process() {
        for (Embedded embed : this.embeddings) {
            String name = embed.getName() == null ? "" : embed.getName();
            String filePath = embed.getFilePath();
            if (filePath == null || filePath.isEmpty()) {
                logger.warning(String.format("Skipping adding embedded file as filepath is empty for step - '%s'.", this.test.getModel().getName()));
                return;
            }
            try {
                this.test.info(name, MediaEntityBuilder.createScreenCaptureFromPath((String)filePath).build());
            }
            catch (Exception e) {
                logger.warning(String.format("Skipping adding embedded file for step - '%s' as error in processing.", this.test.getModel().getName()));
                return;
            }
        }
    }

    EmbeddedProcessor(ExtentTest test, List<Embedded> embeddings) {
        this.test = test;
        this.embeddings = embeddings;
    }

    public static EmbeddedProcessorBuilder builder() {
        return new EmbeddedProcessorBuilder();
    }

    public static class EmbeddedProcessorBuilder {
        private ExtentTest test;
        private List<Embedded> embeddings;

        EmbeddedProcessorBuilder() {
        }

        public EmbeddedProcessorBuilder test(ExtentTest test) {
            this.test = test;
            return this;
        }

        public EmbeddedProcessorBuilder embeddings(List<Embedded> embeddings) {
            this.embeddings = embeddings;
            return this;
        }

        public EmbeddedProcessor build() {
            return new EmbeddedProcessor(this.test, this.embeddings);
        }

        public String toString() {
            return "EmbeddedProcessor.EmbeddedProcessorBuilder(test=" + this.test + ", embeddings=" + this.embeddings + ")";
        }
    }
}

