/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.grasshopper.pojo.Result;

public class ExceptionProcessor {
    private Result result;
    private static final Logger logger = Logger.getLogger(ExceptionProcessor.class.getName());

    public Throwable process() {
        String[] details = this.retrieveExceptionNameAndStack(this.result.getErrorMessage());
        String exceptionClzName = details[0];
        String exceptionMessage = details[1];
        return this.createThrowableInstance(exceptionClzName, exceptionMessage);
    }

    private String[] retrieveExceptionNameAndStack(String stackTrace) {
        String[] details = new String[]{"", ""};
        Matcher m = Pattern.compile("\\R").matcher(stackTrace);
        if (m.find()) {
            String excepNameMsg = stackTrace.substring(0, m.start());
            int colonIndex = excepNameMsg.indexOf(":");
            if (colonIndex > -1) {
                details[0] = excepNameMsg.substring(0, colonIndex);
                details[1] = stackTrace.substring(colonIndex + 2);
            } else {
                details[0] = excepNameMsg;
                details[1] = stackTrace.substring(m.start());
            }
        }
        return details;
    }

    private Throwable createThrowableInstance(String className, String message) {
        Class<?> throwableClass = null;
        try {
            throwableClass = Class.forName(className);
            if (!Throwable.class.isAssignableFrom(throwableClass)) {
                throw new ClassNotFoundException();
            }
        }
        catch (ClassNotFoundException e) {
            logger.warning(className + " class cannot be found or not an instance of Throwable.");
            return new Exception("Generic Exception for " + className + " : " + message);
        }
        return this.createThrowableInstance(className, message, throwableClass);
    }

    private Throwable createThrowableInstance(String className, String message, Class<?> throwableClass) {
        Throwable throwableInstance;
        block5: {
            Constructor<?> throwableConstructor = null;
            throwableInstance = null;
            try {
                if (message.isEmpty()) {
                    throwableConstructor = throwableClass.getConstructor(new Class[0]);
                    throwableInstance = (Throwable)throwableConstructor.newInstance(new Object[0]);
                    break block5;
                }
                try {
                    throwableConstructor = throwableClass.getConstructor(String.class);
                }
                catch (NoSuchMethodException e) {
                    throwableConstructor = throwableClass.getConstructor(Object.class);
                }
                throwableInstance = (Throwable)throwableConstructor.newInstance(message);
            }
            catch (ReflectiveOperationException | SecurityException e) {
                logger.warning(className + " constructor cannot be found or cannot be instanciated.");
                throwableInstance = new Exception("Generic Exception for " + className + " : " + message);
            }
        }
        return throwableInstance;
    }

    ExceptionProcessor(Result result) {
        this.result = result;
    }

    public static ExceptionProcessorBuilder builder() {
        return new ExceptionProcessorBuilder();
    }

    public static class ExceptionProcessorBuilder {
        private Result result;

        ExceptionProcessorBuilder() {
        }

        public ExceptionProcessorBuilder result(Result result) {
            this.result = result;
            return this;
        }

        public ExceptionProcessor build() {
            return new ExceptionProcessor(this.result);
        }

        public String toString() {
            return "ExceptionProcessor.ExceptionProcessorBuilder(result=" + this.result + ")";
        }
    }
}

