/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.pojo.Scenario;
import tech.grasshopper.util.DateConverter;

public class FeatureProcessor {
    private Feature feature;

    public void process() {
        this.updateScenarioWithBackgroundSteps();
        this.updateStartAndEndTimes();
    }

    private void updateScenarioWithBackgroundSteps() {
        if (this.feature.getElements().get(0).getKeyword().equalsIgnoreCase("background")) {
            List<Scenario> scenarios = this.feature.getElements();
            Scenario backgroundScenario = null;
            Iterator<Scenario> iterator = scenarios.iterator();
            while (iterator.hasNext()) {
                Scenario scenario = iterator.next();
                if (scenario.getKeyword().equalsIgnoreCase("background")) {
                    backgroundScenario = scenario;
                    iterator.remove();
                    continue;
                }
                scenario.getSteps().addAll(0, backgroundScenario.getSteps());
            }
        }
    }

    private void updateStartAndEndTimes() {
        ArrayList startTimes = new ArrayList();
        ArrayList endTimes = new ArrayList();
        Comparator zoneDateTimeComparator = ChronoZonedDateTime::compareTo;
        Comparator zoneDateTimeComparatorReversed = zoneDateTimeComparator.reversed();
        this.feature.getElements().forEach(s -> {
            long scenarioHooksDuration = s.getBeforeAfterHooks().stream().mapToLong(h -> h.getResult().getDuration()).sum();
            long stepHooksDuration = s.getSteps().stream().flatMap(st -> st.getBeforeAfterHooks().stream()).mapToLong(h -> h.getResult().getDuration()).sum();
            long stepDurations = s.getSteps().stream().mapToLong(st -> st.getResult().getDuration()).sum();
            long duration = scenarioHooksDuration + stepHooksDuration + stepDurations;
            startTimes.add(DateConverter.parseToZonedDateTime(s.getStartTimestamp()));
            endTimes.add(DateConverter.parseToZonedDateTime(s.getStartTimestamp()).plusNanos(duration));
        });
        startTimes.sort(zoneDateTimeComparator);
        endTimes.sort(zoneDateTimeComparatorReversed);
        this.feature.setStartTime(Date.from(((ZonedDateTime)startTimes.get(0)).toInstant()));
        this.feature.setEndTime(Date.from(((ZonedDateTime)endTimes.get(0)).toInstant()));
    }

    FeatureProcessor(Feature feature) {
        this.feature = feature;
    }

    public static FeatureProcessorBuilder builder() {
        return new FeatureProcessorBuilder();
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public static class FeatureProcessorBuilder {
        private Feature feature;

        FeatureProcessorBuilder() {
        }

        public FeatureProcessorBuilder feature(Feature feature) {
            this.feature = feature;
            return this;
        }

        public FeatureProcessor build() {
            return new FeatureProcessor(this.feature);
        }

        public String toString() {
            return "FeatureProcessor.FeatureProcessorBuilder(feature=" + this.feature + ")";
        }
    }
}

