/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.pojo.Hook;
import tech.grasshopper.pojo.Scenario;
import tech.grasshopper.pojo.Step;
import tech.grasshopper.util.DateConverter;

public class ScenarioProcessor {
    private Feature feature;
    private Scenario scenario;

    public void process() {
        this.updateUri();
        this.collectStepLineNumbers();
        this.updateScenarioStepHookType();
        this.updateScenarioStepHookStartAndEndTimes();
    }

    private void updateUri() {
        this.scenario.setUri(this.feature.getUri());
    }

    private void collectStepLineNumbers() {
        this.scenario.setStepLines(this.scenario.getSteps().stream().map(s -> s.getLine()).collect(Collectors.toList()));
    }

    private void updateScenarioStepHookType() {
        this.scenario.getBefore().forEach(h -> h.setHookType(Hook.HookType.BEFORE));
        this.scenario.getSteps().stream().flatMap(s -> s.getBefore().stream()).collect(Collectors.toList()).forEach(h -> h.setHookType(Hook.HookType.BEFORE_STEP));
        this.scenario.getSteps().stream().flatMap(s -> s.getAfter().stream()).collect(Collectors.toList()).forEach(h -> h.setHookType(Hook.HookType.AFTER_STEP));
        this.scenario.getAfter().forEach(h -> h.setHookType(Hook.HookType.AFTER));
    }

    private void updateScenarioStepHookStartAndEndTimes() {
        ZonedDateTime zoned = DateConverter.parseToZonedDateTime(this.scenario.getStartTimestamp());
        this.scenario.setStartTime(DateConverter.parseToDate(this.scenario.getStartTimestamp()));
        zoned = this.updateHookStartEndTimes(zoned, this.scenario.getBefore());
        for (Step step : this.scenario.getSteps()) {
            zoned = this.updateHookStartEndTimes(zoned, step.getBefore());
            step.setStartTime(DateConverter.parseToDate(zoned));
            zoned = zoned.plusNanos(step.getResult().getDuration());
            step.setEndTime(DateConverter.parseToDate(zoned));
            zoned = this.updateHookStartEndTimes(zoned, step.getAfter());
        }
        zoned = this.updateHookStartEndTimes(zoned, this.scenario.getAfter());
        this.scenario.setEndTime(DateConverter.parseToDate(zoned));
    }

    private ZonedDateTime updateHookStartEndTimes(ZonedDateTime zoned, List<Hook> hooks) {
        for (Hook hook : hooks) {
            hook.setStartTime(DateConverter.parseToDate(zoned));
            zoned = zoned.plusNanos(hook.getResult().getDuration());
            hook.setEndTime(DateConverter.parseToDate(zoned));
        }
        return zoned;
    }

    ScenarioProcessor(Feature feature, Scenario scenario) {
        this.feature = feature;
        this.scenario = scenario;
    }

    public static ScenarioProcessorBuilder builder() {
        return new ScenarioProcessorBuilder();
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public static class ScenarioProcessorBuilder {
        private Feature feature;
        private Scenario scenario;

        ScenarioProcessorBuilder() {
        }

        public ScenarioProcessorBuilder feature(Feature feature) {
            this.feature = feature;
            return this;
        }

        public ScenarioProcessorBuilder scenario(Scenario scenario) {
            this.scenario = scenario;
            return this;
        }

        public ScenarioProcessor build() {
            return new ScenarioProcessor(this.feature, this.scenario);
        }

        public String toString() {
            return "ScenarioProcessor.ScenarioProcessorBuilder(feature=" + this.feature + ", scenario=" + this.scenario + ")";
        }
    }
}

