/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import com.aventstack.extentreports.markuputils.MarkupHelper;
import java.util.List;
import java.util.stream.Collectors;
import tech.grasshopper.pojo.Step;

public class StepProcessor {
    private Step step;

    public void process() {
        this.updateDataTableMarkup(this.step);
        this.updateDocString(this.step);
    }

    protected void updateDataTableMarkup(Step step) {
        List<List<String>> cells = step.getRows().stream().map(r -> r.getCells()).collect(Collectors.toList());
        if (cells.size() < 1) {
            return;
        }
        step.setDataTableMarkup(this.processTable(cells));
    }

    protected void updateDocString(Step step) {
        if (step.getDocString().getValue() == null || step.getDocString().getValue().isEmpty()) {
            return;
        }
        step.setDocStringMarkup(MarkupHelper.createCodeBlock((String)step.getDocString().getValue()).getMarkup());
    }

    private String processTable(List<List<String>> data) {
        if (data.size() < 1) {
            return "";
        }
        String[][] array = new String[data.size()][];
        int i = 0;
        for (List<String> nestedList : data) {
            array[i++] = nestedList.toArray(new String[nestedList.size()]);
        }
        return MarkupHelper.createTable((String[][])array).getMarkup();
    }

    StepProcessor(Step step) {
        this.step = step;
    }

    public static StepProcessorBuilder builder() {
        return new StepProcessorBuilder();
    }

    public void setStep(Step step) {
        this.step = step;
    }

    public static class StepProcessorBuilder {
        private Step step;

        StepProcessorBuilder() {
        }

        public StepProcessorBuilder step(Step step) {
            this.step = step;
            return this;
        }

        public StepProcessor build() {
            return new StepProcessor(this.step);
        }

        public String toString() {
            return "StepProcessor.StepProcessorBuilder(step=" + this.step + ")";
        }
    }
}

