/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.tests;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.grasshopper.pojo.AdditionalData;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.pojo.Scenario;
import tech.grasshopper.pojo.Step;
import tech.grasshopper.processor.AdditionalInformationProcessor;
import tech.grasshopper.processor.FeatureProcessor;
import tech.grasshopper.processor.ScenarioProcessor;
import tech.grasshopper.processor.StepProcessor;
import tech.grasshopper.tests.FeatureExtentTest;
import tech.grasshopper.tests.HookExtentTest;
import tech.grasshopper.tests.ScenarioExtentTest;
import tech.grasshopper.tests.ScenarioOutlineExtentTest;
import tech.grasshopper.tests.StepExtentTest;

public class ExtentTestHeirarchy {
    private List<Feature> features;
    private ExtentReports extent;
    private boolean displayAllHooks;
    private boolean strictCucumber6Behavior;
    private final Map<String, ExtentTest> uriFeatureTestMap = new HashMap<String, ExtentTest>();
    private final Map<String, ExtentTest> uriLinesScenarioOutlineTestMap = new HashMap<String, ExtentTest>();
    private final FeatureProcessor featureProcessor = FeatureProcessor.builder().build();
    private final ScenarioProcessor scenarioProcessor = ScenarioProcessor.builder().build();
    private final StepProcessor stepProcessor = StepProcessor.builder().build();
    private AdditionalInformationProcessor featureAddInfoProcessor;
    private AdditionalInformationProcessor scenarioAddInfoProcessor;

    public void createTestHeirarchy() {
        this.features.forEach(feature -> {
            ExtentTest featureTest = this.createFeatureExtentTest((Feature)feature);
            this.featureAddInfoProcessor.process(featureTest, (AdditionalData)feature);
            feature.getElements().forEach(scenario -> {
                ExtentTest scenarioTest = this.createScenarioExtentTest(featureTest, (Feature)feature, (Scenario)scenario);
                this.scenarioAddInfoProcessor.process(scenarioTest, (AdditionalData)scenario);
                this.createStepHookExtentTests(scenarioTest, (Scenario)scenario);
            });
        });
    }

    private ExtentTest createFeatureExtentTest(Feature feature) {
        this.featureProcessor.setFeature(feature);
        this.featureProcessor.process();
        String uri = feature.getUri();
        if (this.uriFeatureTestMap.containsKey(uri)) {
            return this.uriFeatureTestMap.get(uri);
        }
        ExtentTest featureExtentTest = FeatureExtentTest.builder().feature(feature).extent(this.extent).build().createTest();
        this.uriFeatureTestMap.put(uri, featureExtentTest);
        return featureExtentTest;
    }

    private ExtentTest createScenarioExtentTest(ExtentTest parentTest, Feature feature, Scenario scenario) {
        this.scenarioProcessor.setFeature(feature);
        this.scenarioProcessor.setScenario(scenario);
        this.scenarioProcessor.process();
        if (scenario.getKeyword().equalsIgnoreCase("Scenario Outline")) {
            parentTest = this.createScenarioOutlineExtentTest(parentTest, scenario);
        }
        ExtentTest scenarioExtentTest = ScenarioExtentTest.builder().scenario(scenario).parentTest(parentTest).build().createTest();
        return scenarioExtentTest;
    }

    private ExtentTest createScenarioOutlineExtentTest(ExtentTest parentTest, Scenario scenario) {
        String uriStepLines = scenario.getUriStepLines();
        if (this.uriLinesScenarioOutlineTestMap.containsKey(uriStepLines)) {
            return this.uriLinesScenarioOutlineTestMap.get(uriStepLines);
        }
        ExtentTest scenarioOutlineExtentTest = ScenarioOutlineExtentTest.builder().scenarioOutline(scenario).parentTest(parentTest).build().createTest();
        this.uriLinesScenarioOutlineTestMap.put(uriStepLines, scenarioOutlineExtentTest);
        return scenarioOutlineExtentTest;
    }

    private void createStepHookExtentTests(ExtentTest parentTest, Scenario scenario) {
        this.createBeforeHookExtentTests(parentTest, scenario);
        scenario.getSteps().forEach(step -> {
            this.stepProcessor.setStep((Step)step);
            this.stepProcessor.process();
            this.createBeforeStepHookExtentTests(parentTest, (Step)step);
            this.createStepExtentNode(parentTest, (Step)step);
            this.createAfterStepHookExtentTests(parentTest, (Step)step);
        });
        this.createAfterHookExtentTests(parentTest, scenario);
    }

    private void createBeforeHookExtentTests(ExtentTest parentTest, Scenario scenario) {
        HookExtentTest.builder().parentTest(parentTest).hooks(scenario.getBefore()).displayAllHooks(this.displayAllHooks).build().createTests();
    }

    private void createAfterHookExtentTests(ExtentTest parentTest, Scenario scenario) {
        HookExtentTest.builder().parentTest(parentTest).hooks(scenario.getAfter()).displayAllHooks(this.displayAllHooks).build().createTests();
    }

    private void createBeforeStepHookExtentTests(ExtentTest parentTest, Step step) {
        HookExtentTest.builder().parentTest(parentTest).hooks(step.getBefore()).displayAllHooks(this.displayAllHooks).build().createTests();
    }

    private void createAfterStepHookExtentTests(ExtentTest parentTest, Step step) {
        HookExtentTest.builder().parentTest(parentTest).hooks(step.getAfter()).displayAllHooks(this.displayAllHooks).build().createTests();
    }

    private void createStepExtentNode(ExtentTest parentTest, Step step) {
        StepExtentTest.builder().parentTest(parentTest).step(step).strictCucumber6Behavior(this.strictCucumber6Behavior).build().createTest();
    }

    private static boolean $default$displayAllHooks() {
        return true;
    }

    private static boolean $default$strictCucumber6Behavior() {
        return true;
    }

    private static AdditionalInformationProcessor $default$featureAddInfoProcessor() {
        return AdditionalInformationProcessor.noAddInfoProcessor();
    }

    private static AdditionalInformationProcessor $default$scenarioAddInfoProcessor() {
        return AdditionalInformationProcessor.noAddInfoProcessor();
    }

    ExtentTestHeirarchy(List<Feature> features, ExtentReports extent, boolean displayAllHooks, boolean strictCucumber6Behavior, AdditionalInformationProcessor featureAddInfoProcessor, AdditionalInformationProcessor scenarioAddInfoProcessor) {
        this.features = features;
        this.extent = extent;
        this.displayAllHooks = displayAllHooks;
        this.strictCucumber6Behavior = strictCucumber6Behavior;
        this.featureAddInfoProcessor = featureAddInfoProcessor;
        this.scenarioAddInfoProcessor = scenarioAddInfoProcessor;
    }

    public static ExtentTestHeirarchyBuilder builder() {
        return new ExtentTestHeirarchyBuilder();
    }

    public static class ExtentTestHeirarchyBuilder {
        private List<Feature> features;
        private ExtentReports extent;
        private boolean displayAllHooks$set;
        private boolean displayAllHooks$value;
        private boolean strictCucumber6Behavior$set;
        private boolean strictCucumber6Behavior$value;
        private boolean featureAddInfoProcessor$set;
        private AdditionalInformationProcessor featureAddInfoProcessor$value;
        private boolean scenarioAddInfoProcessor$set;
        private AdditionalInformationProcessor scenarioAddInfoProcessor$value;

        ExtentTestHeirarchyBuilder() {
        }

        public ExtentTestHeirarchyBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public ExtentTestHeirarchyBuilder extent(ExtentReports extent) {
            this.extent = extent;
            return this;
        }

        public ExtentTestHeirarchyBuilder displayAllHooks(boolean displayAllHooks) {
            this.displayAllHooks$value = displayAllHooks;
            this.displayAllHooks$set = true;
            return this;
        }

        public ExtentTestHeirarchyBuilder strictCucumber6Behavior(boolean strictCucumber6Behavior) {
            this.strictCucumber6Behavior$value = strictCucumber6Behavior;
            this.strictCucumber6Behavior$set = true;
            return this;
        }

        public ExtentTestHeirarchyBuilder featureAddInfoProcessor(AdditionalInformationProcessor featureAddInfoProcessor) {
            this.featureAddInfoProcessor$value = featureAddInfoProcessor;
            this.featureAddInfoProcessor$set = true;
            return this;
        }

        public ExtentTestHeirarchyBuilder scenarioAddInfoProcessor(AdditionalInformationProcessor scenarioAddInfoProcessor) {
            this.scenarioAddInfoProcessor$value = scenarioAddInfoProcessor;
            this.scenarioAddInfoProcessor$set = true;
            return this;
        }

        public ExtentTestHeirarchy build() {
            boolean displayAllHooks$value = this.displayAllHooks$value;
            if (!this.displayAllHooks$set) {
                displayAllHooks$value = ExtentTestHeirarchy.$default$displayAllHooks();
            }
            boolean strictCucumber6Behavior$value = this.strictCucumber6Behavior$value;
            if (!this.strictCucumber6Behavior$set) {
                strictCucumber6Behavior$value = ExtentTestHeirarchy.$default$strictCucumber6Behavior();
            }
            AdditionalInformationProcessor featureAddInfoProcessor$value = this.featureAddInfoProcessor$value;
            if (!this.featureAddInfoProcessor$set) {
                featureAddInfoProcessor$value = ExtentTestHeirarchy.$default$featureAddInfoProcessor();
            }
            AdditionalInformationProcessor scenarioAddInfoProcessor$value = this.scenarioAddInfoProcessor$value;
            if (!this.scenarioAddInfoProcessor$set) {
                scenarioAddInfoProcessor$value = ExtentTestHeirarchy.$default$scenarioAddInfoProcessor();
            }
            return new ExtentTestHeirarchy(this.features, this.extent, displayAllHooks$value, strictCucumber6Behavior$value, featureAddInfoProcessor$value, scenarioAddInfoProcessor$value);
        }

        public String toString() {
            return "ExtentTestHeirarchy.ExtentTestHeirarchyBuilder(features=" + this.features + ", extent=" + this.extent + ", displayAllHooks$value=" + this.displayAllHooks$value + ", strictCucumber6Behavior$value=" + this.strictCucumber6Behavior$value + ", featureAddInfoProcessor$value=" + this.featureAddInfoProcessor$value + ", scenarioAddInfoProcessor$value=" + this.scenarioAddInfoProcessor$value + ")";
        }
    }
}

