/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.tests;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import tech.grasshopper.pojo.Result;
import tech.grasshopper.processor.ExceptionProcessor;

public class ExtentTestResult {
    private ExtentTest extentTest;
    private Result result;
    private boolean strictCucumber6Behavior;

    public void updateTestLogStatus() {
        String stepStatus = this.result.getStatus();
        Throwable parsedException = null;
        if (stepStatus.equalsIgnoreCase("failed") || stepStatus.equalsIgnoreCase("undefined") && this.strictCucumber6Behavior || stepStatus.equalsIgnoreCase("pending") && this.strictCucumber6Behavior) {
            parsedException = this.result.getErrorMessage() == null ? new Exception("Generic Exception - Step is " + stepStatus) : ExceptionProcessor.builder().result(this.result).build().process();
            parsedException.setStackTrace(new StackTraceElement[0]);
        }
        if (stepStatus.equalsIgnoreCase("failed")) {
            this.extentTest.fail(parsedException);
        } else if (stepStatus.equalsIgnoreCase("passed")) {
            this.extentTest.pass("");
        } else if (stepStatus.equalsIgnoreCase("undefined") && this.strictCucumber6Behavior) {
            this.extentTest.fail(parsedException);
        } else if (stepStatus.equalsIgnoreCase("undefined")) {
            this.extentTest.skip(MarkupHelper.createCodeBlock((String)"Step is undefined"));
        } else if (stepStatus.equalsIgnoreCase("pending") && this.strictCucumber6Behavior) {
            this.extentTest.fail(parsedException);
        } else if (stepStatus.equalsIgnoreCase("pending")) {
            this.extentTest.skip(MarkupHelper.createCodeBlock((String)this.result.getErrorMessage()));
        } else if (stepStatus.equalsIgnoreCase("skipped") && this.result.getErrorMessage() != null) {
            this.extentTest.skip(MarkupHelper.createCodeBlock((String)this.result.getErrorMessage()));
        } else {
            this.extentTest.skip("");
        }
    }

    private static boolean $default$strictCucumber6Behavior() {
        return true;
    }

    ExtentTestResult(ExtentTest extentTest, Result result, boolean strictCucumber6Behavior) {
        this.extentTest = extentTest;
        this.result = result;
        this.strictCucumber6Behavior = strictCucumber6Behavior;
    }

    public static ExtentTestResultBuilder builder() {
        return new ExtentTestResultBuilder();
    }

    public static class ExtentTestResultBuilder {
        private ExtentTest extentTest;
        private Result result;
        private boolean strictCucumber6Behavior$set;
        private boolean strictCucumber6Behavior$value;

        ExtentTestResultBuilder() {
        }

        public ExtentTestResultBuilder extentTest(ExtentTest extentTest) {
            this.extentTest = extentTest;
            return this;
        }

        public ExtentTestResultBuilder result(Result result) {
            this.result = result;
            return this;
        }

        public ExtentTestResultBuilder strictCucumber6Behavior(boolean strictCucumber6Behavior) {
            this.strictCucumber6Behavior$value = strictCucumber6Behavior;
            this.strictCucumber6Behavior$set = true;
            return this;
        }

        public ExtentTestResult build() {
            boolean strictCucumber6Behavior$value = this.strictCucumber6Behavior$value;
            if (!this.strictCucumber6Behavior$set) {
                strictCucumber6Behavior$value = ExtentTestResult.$default$strictCucumber6Behavior();
            }
            return new ExtentTestResult(this.extentTest, this.result, strictCucumber6Behavior$value);
        }

        public String toString() {
            return "ExtentTestResult.ExtentTestResultBuilder(extentTest=" + this.extentTest + ", result=" + this.result + ", strictCucumber6Behavior$value=" + this.strictCucumber6Behavior$value + ")";
        }
    }
}

