/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.tests;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.gherkin.model.Asterisk;
import com.aventstack.extentreports.model.Test;
import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.pojo.Hook;
import tech.grasshopper.processor.EmbeddedProcessor;
import tech.grasshopper.tests.ExtentTestResult;

public class HookExtentTest {
    private List<Hook> hooks;
    private ExtentTest parentTest;
    private boolean displayAllHooks;
    private boolean strictCucumber6Behavior;

    public List<ExtentTest> createTests() {
        ArrayList<ExtentTest> hookTests = new ArrayList<ExtentTest>();
        if (!this.displayAllHooks) {
            this.hooks.removeIf(h -> h.getEmbeddings().isEmpty() && h.getOutput().isEmpty());
        }
        this.hooks.forEach(h -> hookTests.add(this.createTest((Hook)h)));
        return hookTests;
    }

    private ExtentTest createTest(Hook hook) {
        ExtentTest hookExtentTest = this.parentTest.createNode(Asterisk.class, hook.getMatch().getLocation(), hook.getHookType().toString().toUpperCase());
        hook.setTestId(hookExtentTest.getModel().getId());
        hook.getOutput().forEach(o -> hookExtentTest.info(o));
        EmbeddedProcessor.builder().test(hookExtentTest).embeddings(hook.getEmbeddings()).build().process();
        ExtentTestResult.builder().extentTest(hookExtentTest).result(hook.getResult()).strictCucumber6Behavior(this.strictCucumber6Behavior).build().updateTestLogStatus();
        Test test = hookExtentTest.getModel();
        test.setStartTime(hook.getStartTime());
        test.setEndTime(hook.getEndTime());
        return hookExtentTest;
    }

    private static boolean $default$displayAllHooks() {
        return true;
    }

    private static boolean $default$strictCucumber6Behavior() {
        return true;
    }

    HookExtentTest(List<Hook> hooks, ExtentTest parentTest, boolean displayAllHooks, boolean strictCucumber6Behavior) {
        this.hooks = hooks;
        this.parentTest = parentTest;
        this.displayAllHooks = displayAllHooks;
        this.strictCucumber6Behavior = strictCucumber6Behavior;
    }

    public static HookExtentTestBuilder builder() {
        return new HookExtentTestBuilder();
    }

    public static class HookExtentTestBuilder {
        private List<Hook> hooks;
        private ExtentTest parentTest;
        private boolean displayAllHooks$set;
        private boolean displayAllHooks$value;
        private boolean strictCucumber6Behavior$set;
        private boolean strictCucumber6Behavior$value;

        HookExtentTestBuilder() {
        }

        public HookExtentTestBuilder hooks(List<Hook> hooks) {
            this.hooks = hooks;
            return this;
        }

        public HookExtentTestBuilder parentTest(ExtentTest parentTest) {
            this.parentTest = parentTest;
            return this;
        }

        public HookExtentTestBuilder displayAllHooks(boolean displayAllHooks) {
            this.displayAllHooks$value = displayAllHooks;
            this.displayAllHooks$set = true;
            return this;
        }

        public HookExtentTestBuilder strictCucumber6Behavior(boolean strictCucumber6Behavior) {
            this.strictCucumber6Behavior$value = strictCucumber6Behavior;
            this.strictCucumber6Behavior$set = true;
            return this;
        }

        public HookExtentTest build() {
            boolean displayAllHooks$value = this.displayAllHooks$value;
            if (!this.displayAllHooks$set) {
                displayAllHooks$value = HookExtentTest.$default$displayAllHooks();
            }
            boolean strictCucumber6Behavior$value = this.strictCucumber6Behavior$value;
            if (!this.strictCucumber6Behavior$set) {
                strictCucumber6Behavior$value = HookExtentTest.$default$strictCucumber6Behavior();
            }
            return new HookExtentTest(this.hooks, this.parentTest, displayAllHooks$value, strictCucumber6Behavior$value);
        }

        public String toString() {
            return "HookExtentTest.HookExtentTestBuilder(hooks=" + this.hooks + ", parentTest=" + this.parentTest + ", displayAllHooks$value=" + this.displayAllHooks$value + ", strictCucumber6Behavior$value=" + this.strictCucumber6Behavior$value + ")";
        }
    }
}

