/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.tests;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.model.Test;
import tech.grasshopper.pojo.Scenario;

public class ScenarioExtentTest {
    private Scenario scenario;
    private ExtentTest parentTest;

    public ExtentTest createTest() {
        ExtentTest scenarioExtentTest = this.parentTest.createNode(com.aventstack.extentreports.gherkin.model.Scenario.class, this.scenario.getName(), this.scenario.getDescription());
        this.scenario.getTags().forEach(t -> scenarioExtentTest.assignCategory(new String[]{t.getName()}));
        Test test = scenarioExtentTest.getModel();
        test.setStartTime(this.scenario.getStartTime());
        test.setEndTime(this.scenario.getEndTime());
        this.scenario.setTestId(test.getId());
        return scenarioExtentTest;
    }

    ScenarioExtentTest(Scenario scenario, ExtentTest parentTest) {
        this.scenario = scenario;
        this.parentTest = parentTest;
    }

    public static ScenarioExtentTestBuilder builder() {
        return new ScenarioExtentTestBuilder();
    }

    public static class ScenarioExtentTestBuilder {
        private Scenario scenario;
        private ExtentTest parentTest;

        ScenarioExtentTestBuilder() {
        }

        public ScenarioExtentTestBuilder scenario(Scenario scenario) {
            this.scenario = scenario;
            return this;
        }

        public ScenarioExtentTestBuilder parentTest(ExtentTest parentTest) {
            this.parentTest = parentTest;
            return this;
        }

        public ScenarioExtentTest build() {
            return new ScenarioExtentTest(this.scenario, this.parentTest);
        }

        public String toString() {
            return "ScenarioExtentTest.ScenarioExtentTestBuilder(scenario=" + this.scenario + ", parentTest=" + this.parentTest + ")";
        }
    }
}

