/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.tests;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.gherkin.model.ScenarioOutline;
import java.util.Arrays;
import java.util.stream.Collectors;
import tech.grasshopper.pojo.Scenario;

public class ScenarioOutlineExtentTest {
    private Scenario scenarioOutline;
    private ExtentTest parentTest;

    public ExtentTest createTest() {
        ExtentTest scenarioOutlineExtentTest = this.parentTest.createNode(ScenarioOutline.class, this.parseTestNameFromId(this.scenarioOutline.getId()), this.scenarioOutline.getDescription());
        return scenarioOutlineExtentTest;
    }

    private String parseTestNameFromId(String id) {
        String[] splits = id.split(";");
        if (splits.length != 4) {
            return id;
        }
        String[] name = splits[1].split("-");
        return Arrays.stream(name).map(t -> {
            if (t.length() == 1) {
                return t.toUpperCase();
            }
            if (t.length() > 1) {
                return t.substring(0, 1).toUpperCase() + t.substring(1);
            }
            return "";
        }).collect(Collectors.joining(" "));
    }

    ScenarioOutlineExtentTest(Scenario scenarioOutline, ExtentTest parentTest) {
        this.scenarioOutline = scenarioOutline;
        this.parentTest = parentTest;
    }

    public static ScenarioOutlineExtentTestBuilder builder() {
        return new ScenarioOutlineExtentTestBuilder();
    }

    public static class ScenarioOutlineExtentTestBuilder {
        private Scenario scenarioOutline;
        private ExtentTest parentTest;

        ScenarioOutlineExtentTestBuilder() {
        }

        public ScenarioOutlineExtentTestBuilder scenarioOutline(Scenario scenarioOutline) {
            this.scenarioOutline = scenarioOutline;
            return this;
        }

        public ScenarioOutlineExtentTestBuilder parentTest(ExtentTest parentTest) {
            this.parentTest = parentTest;
            return this;
        }

        public ScenarioOutlineExtentTest build() {
            return new ScenarioOutlineExtentTest(this.scenarioOutline, this.parentTest);
        }

        public String toString() {
            return "ScenarioOutlineExtentTest.ScenarioOutlineExtentTestBuilder(scenarioOutline=" + this.scenarioOutline + ", parentTest=" + this.parentTest + ")";
        }
    }
}

