/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.tests;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.model.Test;
import tech.grasshopper.pojo.Step;
import tech.grasshopper.processor.EmbeddedProcessor;
import tech.grasshopper.tests.ExtentTestResult;

public class StepExtentTest {
    private Step step;
    private ExtentTest parentTest;
    private boolean strictCucumber6Behavior;

    public ExtentTest createTest() {
        ExtentTest stepExtentTest = null;
        GherkinKeyword keyword = null;
        try {
            keyword = new GherkinKeyword("And");
            keyword = new GherkinKeyword(this.step.getKeyword().trim());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        stepExtentTest = this.parentTest.createNode(keyword, this.step.getKeyword() + this.step.getName(), this.step.getMatch().getLocation());
        this.step.setTestId(stepExtentTest.getModel().getId());
        Test test = stepExtentTest.getModel();
        test.setStartTime(this.step.getStartTime());
        test.setEndTime(this.step.getEndTime());
        if (this.step.getRows().size() > 0) {
            stepExtentTest.pass(this.step.getDataTableMarkup());
        }
        if (this.step.getDocStringMarkup() != null) {
            stepExtentTest.pass(this.step.getDocStringMarkup());
        }
        for (String msg : this.step.getOutput()) {
            stepExtentTest.info(msg);
        }
        if (this.step.getEmbeddings().size() > 0) {
            EmbeddedProcessor.builder().test(stepExtentTest).embeddings(this.step.getEmbeddings()).build().process();
        }
        ExtentTestResult.builder().extentTest(stepExtentTest).result(this.step.getResult()).strictCucumber6Behavior(this.strictCucumber6Behavior).build().updateTestLogStatus();
        return stepExtentTest;
    }

    private static boolean $default$strictCucumber6Behavior() {
        return true;
    }

    StepExtentTest(Step step, ExtentTest parentTest, boolean strictCucumber6Behavior) {
        this.step = step;
        this.parentTest = parentTest;
        this.strictCucumber6Behavior = strictCucumber6Behavior;
    }

    public static StepExtentTestBuilder builder() {
        return new StepExtentTestBuilder();
    }

    public static class StepExtentTestBuilder {
        private Step step;
        private ExtentTest parentTest;
        private boolean strictCucumber6Behavior$set;
        private boolean strictCucumber6Behavior$value;

        StepExtentTestBuilder() {
        }

        public StepExtentTestBuilder step(Step step) {
            this.step = step;
            return this;
        }

        public StepExtentTestBuilder parentTest(ExtentTest parentTest) {
            this.parentTest = parentTest;
            return this;
        }

        public StepExtentTestBuilder strictCucumber6Behavior(boolean strictCucumber6Behavior) {
            this.strictCucumber6Behavior$value = strictCucumber6Behavior;
            this.strictCucumber6Behavior$set = true;
            return this;
        }

        public StepExtentTest build() {
            boolean strictCucumber6Behavior$value = this.strictCucumber6Behavior$value;
            if (!this.strictCucumber6Behavior$set) {
                strictCucumber6Behavior$value = StepExtentTest.$default$strictCucumber6Behavior();
            }
            return new StepExtentTest(this.step, this.parentTest, strictCucumber6Behavior$value);
        }

        public String toString() {
            return "StepExtentTest.StepExtentTestBuilder(step=" + this.step + ", parentTest=" + this.parentTest + ", strictCucumber6Behavior$value=" + this.strictCucumber6Behavior$value + ")";
        }
    }
}

