/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.data;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import tech.grasshopper.pdf.data.ReportData;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Hook;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.pojo.cucumber.Step;
import tech.grasshopper.pdf.util.DateUtil;
import tech.grasshopper.pojo.Embedded;
import tech.grasshopper.pojo.Row;
import tech.grasshopper.pojo.Scenario;

public class PDFCucumberReportDataGenerator {
    public ReportData generateReportData(List<tech.grasshopper.pojo.Feature> cukeFeatures) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (tech.grasshopper.pojo.Feature cukeFeature : cukeFeatures) {
            ArrayList<Status> scenarioStatuses = new ArrayList<Status>();
            ArrayList<tech.grasshopper.pdf.pojo.cucumber.Scenario> scenarios = new ArrayList<tech.grasshopper.pdf.pojo.cucumber.Scenario>();
            LocalDateTime featureStartTime = DateUtil.convertToLocalDateTimeFromTimeStamp((String)cukeFeature.getElements().get(0).getStartTimestamp());
            LocalDateTime startTime = null;
            LocalDateTime endTime = null;
            for (Scenario cukeScenario : cukeFeature.getElements()) {
                ArrayList<Step> steps = new ArrayList<Step>();
                ArrayList<Status> stepHookStatuses = new ArrayList<Status>();
                ArrayList<Hook> beforeHooks = new ArrayList<Hook>();
                ArrayList<Hook> afterHooks = new ArrayList<Hook>();
                startTime = DateUtil.convertToLocalDateTimeFromTimeStamp((String)cukeScenario.getStartTimestamp());
                startTime = this.createHooks(cukeScenario.getBefore(), startTime, beforeHooks, Hook.HookType.BEFORE, stepHookStatuses);
                for (tech.grasshopper.pojo.Step cukeStep : cukeScenario.getSteps()) {
                    ArrayList<Hook> beforeStepHooks = new ArrayList<Hook>();
                    ArrayList<Hook> afterStepHooks = new ArrayList<Hook>();
                    startTime = this.createHooks(cukeStep.getBefore(), startTime, beforeStepHooks, Hook.HookType.BEFORE_STEP, stepHookStatuses);
                    endTime = startTime.plusNanos(cukeStep.getResult().getDuration());
                    steps.add(((Step.StepBuilder)((Step.StepBuilder)Step.builder().name(cukeStep.getName()).before(beforeStepHooks).after(afterStepHooks).status(this.convertStatus(cukeStep.getResult().getStatus())).keyword(cukeStep.getKeyword()).docString(cukeStep.getDocString().getValue()).rows(this.convertRows(cukeStep.getRows())).errorMessage(cukeStep.getResult().getErrorMessage()).output(cukeStep.getOutput()).media(this.getMediaData(cukeStep.getEmbeddings())).startTime(startTime)).endTime(endTime)).build());
                    startTime = LocalDateTime.from(endTime);
                    stepHookStatuses.add(this.convertStatus(cukeStep.getResult().getStatus()));
                    startTime = this.createHooks(cukeStep.getAfter(), startTime, afterStepHooks, Hook.HookType.AFTER_STEP, stepHookStatuses);
                }
                startTime = this.createHooks(cukeScenario.getBefore(), startTime, afterHooks, Hook.HookType.AFTER, stepHookStatuses);
                tech.grasshopper.pdf.pojo.cucumber.Scenario scenario = ((Scenario.ScenarioBuilder)((Scenario.ScenarioBuilder)tech.grasshopper.pdf.pojo.cucumber.Scenario.builder().name(cukeScenario.getName()).tags(cukeScenario.getTags().stream().map(t -> t.getName()).collect(Collectors.toList())).steps(steps).before(beforeHooks).after(afterHooks).status(Collections.max(stepHookStatuses)).startTime(DateUtil.convertToLocalDateTimeFromTimeStamp((String)cukeScenario.getStartTimestamp()))).endTime(startTime)).build();
                scenarios.add(scenario);
                scenarioStatuses.add(Collections.max(stepHookStatuses));
            }
            Feature feature = ((Feature.FeatureBuilder)((Feature.FeatureBuilder)Feature.builder().name(cukeFeature.getName()).tags(cukeFeature.getTags().stream().map(t -> t.getName()).collect(Collectors.toList())).scenarios(scenarios).status((Status)Collections.max(scenarioStatuses)).startTime(featureStartTime)).endTime(startTime)).build();
            features.add(feature);
        }
        return ReportData.builder().features(features).build();
    }

    private LocalDateTime createHooks(List<tech.grasshopper.pojo.Hook> hooks, LocalDateTime startTime, List<Hook> collectHooks, Hook.HookType hookType, List<Status> statuses) {
        LocalDateTime endTime = LocalDateTime.from(startTime);
        for (tech.grasshopper.pojo.Hook hook : hooks) {
            endTime = startTime.plusNanos(hook.getResult().getDuration());
            collectHooks.add(((Hook.HookBuilder)((Hook.HookBuilder)Hook.builder().hookType(hookType).status(this.convertStatus(hook.getResult().getStatus().toUpperCase())).location(hook.getMatch().getLocation()).errorMessage(hook.getResult().getErrorMessage()).output(hook.getOutput()).media(this.getMediaData(hook.getEmbeddings())).startTime(startTime)).endTime(endTime)).build());
            startTime = LocalDateTime.from(endTime);
            statuses.add(this.convertStatus(hook.getResult().getStatus()));
        }
        return endTime;
    }

    private Status convertStatus(String statusStr) {
        Status status = Status.SKIPPED;
        if (statusStr.equalsIgnoreCase("passed")) {
            status = Status.PASSED;
        } else if (statusStr.equalsIgnoreCase("failed")) {
            status = Status.FAILED;
        }
        return status;
    }

    private List<String> getMediaData(List<Embedded> embeddings) {
        return embeddings.stream().map(e -> e.getFilePath()).collect(Collectors.toList());
    }

    private List<tech.grasshopper.pdf.pojo.cucumber.Row> convertRows(List<Row> rows) {
        ArrayList<tech.grasshopper.pdf.pojo.cucumber.Row> pdfRows = new ArrayList<tech.grasshopper.pdf.pojo.cucumber.Row>();
        rows.forEach(r -> pdfRows.add(tech.grasshopper.pdf.pojo.cucumber.Row.builder().cells(r.getCells()).build()));
        return pdfRows;
    }
}

