/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.bookmark;

import java.util.List;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.data.ReportData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;

public class Bookmark {
    private ReportConfig reportConfig;
    private static String REPORT_CHAPTERS_BOOKMARK_TEXT = "Report Chapters";
    private static String DETAILED_CHAPTER_BOOKMARK_TEXT = "Detailed Chapter";

    public PDDocumentOutline createDocumentOutline(Destination.ChapterDestinationStore destinations, ReportData reportData) {
        PDDocumentOutline outline = new PDDocumentOutline();
        PDOutlineItem chaptersOutline = new PDOutlineItem();
        chaptersOutline.setTitle(REPORT_CHAPTERS_BOOKMARK_TEXT);
        chaptersOutline.setBold(true);
        outline.addLast(chaptersOutline);
        chaptersOutline.addLast(this.createOutlineItem(destinations.getSummaryChapterDestination(), "Summary"));
        if (this.reportConfig.isDisplayFeature()) {
            PDOutlineItem featureChapterBookmark = this.createChapterOutlineItems(destinations.getFeatureChapterDestinations(), "Features");
            chaptersOutline.addLast(featureChapterBookmark);
        }
        if (this.reportConfig.isDisplayScenario()) {
            PDOutlineItem scenarioChapterBookmark = this.createChapterOutlineItems(destinations.getScenarioChapterDestinations(), "Scenarios");
            chaptersOutline.addLast(scenarioChapterBookmark);
            chaptersOutline.openNode();
        }
        if (this.reportConfig.isDisplayDetailed()) {
            PDOutlineItem detailedPagesOutline = new PDOutlineItem();
            detailedPagesOutline.setTitle(DETAILED_CHAPTER_BOOKMARK_TEXT);
            detailedPagesOutline.setBold(true);
            for (Feature feature : reportData.getFeatures()) {
                PDOutlineItem featureBookmark = this.createOutlineItem((PDDestination)feature.getDestination(), TextLengthOptimizer.optimizeOutlineText("F " + feature.getName()));
                detailedPagesOutline.addLast(featureBookmark);
                for (Scenario scenario : feature.getScenarios()) {
                    PDOutlineItem scenaroBookmark = this.createOutlineItem((PDDestination)scenario.getDestination(), TextLengthOptimizer.optimizeOutlineText("S " + scenario.getName()));
                    detailedPagesOutline.addLast(scenaroBookmark);
                }
            }
            outline.addLast(detailedPagesOutline);
        }
        return outline;
    }

    private PDOutlineItem createOutlineItem(Destination destination, String title) {
        return this.createOutlineItem((PDDestination)destination.createPDPageDestination(), title);
    }

    private PDOutlineItem createOutlineItem(Destination destination) {
        return this.createOutlineItem(destination, destination.getName());
    }

    private PDOutlineItem createOutlineItem(PDDestination destination, String title) {
        PDOutlineItem bookmark = new PDOutlineItem();
        bookmark.setDestination(destination);
        bookmark.setTitle(title);
        return bookmark;
    }

    private PDOutlineItem createChapterOutlineItems(List<Destination> destinations, String title) {
        PDOutlineItem chapterBookmark = this.createOutlineItem(destinations.get(0), title);
        destinations.forEach(d -> {
            PDOutlineItem pagesBookmark = this.createOutlineItem((Destination)d);
            chapterBookmark.addLast(pagesBookmark);
        });
        return chapterBookmark;
    }

    Bookmark(ReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    public static BookmarkBuilder builder() {
        return new BookmarkBuilder();
    }

    public static class BookmarkBuilder {
        private ReportConfig reportConfig;

        BookmarkBuilder() {
        }

        public BookmarkBuilder reportConfig(ReportConfig reportConfig) {
            this.reportConfig = reportConfig;
            return this;
        }

        public Bookmark build() {
            return new Bookmark(this.reportConfig);
        }

        public String toString() {
            return "Bookmark.BookmarkBuilder(reportConfig=" + this.reportConfig + ")";
        }
    }
}

