/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.destination.Destination;

public abstract class Chapter {
    protected PDDocument document;
    protected PDPageContentStream content;
    protected Destination.ChapterDestinationStore destinations;
    protected DisplayData displayData;
    protected ReportConfig reportConfig;

    public abstract void createChapter();

    protected Chapter(ChapterBuilder<?, ?> b) {
        this.document = ((ChapterBuilder)b).document;
        this.content = ((ChapterBuilder)b).content;
        this.destinations = ((ChapterBuilder)b).destinations;
        this.displayData = ((ChapterBuilder)b).displayData;
        this.reportConfig = ((ChapterBuilder)b).reportConfig;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public PDPageContentStream getContent() {
        return this.content;
    }

    public Destination.ChapterDestinationStore getDestinations() {
        return this.destinations;
    }

    public DisplayData getDisplayData() {
        return this.displayData;
    }

    public ReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public void setDestinations(Destination.ChapterDestinationStore destinations) {
        this.destinations = destinations;
    }

    public void setDisplayData(DisplayData displayData) {
        this.displayData = displayData;
    }

    public void setReportConfig(ReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chapter)) {
            return false;
        }
        Chapter other = (Chapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        PDPageContentStream this$content = this.getContent();
        PDPageContentStream other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Destination.ChapterDestinationStore this$destinations = this.getDestinations();
        Destination.ChapterDestinationStore other$destinations = other.getDestinations();
        if (this$destinations == null ? other$destinations != null : !((Object)this$destinations).equals(other$destinations)) {
            return false;
        }
        DisplayData this$displayData = this.getDisplayData();
        DisplayData other$displayData = other.getDisplayData();
        if (this$displayData == null ? other$displayData != null : !this$displayData.equals(other$displayData)) {
            return false;
        }
        ReportConfig this$reportConfig = this.getReportConfig();
        ReportConfig other$reportConfig = other.getReportConfig();
        return !(this$reportConfig == null ? other$reportConfig != null : !((Object)this$reportConfig).equals(other$reportConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Chapter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        PDPageContentStream $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Destination.ChapterDestinationStore $destinations = this.getDestinations();
        result = result * 59 + ($destinations == null ? 43 : ((Object)$destinations).hashCode());
        DisplayData $displayData = this.getDisplayData();
        result = result * 59 + ($displayData == null ? 43 : $displayData.hashCode());
        ReportConfig $reportConfig = this.getReportConfig();
        result = result * 59 + ($reportConfig == null ? 43 : ((Object)$reportConfig).hashCode());
        return result;
    }

    public String toString() {
        return "Chapter(document=" + this.getDocument() + ", content=" + this.getContent() + ", destinations=" + this.getDestinations() + ", displayData=" + this.getDisplayData() + ", reportConfig=" + this.getReportConfig() + ")";
    }

    public static abstract class ChapterBuilder<C extends Chapter, B extends ChapterBuilder<C, B>> {
        private PDDocument document;
        private PDPageContentStream content;
        private Destination.ChapterDestinationStore destinations;
        private DisplayData displayData;
        private ReportConfig reportConfig;

        protected abstract B self();

        public abstract C build();

        public B document(PDDocument document) {
            this.document = document;
            return this.self();
        }

        public B content(PDPageContentStream content) {
            this.content = content;
            return this.self();
        }

        public B destinations(Destination.ChapterDestinationStore destinations) {
            this.destinations = destinations;
            return this.self();
        }

        public B displayData(DisplayData displayData) {
            this.displayData = displayData;
            return this.self();
        }

        public B reportConfig(ReportConfig reportConfig) {
            this.reportConfig = reportConfig;
            return this.self();
        }

        public String toString() {
            return "Chapter.ChapterBuilder(document=" + this.document + ", content=" + this.content + ", destinations=" + this.destinations + ", displayData=" + this.displayData + ", reportConfig=" + this.reportConfig + ")";
        }
    }
}

