/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.pdf.chapter.Chapter;
import tech.grasshopper.pdf.chapter.detailed.DetailedFeatureComponent;
import tech.grasshopper.pdf.chapter.detailed.DetailedPage;
import tech.grasshopper.pdf.chapter.detailed.DetailedRowComponent;
import tech.grasshopper.pdf.chapter.detailed.DetailedScenarioComponent;
import tech.grasshopper.pdf.chapter.detailed.StepOrHookRow;
import tech.grasshopper.pdf.chapter.page.Page;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;

public class DetailedChapter
extends Chapter {
    private int contentHeight;
    private FeatureData detailedData;

    @Override
    public void createChapter() {
        this.createAndSendPageData();
    }

    public void createAndSendPageData() {
        ArrayList<Component> components = new ArrayList<Component>();
        ArrayList<StepOrHookRow> rows = new ArrayList<StepOrHookRow>();
        this.detailedData = (FeatureData)this.displayData;
        for (Feature feature : this.detailedData.getFeatures()) {
            if (!this.checkComponentFitment(195)) {
                this.sendToPage(components);
                components = new ArrayList();
                this.contentHeight = 0;
            }
            components.add(((DetailedFeatureComponent.DetailedFeatureComponentBuilder)((DetailedFeatureComponent.DetailedFeatureComponentBuilder)((DetailedFeatureComponent.DetailedFeatureComponentBuilder)((DetailedFeatureComponent.DetailedFeatureComponentBuilder)((DetailedFeatureComponent.DetailedFeatureComponentBuilder)DetailedFeatureComponent.builder().document(this.document)).content(this.content)).reportConfig(this.reportConfig)).feature(feature)).startHeight(800 - this.contentHeight)).build());
            this.contentHeight += 195;
            for (Scenario scenario : feature.getScenarios()) {
                if (!this.checkComponentFitment(195)) {
                    this.sendToPage(components);
                    components = new ArrayList();
                    this.contentHeight = 0;
                }
                components.add(((DetailedScenarioComponent.DetailedScenarioComponentBuilder)((DetailedScenarioComponent.DetailedScenarioComponentBuilder)((DetailedScenarioComponent.DetailedScenarioComponentBuilder)((DetailedScenarioComponent.DetailedScenarioComponentBuilder)((DetailedScenarioComponent.DetailedScenarioComponentBuilder)((DetailedScenarioComponent.DetailedScenarioComponentBuilder)DetailedScenarioComponent.builder().document(this.document)).content(this.content)).reportConfig(this.reportConfig)).feature(feature)).scenario(scenario)).startHeight(800 - this.contentHeight)).build());
                this.contentHeight += 195;
                rows = new ArrayList();
                int stepCompHeight = this.contentHeight;
                int initialSno = 1;
                int stepCnt = 0;
                int i = 0;
                while (i < scenario.getAllStepsAndHooks().size()) {
                    StepOrHookRow row = scenario.getAllStepsAndHooks().get(i);
                    row.setReportConfig(this.reportConfig);
                    rows.add(row);
                    int rowHeight = row.getRowHeight();
                    if (rows.size() == 1) {
                        rowHeight += 22;
                    }
                    stepCnt = row.incrementSerialNumber(stepCnt);
                    if (!this.checkComponentFitment(rowHeight)) {
                        rows.remove(rows.size() - 1);
                        stepCnt = row.decrementStepCount(stepCnt);
                        if (!rows.isEmpty()) {
                            components.add(((DetailedRowComponent.DetailedRowComponentBuilder)((DetailedRowComponent.DetailedRowComponentBuilder)((DetailedRowComponent.DetailedRowComponentBuilder)((DetailedRowComponent.DetailedRowComponentBuilder)((DetailedRowComponent.DetailedRowComponentBuilder)DetailedRowComponent.builder().content(this.content)).reportConfig(this.reportConfig)).rows(rows)).initialSno(initialSno)).startHeight(800 - stepCompHeight)).build());
                        }
                        this.sendToPage(components);
                        rows = new ArrayList();
                        rows.add(row);
                        components = new ArrayList();
                        stepCompHeight = 0;
                        this.contentHeight = rowHeight + 22;
                        initialSno += stepCnt;
                    } else {
                        this.contentHeight += rowHeight;
                    }
                    ++i;
                }
                if (rows.isEmpty()) continue;
                components.add(((DetailedRowComponent.DetailedRowComponentBuilder)((DetailedRowComponent.DetailedRowComponentBuilder)((DetailedRowComponent.DetailedRowComponentBuilder)((DetailedRowComponent.DetailedRowComponentBuilder)((DetailedRowComponent.DetailedRowComponentBuilder)DetailedRowComponent.builder().content(this.content)).reportConfig(this.reportConfig)).rows(rows)).initialSno(initialSno)).startHeight(800 - stepCompHeight)).build());
                rows = new ArrayList();
            }
        }
        if (!components.isEmpty()) {
            this.sendToPage(components);
        }
    }

    private boolean checkComponentFitment(int componentHeight) {
        return this.contentHeight + componentHeight <= 750;
    }

    private void sendToPage(List<Component> components) {
        ((DetailedPage)((DetailedPage.DetailedPageBuilder)((DetailedPage.DetailedPageBuilder)((Page.PageBuilder)DetailedPage.builder().components(components)).document(this.document)).destinations(this.destinations)).build()).createPage();
    }

    private static int $default$contentHeight() {
        return 0;
    }

    protected DetailedChapter(DetailedChapterBuilder<?, ?> b) {
        super(b);
        this.contentHeight = ((DetailedChapterBuilder)b).contentHeight$set ? ((DetailedChapterBuilder)b).contentHeight : DetailedChapter.$default$contentHeight();
        this.detailedData = ((DetailedChapterBuilder)b).detailedData;
    }

    public static DetailedChapterBuilder<?, ?> builder() {
        return new DetailedChapterBuilderImpl();
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public FeatureData getDetailedData() {
        return this.detailedData;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public void setDetailedData(FeatureData detailedData) {
        this.detailedData = detailedData;
    }

    @Override
    public String toString() {
        return "DetailedChapter(contentHeight=" + this.getContentHeight() + ", detailedData=" + this.getDetailedData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedChapter)) {
            return false;
        }
        DetailedChapter other = (DetailedChapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContentHeight() != other.getContentHeight()) {
            return false;
        }
        FeatureData this$detailedData = this.getDetailedData();
        FeatureData other$detailedData = other.getDetailedData();
        return !(this$detailedData == null ? other$detailedData != null : !((Object)this$detailedData).equals(other$detailedData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DetailedChapter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContentHeight();
        FeatureData $detailedData = this.getDetailedData();
        result = result * 59 + ($detailedData == null ? 43 : ((Object)$detailedData).hashCode());
        return result;
    }

    public static abstract class DetailedChapterBuilder<C extends DetailedChapter, B extends DetailedChapterBuilder<C, B>>
    extends Chapter.ChapterBuilder<C, B> {
        private int contentHeight;
        private boolean contentHeight$set;
        private FeatureData detailedData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B contentHeight(int contentHeight) {
            this.contentHeight = contentHeight;
            this.contentHeight$set = true;
            return (B)this.self();
        }

        public B detailedData(FeatureData detailedData) {
            this.detailedData = detailedData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DetailedChapter.DetailedChapterBuilder(super=" + super.toString() + ", contentHeight=" + this.contentHeight + ", detailedData=" + this.detailedData + ")";
        }
    }

    private static final class DetailedChapterBuilderImpl
    extends DetailedChapterBuilder<DetailedChapter, DetailedChapterBuilderImpl> {
        private DetailedChapterBuilderImpl() {
        }

        @Override
        protected DetailedChapterBuilderImpl self() {
            return this;
        }

        @Override
        public DetailedChapter build() {
            return new DetailedChapter(this);
        }
    }
}

