/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import java.awt.Color;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.chapter.detailed.StepOrHookRow;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;

public class DetailedRowComponent
extends Component {
    private List<StepOrHookRow> rows;
    private Scenario scenario;
    private Feature feature;
    private int startHeight;
    private int initialSno;
    private static final PDFont NAME_FONT = PDType1Font.HELVETICA_OBLIQUE;
    private static final int NAME_FONT_SIZE = 10;
    private static final PDFont TABLE_DOCSTRING_FONT = PDType1Font.HELVETICA;
    private static final int TABLE_DOCSTRING_FONT_SIZE = 8;
    private static final PDFont OUTPUT_MSG_FONT = PDType1Font.HELVETICA;
    private static final int OUTPUT_MSG_FONT_SIZE = 9;
    private static final int STEP_COLUMN_WIDTH = 340;
    private static final int DOCSTRING_WIDTH = 290;
    private static final int DATACELL_WIDTH = 65;
    private static final int OUTPUT_MSG_WIDTH = 290;
    private static final int PADDING = 5;
    private static final int HEADER_ROW_HEIGHT = 22;
    private final TextLengthOptimizer stepTextOptimizer;
    private final TextLengthOptimizer docStringOptimizer;
    private final TextLengthOptimizer dataCellOptimizer;
    private final TextLengthOptimizer outputMsgOptimizer;

    @Override
    public void display() {
        Table.TableBuilder myTableBuilder = Table.builder().addColumnsOfWidth(new float[]{25.0f, 340.0f, 50.0f, 85.0f}).padding(5.0f).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f).font((PDFont)PDType1Font.HELVETICA_OBLIQUE).fontSize(Integer.valueOf(12)).addRow(Row.builder().height(Float.valueOf(22.0f)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.MIDDLE).add((AbstractCell)TextCell.builder().text("#").build()).add((AbstractCell)TextCell.builder().text("Step / Hook Text").build()).add((AbstractCell)TextCell.builder().text("Status").build()).add((AbstractCell)TextCell.builder().text("Duration").build()).build());
        int i = 0;
        while (i < this.rows.size()) {
            StepOrHookRow row = this.rows.get(i);
            row.setSNo(String.valueOf(this.initialSno));
            myTableBuilder.addRow(row.generateRow());
            this.initialSno = row.incrementSerialNumber(this.initialSno);
            ++i;
        }
        Table myTable = myTableBuilder.build();
        TableDrawer tableDrawer = TableDrawer.builder().contentStream(this.content).startX(50.0f).startY((float)this.startHeight).page(this.page).table(myTable).build();
        tableDrawer.draw();
    }

    private static TextLengthOptimizer $default$stepTextOptimizer() {
        return TextLengthOptimizer.builder().font(NAME_FONT).fontsize(10).spaceWidth(330).build();
    }

    private static TextLengthOptimizer $default$docStringOptimizer() {
        return TextLengthOptimizer.builder().font(TABLE_DOCSTRING_FONT).fontsize(8).spaceWidth(290).build();
    }

    private static TextLengthOptimizer $default$dataCellOptimizer() {
        return TextLengthOptimizer.builder().font(TABLE_DOCSTRING_FONT).fontsize(8).spaceWidth(65).build();
    }

    private static TextLengthOptimizer $default$outputMsgOptimizer() {
        return TextLengthOptimizer.builder().font(OUTPUT_MSG_FONT).fontsize(9).spaceWidth(290).build();
    }

    protected DetailedRowComponent(DetailedRowComponentBuilder<?, ?> b) {
        super(b);
        this.rows = ((DetailedRowComponentBuilder)b).rows;
        this.scenario = ((DetailedRowComponentBuilder)b).scenario;
        this.feature = ((DetailedRowComponentBuilder)b).feature;
        this.startHeight = ((DetailedRowComponentBuilder)b).startHeight;
        this.initialSno = ((DetailedRowComponentBuilder)b).initialSno;
        this.stepTextOptimizer = ((DetailedRowComponentBuilder)b).stepTextOptimizer$set ? ((DetailedRowComponentBuilder)b).stepTextOptimizer : DetailedRowComponent.$default$stepTextOptimizer();
        this.docStringOptimizer = ((DetailedRowComponentBuilder)b).docStringOptimizer$set ? ((DetailedRowComponentBuilder)b).docStringOptimizer : DetailedRowComponent.$default$docStringOptimizer();
        this.dataCellOptimizer = ((DetailedRowComponentBuilder)b).dataCellOptimizer$set ? ((DetailedRowComponentBuilder)b).dataCellOptimizer : DetailedRowComponent.$default$dataCellOptimizer();
        this.outputMsgOptimizer = ((DetailedRowComponentBuilder)b).outputMsgOptimizer$set ? ((DetailedRowComponentBuilder)b).outputMsgOptimizer : DetailedRowComponent.$default$outputMsgOptimizer();
    }

    public static DetailedRowComponentBuilder<?, ?> builder() {
        return new DetailedRowComponentBuilderImpl();
    }

    public List<StepOrHookRow> getRows() {
        return this.rows;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int getStartHeight() {
        return this.startHeight;
    }

    public int getInitialSno() {
        return this.initialSno;
    }

    public TextLengthOptimizer getStepTextOptimizer() {
        return this.stepTextOptimizer;
    }

    public TextLengthOptimizer getDocStringOptimizer() {
        return this.docStringOptimizer;
    }

    public TextLengthOptimizer getDataCellOptimizer() {
        return this.dataCellOptimizer;
    }

    public TextLengthOptimizer getOutputMsgOptimizer() {
        return this.outputMsgOptimizer;
    }

    public void setRows(List<StepOrHookRow> rows) {
        this.rows = rows;
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public void setStartHeight(int startHeight) {
        this.startHeight = startHeight;
    }

    public void setInitialSno(int initialSno) {
        this.initialSno = initialSno;
    }

    @Override
    public String toString() {
        return "DetailedRowComponent(rows=" + this.getRows() + ", scenario=" + this.getScenario() + ", feature=" + this.getFeature() + ", startHeight=" + this.getStartHeight() + ", initialSno=" + this.getInitialSno() + ", stepTextOptimizer=" + this.getStepTextOptimizer() + ", docStringOptimizer=" + this.getDocStringOptimizer() + ", dataCellOptimizer=" + this.getDataCellOptimizer() + ", outputMsgOptimizer=" + this.getOutputMsgOptimizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedRowComponent)) {
            return false;
        }
        DetailedRowComponent other = (DetailedRowComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<StepOrHookRow> this$rows = this.getRows();
        List<StepOrHookRow> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        Scenario this$scenario = this.getScenario();
        Scenario other$scenario = other.getScenario();
        if (this$scenario == null ? other$scenario != null : !((Object)this$scenario).equals(other$scenario)) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature)) {
            return false;
        }
        if (this.getStartHeight() != other.getStartHeight()) {
            return false;
        }
        if (this.getInitialSno() != other.getInitialSno()) {
            return false;
        }
        TextLengthOptimizer this$stepTextOptimizer = this.getStepTextOptimizer();
        TextLengthOptimizer other$stepTextOptimizer = other.getStepTextOptimizer();
        if (this$stepTextOptimizer == null ? other$stepTextOptimizer != null : !((Object)this$stepTextOptimizer).equals(other$stepTextOptimizer)) {
            return false;
        }
        TextLengthOptimizer this$docStringOptimizer = this.getDocStringOptimizer();
        TextLengthOptimizer other$docStringOptimizer = other.getDocStringOptimizer();
        if (this$docStringOptimizer == null ? other$docStringOptimizer != null : !((Object)this$docStringOptimizer).equals(other$docStringOptimizer)) {
            return false;
        }
        TextLengthOptimizer this$dataCellOptimizer = this.getDataCellOptimizer();
        TextLengthOptimizer other$dataCellOptimizer = other.getDataCellOptimizer();
        if (this$dataCellOptimizer == null ? other$dataCellOptimizer != null : !((Object)this$dataCellOptimizer).equals(other$dataCellOptimizer)) {
            return false;
        }
        TextLengthOptimizer this$outputMsgOptimizer = this.getOutputMsgOptimizer();
        TextLengthOptimizer other$outputMsgOptimizer = other.getOutputMsgOptimizer();
        return !(this$outputMsgOptimizer == null ? other$outputMsgOptimizer != null : !((Object)this$outputMsgOptimizer).equals(other$outputMsgOptimizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DetailedRowComponent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<StepOrHookRow> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        Scenario $scenario = this.getScenario();
        result = result * 59 + ($scenario == null ? 43 : ((Object)$scenario).hashCode());
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
        result = result * 59 + this.getStartHeight();
        result = result * 59 + this.getInitialSno();
        TextLengthOptimizer $stepTextOptimizer = this.getStepTextOptimizer();
        result = result * 59 + ($stepTextOptimizer == null ? 43 : ((Object)$stepTextOptimizer).hashCode());
        TextLengthOptimizer $docStringOptimizer = this.getDocStringOptimizer();
        result = result * 59 + ($docStringOptimizer == null ? 43 : ((Object)$docStringOptimizer).hashCode());
        TextLengthOptimizer $dataCellOptimizer = this.getDataCellOptimizer();
        result = result * 59 + ($dataCellOptimizer == null ? 43 : ((Object)$dataCellOptimizer).hashCode());
        TextLengthOptimizer $outputMsgOptimizer = this.getOutputMsgOptimizer();
        result = result * 59 + ($outputMsgOptimizer == null ? 43 : ((Object)$outputMsgOptimizer).hashCode());
        return result;
    }

    public static abstract class DetailedRowComponentBuilder<C extends DetailedRowComponent, B extends DetailedRowComponentBuilder<C, B>>
    extends Component.ComponentBuilder<C, B> {
        private List<StepOrHookRow> rows;
        private Scenario scenario;
        private Feature feature;
        private int startHeight;
        private int initialSno;
        private TextLengthOptimizer stepTextOptimizer;
        private boolean stepTextOptimizer$set;
        private TextLengthOptimizer docStringOptimizer;
        private boolean docStringOptimizer$set;
        private TextLengthOptimizer dataCellOptimizer;
        private boolean dataCellOptimizer$set;
        private TextLengthOptimizer outputMsgOptimizer;
        private boolean outputMsgOptimizer$set;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B rows(List<StepOrHookRow> rows) {
            this.rows = rows;
            return (B)this.self();
        }

        public B scenario(Scenario scenario) {
            this.scenario = scenario;
            return (B)this.self();
        }

        public B feature(Feature feature) {
            this.feature = feature;
            return (B)this.self();
        }

        public B startHeight(int startHeight) {
            this.startHeight = startHeight;
            return (B)this.self();
        }

        public B initialSno(int initialSno) {
            this.initialSno = initialSno;
            return (B)this.self();
        }

        public B stepTextOptimizer(TextLengthOptimizer stepTextOptimizer) {
            this.stepTextOptimizer = stepTextOptimizer;
            this.stepTextOptimizer$set = true;
            return (B)this.self();
        }

        public B docStringOptimizer(TextLengthOptimizer docStringOptimizer) {
            this.docStringOptimizer = docStringOptimizer;
            this.docStringOptimizer$set = true;
            return (B)this.self();
        }

        public B dataCellOptimizer(TextLengthOptimizer dataCellOptimizer) {
            this.dataCellOptimizer = dataCellOptimizer;
            this.dataCellOptimizer$set = true;
            return (B)this.self();
        }

        public B outputMsgOptimizer(TextLengthOptimizer outputMsgOptimizer) {
            this.outputMsgOptimizer = outputMsgOptimizer;
            this.outputMsgOptimizer$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DetailedRowComponent.DetailedRowComponentBuilder(super=" + super.toString() + ", rows=" + this.rows + ", scenario=" + this.scenario + ", feature=" + this.feature + ", startHeight=" + this.startHeight + ", initialSno=" + this.initialSno + ", stepTextOptimizer=" + this.stepTextOptimizer + ", docStringOptimizer=" + this.docStringOptimizer + ", dataCellOptimizer=" + this.dataCellOptimizer + ", outputMsgOptimizer=" + this.outputMsgOptimizer + ")";
        }
    }

    private static final class DetailedRowComponentBuilderImpl
    extends DetailedRowComponentBuilder<DetailedRowComponent, DetailedRowComponentBuilderImpl> {
        private DetailedRowComponentBuilderImpl() {
        }

        @Override
        protected DetailedRowComponentBuilderImpl self() {
            return this;
        }

        @Override
        public DetailedRowComponent build() {
            return new DetailedRowComponent(this);
        }
    }
}

