/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import tech.grasshopper.pdf.chapter.detailed.ErrorMessageComponent;
import tech.grasshopper.pdf.chapter.detailed.LogMessageComponent;
import tech.grasshopper.pdf.chapter.detailed.MediaMessageComponent;
import tech.grasshopper.pdf.chapter.detailed.StepOrHookRow;
import tech.grasshopper.pdf.pojo.cucumber.Hook;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.util.DateUtil;

public class HookRow
extends StepOrHookRow {
    private Hook hook;

    @Override
    public ParagraphCell generateTextOutput() {
        ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder = ParagraphCell.Paragraph.builder();
        this.generateName(paragraphBuilder, String.valueOf(this.hook.getHookType().toString().toLowerCase()) + " - " + this.hook.getLocation(), this.reportConfig.getDetailedStepHookConfig().hookTextColor());
        ErrorMessageComponent.builder().stackTrace(this.hook.getErrorMessage()).textColor(this.reportConfig.getDetailedStepHookConfig().errorMsgColor()).build().componentText(paragraphBuilder);
        LogMessageComponent.builder().logMessages(this.hook.getOutput()).textColor(this.reportConfig.getDetailedStepHookConfig().logMsgColor()).hasRowOrStringOrError(this.dividerRequired()).build().componentText(paragraphBuilder);
        MediaMessageComponent.builder().mediaMessages(this.hook.getMedia()).textColor(this.reportConfig.getDetailedStepHookConfig().mediaMsgColor()).hasRowOrStringOrError(this.dividerRequired()).build().componentText(paragraphBuilder);
        return this.generateParagraphCell(paragraphBuilder);
    }

    @Override
    public boolean dividerRequired() {
        return !this.hook.getOutput().isEmpty() || !this.hook.getMedia().isEmpty();
    }

    @Override
    public int getRowHeight() {
        int height = 20;
        height += ErrorMessageComponent.builder().stackTrace(this.hook.getErrorMessage()).build().componentHeight();
        height += LogMessageComponent.builder().logMessages(this.hook.getOutput()).hasRowOrStringOrError(this.dividerRequired()).build().componentHeight();
        return height += MediaMessageComponent.builder().mediaMessages(this.hook.getMedia()).hasRowOrStringOrError(this.dividerRequired()).build().componentHeight();
    }

    @Override
    public Status getStatus() {
        return this.hook.getStatus();
    }

    @Override
    public String getDuration() {
        return DateUtil.durationValue(this.hook.calculatedDuration());
    }

    @Override
    protected String getSerialNo() {
        return "";
    }

    protected HookRow(HookRowBuilder<?, ?> b) {
        super(b);
        this.hook = ((HookRowBuilder)b).hook;
    }

    public static HookRowBuilder<?, ?> builder() {
        return new HookRowBuilderImpl();
    }

    public Hook getHook() {
        return this.hook;
    }

    public void setHook(Hook hook) {
        this.hook = hook;
    }

    @Override
    public String toString() {
        return "HookRow(hook=" + this.getHook() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HookRow)) {
            return false;
        }
        HookRow other = (HookRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hook this$hook = this.getHook();
        Hook other$hook = other.getHook();
        return !(this$hook == null ? other$hook != null : !((Object)this$hook).equals(other$hook));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HookRow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hook $hook = this.getHook();
        result = result * 59 + ($hook == null ? 43 : ((Object)$hook).hashCode());
        return result;
    }

    public static abstract class HookRowBuilder<C extends HookRow, B extends HookRowBuilder<C, B>>
    extends StepOrHookRow.StepOrHookRowBuilder<C, B> {
        private Hook hook;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B hook(Hook hook) {
            this.hook = hook;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HookRow.HookRowBuilder(super=" + super.toString() + ", hook=" + this.hook + ")";
        }
    }

    private static final class HookRowBuilderImpl
    extends HookRowBuilder<HookRow, HookRowBuilderImpl> {
        private HookRowBuilderImpl() {
        }

        @Override
        protected HookRowBuilderImpl self() {
            return this;
        }

        @Override
        public HookRow build() {
            return new HookRow(this);
        }
    }
}

