/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.chapter.detailed.StepOrHookComponent;
import tech.grasshopper.pdf.optimizer.TextContentSanitizer;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;

public class LogMessageComponent
implements StepOrHookComponent {
    private List<String> logMessages;
    private boolean hasRowOrStringOrError;
    private Color textColor;
    private static final int OUTPUT_MSG_LINE_HEIGHT = 15;
    private static final int ROWS_DOC_SEPARATOR_HEIGHT = 15;
    private static final int SEP_CHAR_REPEAT_COUNT = 95;
    private static final PDFont FONT = PDType1Font.HELVETICA;
    private static final int FONT_SIZE = 9;
    private static final int WIDTH = 290;
    private final TextLengthOptimizer messageOptimizer = TextLengthOptimizer.builder().font(FONT).fontsize(9).spaceWidth(290).build();
    private final TextContentSanitizer textSanitizer = TextContentSanitizer.builder().font(FONT).build();

    @Override
    public int componentHeight() {
        int height = 0;
        if (this.logMessages != null && !this.logMessages.isEmpty()) {
            height = this.logMessages.size() * 15;
            if (this.hasRowOrStringOrError) {
                height += 15;
            }
        }
        return height;
    }

    @Override
    public void componentText(ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder) {
        if (this.logMessages != null) {
            if (this.hasRowOrStringOrError && !this.logMessages.isEmpty()) {
                paragraphBuilder.append(StyledText.builder().text(String.join((CharSequence)"", Collections.nCopies(95, "-"))).build()).appendNewLine();
            }
            for (String output : this.logMessages) {
                paragraphBuilder.append(StyledText.builder().text(this.messageOptimizer.optimizeText(this.textSanitizer.sanitizeText(output))).fontSize(Float.valueOf(9.0f)).color(this.textColor).build()).appendNewLine();
            }
        }
    }

    private static boolean $default$hasRowOrStringOrError() {
        return false;
    }

    private static Color $default$textColor() {
        return Color.GREEN;
    }

    LogMessageComponent(List<String> logMessages, boolean hasRowOrStringOrError, Color textColor) {
        this.logMessages = logMessages;
        this.hasRowOrStringOrError = hasRowOrStringOrError;
        this.textColor = textColor;
    }

    public static LogMessageComponentBuilder builder() {
        return new LogMessageComponentBuilder();
    }

    public List<String> getLogMessages() {
        return this.logMessages;
    }

    public boolean isHasRowOrStringOrError() {
        return this.hasRowOrStringOrError;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public TextLengthOptimizer getMessageOptimizer() {
        return this.messageOptimizer;
    }

    public TextContentSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public void setLogMessages(List<String> logMessages) {
        this.logMessages = logMessages;
    }

    public void setHasRowOrStringOrError(boolean hasRowOrStringOrError) {
        this.hasRowOrStringOrError = hasRowOrStringOrError;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogMessageComponent)) {
            return false;
        }
        LogMessageComponent other = (LogMessageComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$logMessages = this.getLogMessages();
        List<String> other$logMessages = other.getLogMessages();
        if (this$logMessages == null ? other$logMessages != null : !((Object)this$logMessages).equals(other$logMessages)) {
            return false;
        }
        if (this.isHasRowOrStringOrError() != other.isHasRowOrStringOrError()) {
            return false;
        }
        Color this$textColor = this.getTextColor();
        Color other$textColor = other.getTextColor();
        if (this$textColor == null ? other$textColor != null : !((Object)this$textColor).equals(other$textColor)) {
            return false;
        }
        TextLengthOptimizer this$messageOptimizer = this.getMessageOptimizer();
        TextLengthOptimizer other$messageOptimizer = other.getMessageOptimizer();
        if (this$messageOptimizer == null ? other$messageOptimizer != null : !((Object)this$messageOptimizer).equals(other$messageOptimizer)) {
            return false;
        }
        TextContentSanitizer this$textSanitizer = this.getTextSanitizer();
        TextContentSanitizer other$textSanitizer = other.getTextSanitizer();
        return !(this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogMessageComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $logMessages = this.getLogMessages();
        result = result * 59 + ($logMessages == null ? 43 : ((Object)$logMessages).hashCode());
        result = result * 59 + (this.isHasRowOrStringOrError() ? 79 : 97);
        Color $textColor = this.getTextColor();
        result = result * 59 + ($textColor == null ? 43 : ((Object)$textColor).hashCode());
        TextLengthOptimizer $messageOptimizer = this.getMessageOptimizer();
        result = result * 59 + ($messageOptimizer == null ? 43 : ((Object)$messageOptimizer).hashCode());
        TextContentSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        return result;
    }

    public String toString() {
        return "LogMessageComponent(logMessages=" + this.getLogMessages() + ", hasRowOrStringOrError=" + this.isHasRowOrStringOrError() + ", textColor=" + this.getTextColor() + ", messageOptimizer=" + this.getMessageOptimizer() + ", textSanitizer=" + this.getTextSanitizer() + ")";
    }

    public static class LogMessageComponentBuilder {
        private List<String> logMessages;
        private boolean hasRowOrStringOrError;
        private boolean hasRowOrStringOrError$set;
        private Color textColor;
        private boolean textColor$set;

        LogMessageComponentBuilder() {
        }

        public LogMessageComponentBuilder logMessages(List<String> logMessages) {
            this.logMessages = logMessages;
            return this;
        }

        public LogMessageComponentBuilder hasRowOrStringOrError(boolean hasRowOrStringOrError) {
            this.hasRowOrStringOrError = hasRowOrStringOrError;
            this.hasRowOrStringOrError$set = true;
            return this;
        }

        public LogMessageComponentBuilder textColor(Color textColor) {
            this.textColor = textColor;
            this.textColor$set = true;
            return this;
        }

        public LogMessageComponent build() {
            return new LogMessageComponent(this.logMessages, this.hasRowOrStringOrError$set ? this.hasRowOrStringOrError : LogMessageComponent.$default$hasRowOrStringOrError(), this.textColor$set ? this.textColor : LogMessageComponent.$default$textColor());
        }

        public String toString() {
            return "LogMessageComponent.LogMessageComponentBuilder(logMessages=" + this.logMessages + ", hasRowOrStringOrError=" + this.hasRowOrStringOrError + ", textColor=" + this.textColor + ")";
        }
    }
}

