/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.detailed;

import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import tech.grasshopper.pdf.chapter.detailed.ErrorMessageComponent;
import tech.grasshopper.pdf.chapter.detailed.LogMessageComponent;
import tech.grasshopper.pdf.chapter.detailed.MediaMessageComponent;
import tech.grasshopper.pdf.chapter.detailed.StepOrHookRow;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.pojo.cucumber.Step;
import tech.grasshopper.pdf.util.DateUtil;

public class StepRow
extends StepOrHookRow {
    private Step step;

    @Override
    public ParagraphCell generateTextOutput() {
        ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder = ParagraphCell.Paragraph.builder();
        this.generateName(paragraphBuilder, this.step.getName(), this.reportConfig.getDetailedStepHookConfig().stepTextColor());
        ErrorMessageComponent.builder().stackTrace(this.step.getErrorMessage()).textColor(this.reportConfig.getDetailedStepHookConfig().errorMsgColor()).build().componentText(paragraphBuilder);
        LogMessageComponent.builder().logMessages(this.step.getOutput()).textColor(this.reportConfig.getDetailedStepHookConfig().logMsgColor()).hasRowOrStringOrError(this.dividerRequired()).build().componentText(paragraphBuilder);
        MediaMessageComponent.builder().mediaMessages(this.step.getMedia()).textColor(this.reportConfig.getDetailedStepHookConfig().mediaMsgColor()).hasRowOrStringOrError(this.dividerRequired()).build().componentText(paragraphBuilder);
        return this.generateParagraphCell(paragraphBuilder);
    }

    @Override
    public int getRowHeight() {
        int height = 20;
        height += ErrorMessageComponent.builder().stackTrace(this.step.getErrorMessage()).build().componentHeight();
        height += LogMessageComponent.builder().logMessages(this.step.getOutput()).hasRowOrStringOrError(this.dividerRequired()).build().componentHeight();
        return height += MediaMessageComponent.builder().mediaMessages(this.step.getMedia()).hasRowOrStringOrError(this.dividerRequired()).build().componentHeight();
    }

    @Override
    public boolean dividerRequired() {
        return !this.step.getRows().isEmpty() || this.step.getDocString() != null || !this.step.getOutput().isEmpty() || !this.step.getMedia().isEmpty();
    }

    @Override
    public Status getStatus() {
        return this.step.getStatus();
    }

    @Override
    public String getDuration() {
        return DateUtil.durationValue(this.step.calculatedDuration());
    }

    @Override
    protected int incrementSerialNumber(int sno) {
        return sno + 1;
    }

    @Override
    public int decrementStepCount(int cnt) {
        return cnt - 1;
    }

    protected StepRow(StepRowBuilder<?, ?> b) {
        super(b);
        this.step = ((StepRowBuilder)b).step;
    }

    public static StepRowBuilder<?, ?> builder() {
        return new StepRowBuilderImpl();
    }

    public Step getStep() {
        return this.step;
    }

    public void setStep(Step step) {
        this.step = step;
    }

    @Override
    public String toString() {
        return "StepRow(step=" + this.getStep() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepRow)) {
            return false;
        }
        StepRow other = (StepRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Step this$step = this.getStep();
        Step other$step = other.getStep();
        return !(this$step == null ? other$step != null : !((Object)this$step).equals(other$step));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StepRow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Step $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : ((Object)$step).hashCode());
        return result;
    }

    public static abstract class StepRowBuilder<C extends StepRow, B extends StepRowBuilder<C, B>>
    extends StepOrHookRow.StepOrHookRowBuilder<C, B> {
        private Step step;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B step(Step step) {
            this.step = step;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StepRow.StepRowBuilder(super=" + super.toString() + ", step=" + this.step + ")";
        }
    }

    private static final class StepRowBuilderImpl
    extends StepRowBuilder<StepRow, StepRowBuilderImpl> {
        private StepRowBuilderImpl() {
        }

        @Override
        protected StepRowBuilderImpl self() {
            return this;
        }

        @Override
        public StepRow build() {
            return new StepRow(this);
        }
    }
}

