/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.feature;

import java.util.List;
import tech.grasshopper.pdf.chapter.PaginatedChapter;
import tech.grasshopper.pdf.chapter.feature.FeaturePage;
import tech.grasshopper.pdf.chapter.page.PaginationData;
import tech.grasshopper.pdf.chapter.page.Paginator;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.pojo.cucumber.Feature;

public class FeatureChapter
extends PaginatedChapter {
    private final int featurePerPage;
    private FeatureData featureData;

    @Override
    public void createChapter() {
        this.featureData = (FeatureData)this.displayData;
        Paginator paginator = Paginator.builder().itemsCount(this.featureData.getFeatures().size()).itemsPerPage(this.featurePerPage).chapter(this).build();
        paginator.paginate();
    }

    @Override
    public void generatePage(int fromIndex, int toIndex, int pageNum) {
        ((FeaturePage)((FeaturePage.FeaturePageBuilder)((FeaturePage.FeaturePageBuilder)((FeaturePage.FeaturePageBuilder)((FeaturePage.FeaturePageBuilder)((FeaturePage.FeaturePageBuilder)FeaturePage.builder().displayData(this.createPageData(fromIndex, toIndex))).document(this.document)).reportConfig(this.reportConfig)).destinations(this.destinations)).paginationData(PaginationData.builder().itemsPerPage(this.featurePerPage).itemFromIndex(fromIndex).itemToIndex(toIndex).build())).build()).createPage();
    }

    @Override
    public DisplayData createPageData(int fromIndex, int toIndex) {
        List<Feature> pageFeatures = this.featureData.getFeatures().subList(fromIndex, toIndex);
        return FeatureData.builder().features(pageFeatures).build();
    }

    protected FeatureChapter(FeatureChapterBuilder<?, ?> b) {
        super((PaginatedChapter.PaginatedChapterBuilder<?, ?>)b);
        this.featurePerPage = this.reportConfig.getFeatureConfig().getItemcount();
        this.featureData = ((FeatureChapterBuilder)b).featureData;
    }

    public static FeatureChapterBuilder<?, ?> builder() {
        return new FeatureChapterBuilderImpl();
    }

    public int getFeaturePerPage() {
        return this.featurePerPage;
    }

    public FeatureData getFeatureData() {
        return this.featureData;
    }

    public void setFeatureData(FeatureData featureData) {
        this.featureData = featureData;
    }

    @Override
    public String toString() {
        return "FeatureChapter(featurePerPage=" + this.getFeaturePerPage() + ", featureData=" + this.getFeatureData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureChapter)) {
            return false;
        }
        FeatureChapter other = (FeatureChapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFeaturePerPage() != other.getFeaturePerPage()) {
            return false;
        }
        FeatureData this$featureData = this.getFeatureData();
        FeatureData other$featureData = other.getFeatureData();
        return !(this$featureData == null ? other$featureData != null : !((Object)this$featureData).equals(other$featureData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FeatureChapter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFeaturePerPage();
        FeatureData $featureData = this.getFeatureData();
        result = result * 59 + ($featureData == null ? 43 : ((Object)$featureData).hashCode());
        return result;
    }

    public static abstract class FeatureChapterBuilder<C extends FeatureChapter, B extends FeatureChapterBuilder<C, B>>
    extends PaginatedChapter.PaginatedChapterBuilder<C, B> {
        private FeatureData featureData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B featureData(FeatureData featureData) {
            this.featureData = featureData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FeatureChapter.FeatureChapterBuilder(super=" + super.toString() + ", featureData=" + this.featureData + ")";
        }
    }

    private static final class FeatureChapterBuilderImpl
    extends FeatureChapterBuilder<FeatureChapter, FeatureChapterBuilderImpl> {
        private FeatureChapterBuilderImpl() {
        }

        @Override
        protected FeatureChapterBuilderImpl self() {
            return this;
        }

        @Override
        public FeatureChapter build() {
            return new FeatureChapter(this);
        }
    }
}

