/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.feature;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.annotation.AnnotationAware;
import tech.grasshopper.pdf.chapter.page.PaginationData;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.optimizer.TextContentSanitizer;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.util.DateUtil;

public class FeatureScenarioDetails
extends Component
implements AnnotationAware {
    private PaginationData paginationData;
    private static final int TABLE_X_AXIS_START = 50;
    private static final int TABLE_Y_AXIS_START = 430;
    private static final float TABLE_HEADER_HEIGHT = 30.0f;
    private static final float TABLE_ROW_HEIGHT = 25.0f;
    private static final PDFont NAME_FONT = PDType1Font.HELVETICA_OBLIQUE;
    private static final int NAME_FONT_SIZE = 10;
    private static final int FEATURE_NAME_COLUMN_WIDTH = 225;
    private static final int PADDING = 5;
    private final TextLengthOptimizer featureNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(10).spaceWidth(215).build();
    private final TextContentSanitizer textSanitizer = TextContentSanitizer.builder().font(NAME_FONT).build();

    @Override
    public void display() {
        Table.TableBuilder myTableBuilder = Table.builder().addColumnsOfWidth(new float[]{25.0f, 225.0f, 35.0f, 35.0f, 35.0f, 35.0f, 110.0f}).padding(5.0f).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f).font((PDFont)PDType1Font.HELVETICA_BOLD_OBLIQUE).fontSize(Integer.valueOf(12)).addRow(Row.builder().horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.MIDDLE).height(Float.valueOf(30.0f)).add((AbstractCell)TextCell.builder().text("#").build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Feature Name").horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("T").textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("P").textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("F").textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("S").textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("Duration").textColor(this.reportConfig.getFeatureConfig().durationColor())).horizontalAlignment(HorizontalAlignment.LEFT)).build()).build());
        int sNo = this.paginationData.getItemFromIndex() + 1;
        FeatureData featureData = (FeatureData)this.displayData;
        List<Feature> features = featureData.getFeatures();
        int i = 0;
        while (i < features.size()) {
            Feature feature = features.get(i);
            String featureName = this.featureNameTextOptimizer.optimizeText(this.textSanitizer.sanitizeText(feature.getName()));
            myTableBuilder.addRow(Row.builder().font(NAME_FONT).fontSize(Integer.valueOf(10)).height(Float.valueOf(25.0f)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.MIDDLE).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(sNo)).fontSize(Integer.valueOf(8))).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(featureName).horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getTotalScenarios())).textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getPassedScenarios())).textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getFailedScenarios())).textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getSkippedScenarios())).textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(DateUtil.durationValue(feature.calculatedDuration())).textColor(this.reportConfig.getFeatureConfig().durationColor())).horizontalAlignment(HorizontalAlignment.LEFT)).build()).build());
            ++sNo;
            ++i;
        }
        Table myTable = myTableBuilder.build();
        TableDrawer tableDrawer = TableDrawer.builder().contentStream(this.content).startX(50.0f).startY(430.0f).table(myTable).build();
        tableDrawer.draw();
    }

    @Override
    public void createAnnotationLinks() {
        int yCoord = 380;
        FeatureData featureData = (FeatureData)this.displayData;
        List<Feature> features = featureData.getFeatures();
        int i = 0;
        while (i < features.size()) {
            Annotation annotation = Annotation.builder().title(features.get(i).getName()).xBottom(80).yBottom(yCoord).width(this.featureNameTextOptimizer.optimizedTextWidth(features.get(i).getName())).height(20).build();
            PDAnnotationLink annotationLink = annotation.createPDAnnotationLink();
            features.get(i).getAnnotations().add(annotationLink);
            try {
                this.page.getAnnotations().add(annotationLink);
            }
            catch (IOException e) {
                throw new PdfReportException(e);
            }
            yCoord -= 25;
            ++i;
        }
    }

    protected FeatureScenarioDetails(FeatureScenarioDetailsBuilder<?, ?> b) {
        super(b);
        this.paginationData = ((FeatureScenarioDetailsBuilder)b).paginationData;
    }

    public static FeatureScenarioDetailsBuilder<?, ?> builder() {
        return new FeatureScenarioDetailsBuilderImpl();
    }

    public PaginationData getPaginationData() {
        return this.paginationData;
    }

    public TextLengthOptimizer getFeatureNameTextOptimizer() {
        return this.featureNameTextOptimizer;
    }

    public TextContentSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public void setPaginationData(PaginationData paginationData) {
        this.paginationData = paginationData;
    }

    @Override
    public String toString() {
        return "FeatureScenarioDetails(paginationData=" + this.getPaginationData() + ", featureNameTextOptimizer=" + this.getFeatureNameTextOptimizer() + ", textSanitizer=" + this.getTextSanitizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureScenarioDetails)) {
            return false;
        }
        FeatureScenarioDetails other = (FeatureScenarioDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PaginationData this$paginationData = this.getPaginationData();
        PaginationData other$paginationData = other.getPaginationData();
        if (this$paginationData == null ? other$paginationData != null : !((Object)this$paginationData).equals(other$paginationData)) {
            return false;
        }
        TextLengthOptimizer this$featureNameTextOptimizer = this.getFeatureNameTextOptimizer();
        TextLengthOptimizer other$featureNameTextOptimizer = other.getFeatureNameTextOptimizer();
        if (this$featureNameTextOptimizer == null ? other$featureNameTextOptimizer != null : !((Object)this$featureNameTextOptimizer).equals(other$featureNameTextOptimizer)) {
            return false;
        }
        TextContentSanitizer this$textSanitizer = this.getTextSanitizer();
        TextContentSanitizer other$textSanitizer = other.getTextSanitizer();
        return !(this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FeatureScenarioDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PaginationData $paginationData = this.getPaginationData();
        result = result * 59 + ($paginationData == null ? 43 : ((Object)$paginationData).hashCode());
        TextLengthOptimizer $featureNameTextOptimizer = this.getFeatureNameTextOptimizer();
        result = result * 59 + ($featureNameTextOptimizer == null ? 43 : ((Object)$featureNameTextOptimizer).hashCode());
        TextContentSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        return result;
    }

    public static abstract class FeatureScenarioDetailsBuilder<C extends FeatureScenarioDetails, B extends FeatureScenarioDetailsBuilder<C, B>>
    extends Component.ComponentBuilder<C, B> {
        private PaginationData paginationData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B paginationData(PaginationData paginationData) {
            this.paginationData = paginationData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FeatureScenarioDetails.FeatureScenarioDetailsBuilder(super=" + super.toString() + ", paginationData=" + this.paginationData + ")";
        }
    }

    private static final class FeatureScenarioDetailsBuilderImpl
    extends FeatureScenarioDetailsBuilder<FeatureScenarioDetails, FeatureScenarioDetailsBuilderImpl> {
        private FeatureScenarioDetailsBuilderImpl() {
        }

        @Override
        protected FeatureScenarioDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public FeatureScenarioDetails build() {
            return new FeatureScenarioDetails(this);
        }
    }
}

