/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.page;

import tech.grasshopper.pdf.chapter.PaginatedChapter;

public class Paginator {
    private int itemsCount;
    private int itemsPerPage;
    private PaginatedChapter chapter;

    public void paginate() {
        int pageCount = this.itemsCount / this.itemsPerPage;
        if (this.itemsCount % this.itemsPerPage > 0) {
            ++pageCount;
        }
        int i = 0;
        while (i < pageCount) {
            int fromIndex = i * this.itemsPerPage;
            int toIndex = fromIndex + this.itemsPerPage;
            if (toIndex > this.itemsCount) {
                toIndex = this.itemsCount;
            }
            this.chapter.generatePage(fromIndex, toIndex, i + 1);
            ++i;
        }
    }

    Paginator(int itemsCount, int itemsPerPage, PaginatedChapter chapter) {
        this.itemsCount = itemsCount;
        this.itemsPerPage = itemsPerPage;
        this.chapter = chapter;
    }

    public static PaginatorBuilder builder() {
        return new PaginatorBuilder();
    }

    public int getItemsCount() {
        return this.itemsCount;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public PaginatedChapter getChapter() {
        return this.chapter;
    }

    public void setItemsCount(int itemsCount) {
        this.itemsCount = itemsCount;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public void setChapter(PaginatedChapter chapter) {
        this.chapter = chapter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Paginator)) {
            return false;
        }
        Paginator other = (Paginator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getItemsCount() != other.getItemsCount()) {
            return false;
        }
        if (this.getItemsPerPage() != other.getItemsPerPage()) {
            return false;
        }
        PaginatedChapter this$chapter = this.getChapter();
        PaginatedChapter other$chapter = other.getChapter();
        return !(this$chapter == null ? other$chapter != null : !((Object)this$chapter).equals(other$chapter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Paginator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getItemsCount();
        result = result * 59 + this.getItemsPerPage();
        PaginatedChapter $chapter = this.getChapter();
        result = result * 59 + ($chapter == null ? 43 : ((Object)$chapter).hashCode());
        return result;
    }

    public String toString() {
        return "Paginator(itemsCount=" + this.getItemsCount() + ", itemsPerPage=" + this.getItemsPerPage() + ", chapter=" + this.getChapter() + ")";
    }

    public static class PaginatorBuilder {
        private int itemsCount;
        private int itemsPerPage;
        private PaginatedChapter chapter;

        PaginatorBuilder() {
        }

        public PaginatorBuilder itemsCount(int itemsCount) {
            this.itemsCount = itemsCount;
            return this;
        }

        public PaginatorBuilder itemsPerPage(int itemsPerPage) {
            this.itemsPerPage = itemsPerPage;
            return this;
        }

        public PaginatorBuilder chapter(PaginatedChapter chapter) {
            this.chapter = chapter;
            return this;
        }

        public Paginator build() {
            return new Paginator(this.itemsCount, this.itemsPerPage, this.chapter);
        }

        public String toString() {
            return "Paginator.PaginatorBuilder(itemsCount=" + this.itemsCount + ", itemsPerPage=" + this.itemsPerPage + ", chapter=" + this.chapter + ")";
        }
    }
}

