/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.scenario;

import java.awt.Color;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import tech.grasshopper.pdf.chapter.page.PaginatedPage;
import tech.grasshopper.pdf.chapter.scenario.ScenarioStackedBarChart;
import tech.grasshopper.pdf.chapter.scenario.ScenarioStepDetails;
import tech.grasshopper.pdf.component.text.TextComponent;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.report.Text;

public class ScenarioPage
extends PaginatedPage
implements DestinationAware {
    private static final Logger logger = Logger.getLogger(ScenarioPage.class.getName());
    private PDPage page;

    @Override
    public void createPage() {
        try {
            this.page = new PDPage(PDRectangle.A4);
            this.document.addPage(this.page);
            this.content = new PDPageContentStream(this.document, this.page);
            this.createTitle();
            this.createStackedBarChart();
            this.createTable();
            this.collectPageAnnotations();
            this.createDestination();
            this.content.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
    }

    private void createTitle() {
        Text text = Text.builder().textColor(Color.LIGHT_GRAY).font((PDFont)PDType1Font.HELVETICA_OBLIQUE).fontSize(12.0f).xoffset(40.0f).yoffset(775.0f).text("SCENARIOS SUMMARY " + (this.paginationData.getItemFromIndex() + 1) + " - " + this.paginationData.getItemToIndex()).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    private void createStackedBarChart() {
        ((ScenarioStackedBarChart)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)((ScenarioStackedBarChart.ScenarioStackedBarChartBuilder)ScenarioStackedBarChart.builder().document(this.document)).content(this.content)).displayData(this.displayData)).reportConfig(this.reportConfig)).itemCount(this.paginationData.getItemsPerPage())).fromXData(this.paginationData.getItemFromIndex())).toXData(this.paginationData.getItemToIndex())).build()).display();
    }

    private void createTable() {
        ((ScenarioStepDetails)((ScenarioStepDetails.ScenarioStepDetailsBuilder)((ScenarioStepDetails.ScenarioStepDetailsBuilder)((ScenarioStepDetails.ScenarioStepDetailsBuilder)((ScenarioStepDetails.ScenarioStepDetailsBuilder)ScenarioStepDetails.builder().displayData(this.displayData)).content(this.content)).reportConfig(this.reportConfig)).paginationData(this.paginationData)).build()).display();
    }

    public void collectPageAnnotations() {
        if (this.reportConfig.isDisplayScenario() && this.reportConfig.isDisplayDetailed()) {
            ((ScenarioStepDetails)((ScenarioStepDetails.ScenarioStepDetailsBuilder)((ScenarioStepDetails.ScenarioStepDetailsBuilder)((ScenarioStepDetails.ScenarioStepDetailsBuilder)ScenarioStepDetails.builder().displayData(this.displayData)).content(this.content)).page(this.page)).build()).createAnnotationLinks();
        }
    }

    @Override
    public Destination createDestination() {
        Destination destination = Destination.builder().name("Scenarios - " + (this.paginationData.getItemFromIndex() + 1) + " to " + this.paginationData.getItemToIndex()).yCoord(800).page(this.page).build();
        this.destinations.addScenarioChapterDestinations(destination);
        return destination;
    }

    protected ScenarioPage(ScenarioPageBuilder<?, ?> b) {
        super((PaginatedPage.PaginatedPageBuilder<?, ?>)b);
        this.page = ((ScenarioPageBuilder)b).page;
    }

    public static ScenarioPageBuilder<?, ?> builder() {
        return new ScenarioPageBuilderImpl();
    }

    public PDPage getPage() {
        return this.page;
    }

    public void setPage(PDPage page) {
        this.page = page;
    }

    @Override
    public String toString() {
        return "ScenarioPage(page=" + this.getPage() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScenarioPage)) {
            return false;
        }
        ScenarioPage other = (ScenarioPage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDPage this$page = this.getPage();
        PDPage other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScenarioPage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public static abstract class ScenarioPageBuilder<C extends ScenarioPage, B extends ScenarioPageBuilder<C, B>>
    extends PaginatedPage.PaginatedPageBuilder<C, B> {
        private PDPage page;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B page(PDPage page) {
            this.page = page;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScenarioPage.ScenarioPageBuilder(super=" + super.toString() + ", page=" + this.page + ")";
        }
    }

    private static final class ScenarioPageBuilderImpl
    extends ScenarioPageBuilder<ScenarioPage, ScenarioPageBuilderImpl> {
        private ScenarioPageBuilderImpl() {
        }

        @Override
        protected ScenarioPageBuilderImpl self() {
            return this;
        }

        @Override
        public ScenarioPage build() {
            return new ScenarioPage(this);
        }
    }
}

