/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.scenario;

import java.awt.Color;
import java.util.stream.IntStream;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import tech.grasshopper.pdf.component.chart.ChartComponent;
import tech.grasshopper.pdf.component.chart.ChartDisplayer;
import tech.grasshopper.pdf.component.chart.ReportStackedBarChart;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;

public class ScenarioStackedBarChart
extends ChartComponent {
    private int itemCount;
    private int fromXData;
    private int toXData;

    @Override
    public void display() {
        this.createBarChart();
    }

    private void createBarChart() {
        int[] passed = new int[this.itemCount];
        int[] failed = new int[this.itemCount];
        int[] skipped = new int[this.itemCount];
        int[] xData = new int[this.itemCount];
        xData = IntStream.rangeClosed(this.fromXData + 1, this.fromXData + this.itemCount).toArray();
        ReportStackedBarChart chart = new ReportStackedBarChart(520, 300);
        chart.setYAxisTitle("# of Steps");
        this.updateBarChartStyler((CategoryStyler)chart.getStyler());
        this.createStackedBarChartData(passed, failed, skipped);
        chart.updateData(xData, passed, failed, skipped);
        ((ChartDisplayer)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)ChartDisplayer.builder().document(this.document)).content(this.content)).chart((Chart<?, ?>)chart)).xBottomLeft(40.0f)).yBottomLeft(460.0f)).build()).display();
    }

    private void updateBarChartStyler(CategoryStyler styler) {
        styler.setSeriesColors(new Color[]{this.reportConfig.passedColor(), this.reportConfig.failedColor(), this.reportConfig.skippedColor()});
    }

    private void createStackedBarChartData(int[] passed, int[] failed, int[] skipped) {
        ScenarioData scenarioData = (ScenarioData)this.displayData;
        int i = 0;
        while (i < scenarioData.getScenarios().size()) {
            Scenario scenario = scenarioData.getScenarios().get(i);
            passed[i] = scenario.getPassedSteps();
            failed[i] = scenario.getFailedSteps();
            skipped[i] = scenario.getSkippedSteps();
            ++i;
        }
    }

    protected ScenarioStackedBarChart(ScenarioStackedBarChartBuilder<?, ?> b) {
        super((ChartComponent.ChartComponentBuilder<?, ?>)b);
        this.itemCount = ((ScenarioStackedBarChartBuilder)b).itemCount;
        this.fromXData = ((ScenarioStackedBarChartBuilder)b).fromXData;
        this.toXData = ((ScenarioStackedBarChartBuilder)b).toXData;
    }

    public static ScenarioStackedBarChartBuilder<?, ?> builder() {
        return new ScenarioStackedBarChartBuilderImpl();
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public int getFromXData() {
        return this.fromXData;
    }

    public int getToXData() {
        return this.toXData;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public void setFromXData(int fromXData) {
        this.fromXData = fromXData;
    }

    public void setToXData(int toXData) {
        this.toXData = toXData;
    }

    @Override
    public String toString() {
        return "ScenarioStackedBarChart(itemCount=" + this.getItemCount() + ", fromXData=" + this.getFromXData() + ", toXData=" + this.getToXData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScenarioStackedBarChart)) {
            return false;
        }
        ScenarioStackedBarChart other = (ScenarioStackedBarChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getItemCount() != other.getItemCount()) {
            return false;
        }
        if (this.getFromXData() != other.getFromXData()) {
            return false;
        }
        return this.getToXData() == other.getToXData();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScenarioStackedBarChart;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getItemCount();
        result = result * 59 + this.getFromXData();
        result = result * 59 + this.getToXData();
        return result;
    }

    public static abstract class ScenarioStackedBarChartBuilder<C extends ScenarioStackedBarChart, B extends ScenarioStackedBarChartBuilder<C, B>>
    extends ChartComponent.ChartComponentBuilder<C, B> {
        private int itemCount;
        private int fromXData;
        private int toXData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B itemCount(int itemCount) {
            this.itemCount = itemCount;
            return (B)this.self();
        }

        public B fromXData(int fromXData) {
            this.fromXData = fromXData;
            return (B)this.self();
        }

        public B toXData(int toXData) {
            this.toXData = toXData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScenarioStackedBarChart.ScenarioStackedBarChartBuilder(super=" + super.toString() + ", itemCount=" + this.itemCount + ", fromXData=" + this.fromXData + ", toXData=" + this.toXData + ")";
        }
    }

    private static final class ScenarioStackedBarChartBuilderImpl
    extends ScenarioStackedBarChartBuilder<ScenarioStackedBarChart, ScenarioStackedBarChartBuilderImpl> {
        private ScenarioStackedBarChartBuilderImpl() {
        }

        @Override
        protected ScenarioStackedBarChartBuilderImpl self() {
            return this;
        }

        @Override
        public ScenarioStackedBarChart build() {
            return new ScenarioStackedBarChart(this);
        }
    }
}

