/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.scenario;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.annotation.AnnotationAware;
import tech.grasshopper.pdf.chapter.page.PaginationData;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.optimizer.TextContentSanitizer;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.util.DateUtil;

public class ScenarioStepDetails
extends Component
implements AnnotationAware {
    private PaginationData paginationData;
    private static final int TABLE_X_AXIS_START = 50;
    private static final int TABLE_Y_AXIS_START = 440;
    private static final float TABLE_HEADER_HEIGHT = 25.0f;
    private static final float TABLE_ROW_HEIGHT = 22.0f;
    private static final PDFont NAME_FONT = PDType1Font.HELVETICA_OBLIQUE;
    private static final int NAME_FONT_SIZE = 10;
    private static final int FEATURE_NAME_COLUMN_WIDTH = 110;
    private static final int SCENARIO_NAME_COLUMN_WIDTH = 160;
    private static final int PADDING = 5;
    private final TextLengthOptimizer featureNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(10).spaceWidth(100).build();
    private final TextLengthOptimizer scenarioNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(10).spaceWidth(150).build();
    private final TextContentSanitizer textSanitizer = TextContentSanitizer.builder().font(NAME_FONT).build();

    @Override
    public void display() {
        Table.TableBuilder myTableBuilder = Table.builder().addColumnsOfWidth(new float[]{25.0f, 110.0f, 160.0f, 30.0f, 30.0f, 30.0f, 30.0f, 85.0f}).padding(5.0f).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f).font((PDFont)PDType1Font.HELVETICA_BOLD_OBLIQUE).fontSize(Integer.valueOf(11)).addRow(Row.builder().horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.MIDDLE).height(Float.valueOf(25.0f)).add((AbstractCell)TextCell.builder().text("#").build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Feature Name").horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Scenario Name").horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("T").textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("P").textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("F").textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("S").textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("Duration").textColor(this.reportConfig.getFeatureConfig().durationColor())).horizontalAlignment(HorizontalAlignment.LEFT)).build()).build());
        int sNo = this.paginationData.getItemFromIndex() + 1;
        ScenarioData scenarioData = (ScenarioData)this.displayData;
        List<Scenario> scenarios = scenarioData.getScenarios();
        int i = 0;
        while (i < scenarios.size()) {
            Scenario scenario = scenarios.get(i);
            String featureName = this.featureNameTextOptimizer.optimizeText(this.textSanitizer.sanitizeText(scenario.getFeature().getName()));
            String scenarioName = this.scenarioNameTextOptimizer.optimizeText(this.textSanitizer.sanitizeText(scenario.getName()));
            myTableBuilder.addRow(Row.builder().font(NAME_FONT).fontSize(Integer.valueOf(10)).height(Float.valueOf(22.0f)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.MIDDLE).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(sNo)).fontSize(Integer.valueOf(8))).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(featureName).horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(scenarioName).horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(scenario.getTotalSteps())).textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(scenario.getPassedSteps())).textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(scenario.getFailedSteps())).textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(scenario.getSkippedSteps())).textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(DateUtil.durationValue(scenario.calculatedDuration())).textColor(this.reportConfig.getFeatureConfig().durationColor())).horizontalAlignment(HorizontalAlignment.LEFT)).build()).build());
            ++sNo;
            ++i;
        }
        Table myTable = myTableBuilder.build();
        TableDrawer tableDrawer = TableDrawer.builder().contentStream(this.content).startX(50.0f).startY(440.0f).table(myTable).build();
        tableDrawer.draw();
    }

    @Override
    public void createAnnotationLinks() {
        int yCoord = 398;
        ScenarioData scenarioData = (ScenarioData)this.displayData;
        List<Scenario> scenarios = scenarioData.getScenarios();
        int i = 0;
        while (i < scenarios.size()) {
            Feature feature = scenarios.get(i).getFeature();
            Annotation annotation = Annotation.builder().title(feature.getName()).xBottom(80).yBottom(yCoord).width(this.featureNameTextOptimizer.optimizedTextWidth(feature.getName())).height(18).build();
            PDAnnotationLink annotationLink = annotation.createPDAnnotationLink();
            feature.getAnnotations().add(annotationLink);
            try {
                this.page.getAnnotations().add(annotationLink);
            }
            catch (IOException e) {
                throw new PdfReportException(e);
            }
            annotation = Annotation.builder().title(scenarios.get(i).getName()).xBottom(190).yBottom(yCoord).width(this.scenarioNameTextOptimizer.optimizedTextWidth(scenarios.get(i).getName())).height(15).build();
            annotationLink = annotation.createPDAnnotationLink();
            scenarios.get(i).getAnnotations().add(annotationLink);
            try {
                this.page.getAnnotations().add(annotationLink);
            }
            catch (IOException e) {
                throw new PdfReportException(e);
            }
            yCoord -= 22;
            ++i;
        }
    }

    protected ScenarioStepDetails(ScenarioStepDetailsBuilder<?, ?> b) {
        super(b);
        this.paginationData = ((ScenarioStepDetailsBuilder)b).paginationData;
    }

    public static ScenarioStepDetailsBuilder<?, ?> builder() {
        return new ScenarioStepDetailsBuilderImpl();
    }

    public PaginationData getPaginationData() {
        return this.paginationData;
    }

    public TextLengthOptimizer getFeatureNameTextOptimizer() {
        return this.featureNameTextOptimizer;
    }

    public TextLengthOptimizer getScenarioNameTextOptimizer() {
        return this.scenarioNameTextOptimizer;
    }

    public TextContentSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public void setPaginationData(PaginationData paginationData) {
        this.paginationData = paginationData;
    }

    @Override
    public String toString() {
        return "ScenarioStepDetails(paginationData=" + this.getPaginationData() + ", featureNameTextOptimizer=" + this.getFeatureNameTextOptimizer() + ", scenarioNameTextOptimizer=" + this.getScenarioNameTextOptimizer() + ", textSanitizer=" + this.getTextSanitizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScenarioStepDetails)) {
            return false;
        }
        ScenarioStepDetails other = (ScenarioStepDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PaginationData this$paginationData = this.getPaginationData();
        PaginationData other$paginationData = other.getPaginationData();
        if (this$paginationData == null ? other$paginationData != null : !((Object)this$paginationData).equals(other$paginationData)) {
            return false;
        }
        TextLengthOptimizer this$featureNameTextOptimizer = this.getFeatureNameTextOptimizer();
        TextLengthOptimizer other$featureNameTextOptimizer = other.getFeatureNameTextOptimizer();
        if (this$featureNameTextOptimizer == null ? other$featureNameTextOptimizer != null : !((Object)this$featureNameTextOptimizer).equals(other$featureNameTextOptimizer)) {
            return false;
        }
        TextLengthOptimizer this$scenarioNameTextOptimizer = this.getScenarioNameTextOptimizer();
        TextLengthOptimizer other$scenarioNameTextOptimizer = other.getScenarioNameTextOptimizer();
        if (this$scenarioNameTextOptimizer == null ? other$scenarioNameTextOptimizer != null : !((Object)this$scenarioNameTextOptimizer).equals(other$scenarioNameTextOptimizer)) {
            return false;
        }
        TextContentSanitizer this$textSanitizer = this.getTextSanitizer();
        TextContentSanitizer other$textSanitizer = other.getTextSanitizer();
        return !(this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScenarioStepDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PaginationData $paginationData = this.getPaginationData();
        result = result * 59 + ($paginationData == null ? 43 : ((Object)$paginationData).hashCode());
        TextLengthOptimizer $featureNameTextOptimizer = this.getFeatureNameTextOptimizer();
        result = result * 59 + ($featureNameTextOptimizer == null ? 43 : ((Object)$featureNameTextOptimizer).hashCode());
        TextLengthOptimizer $scenarioNameTextOptimizer = this.getScenarioNameTextOptimizer();
        result = result * 59 + ($scenarioNameTextOptimizer == null ? 43 : ((Object)$scenarioNameTextOptimizer).hashCode());
        TextContentSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        return result;
    }

    public static abstract class ScenarioStepDetailsBuilder<C extends ScenarioStepDetails, B extends ScenarioStepDetailsBuilder<C, B>>
    extends Component.ComponentBuilder<C, B> {
        private PaginationData paginationData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B paginationData(PaginationData paginationData) {
            this.paginationData = paginationData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScenarioStepDetails.ScenarioStepDetailsBuilder(super=" + super.toString() + ", paginationData=" + this.paginationData + ")";
        }
    }

    private static final class ScenarioStepDetailsBuilderImpl
    extends ScenarioStepDetailsBuilder<ScenarioStepDetails, ScenarioStepDetailsBuilderImpl> {
        private ScenarioStepDetailsBuilderImpl() {
        }

        @Override
        protected ScenarioStepDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public ScenarioStepDetails build() {
            return new ScenarioStepDetails(this);
        }
    }
}

