/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chapter.summary;

import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.DialStyler;
import tech.grasshopper.pdf.component.chart.ChartComponent;
import tech.grasshopper.pdf.component.chart.ChartDisplayer;
import tech.grasshopper.pdf.component.chart.ReportDialChart;
import tech.grasshopper.pdf.data.SummaryData;
import tech.grasshopper.pdf.util.NumberUtil;

public class SummaryDialCharts
extends ChartComponent {
    private SummaryData summaryData;

    @Override
    public void display() {
        this.summaryData = (SummaryData)this.displayData;
        this.createFeaturesDialChart();
        this.createScenariosDialChart();
        this.createStepsDialChart();
    }

    private void createFeaturesDialChart() {
        double dialValue = NumberUtil.divideAndRound(this.summaryData.getPassedFeatures(), this.summaryData.getTotalFeatures());
        int dialDisplay = NumberUtil.divideToPercent(this.summaryData.getPassedFeatures(), this.summaryData.getTotalFeatures());
        double[] featureRange = this.reportConfig.getSummaryConfig().getDial().featureRange();
        this.createDialChart(dialValue, dialDisplay, 40.0f, featureRange);
    }

    private void createScenariosDialChart() {
        double dialValue = NumberUtil.divideAndRound(this.summaryData.getPassedScenarios(), this.summaryData.getTotalScenarios());
        int dialDisplay = NumberUtil.divideToPercent(this.summaryData.getPassedScenarios(), this.summaryData.getTotalScenarios());
        double[] scenarioRange = this.reportConfig.getSummaryConfig().getDial().scenarioRange();
        this.createDialChart(dialValue, dialDisplay, 220.0f, scenarioRange);
    }

    private void createStepsDialChart() {
        double dialValue = NumberUtil.divideAndRound(this.summaryData.getPassedSteps(), this.summaryData.getTotalSteps());
        int dialDisplay = NumberUtil.divideToPercent(this.summaryData.getPassedSteps(), this.summaryData.getTotalSteps());
        double[] stepRange = this.reportConfig.getSummaryConfig().getDial().stepRange();
        this.createDialChart(dialValue, dialDisplay, 400.0f, stepRange);
    }

    private void createDialChart(double dialValue, int dialDisplay, float xOffset, double[] range) {
        ReportDialChart chart = new ReportDialChart(160, 160);
        this.updateChartStyler((DialStyler)chart.getStyler(), range);
        chart.updateData("Pass %", dialValue, dialDisplay);
        ((ChartDisplayer)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)ChartDisplayer.builder().document(this.document)).content(this.content)).chart((Chart<?, ?>)chart)).xBottomLeft(xOffset)).yBottomLeft(130.0f)).build()).display();
    }

    private void updateChartStyler(DialStyler styler, double[] range) {
        styler.setGreenColor(this.reportConfig.getSummaryConfig().getDial().badColor());
        styler.setGreenFrom(0.0);
        styler.setGreenTo(range[0]);
        styler.setNormalColor(this.reportConfig.getSummaryConfig().getDial().averageColor());
        styler.setNormalFrom(range[0]);
        styler.setNormalTo(range[1]);
        styler.setRedColor(this.reportConfig.getSummaryConfig().getDial().goodColor());
        styler.setRedFrom(range[1]);
        styler.setRedTo(1.0);
    }

    protected SummaryDialCharts(SummaryDialChartsBuilder<?, ?> b) {
        super((ChartComponent.ChartComponentBuilder<?, ?>)b);
        this.summaryData = ((SummaryDialChartsBuilder)b).summaryData;
    }

    public static SummaryDialChartsBuilder<?, ?> builder() {
        return new SummaryDialChartsBuilderImpl();
    }

    public SummaryData getSummaryData() {
        return this.summaryData;
    }

    public void setSummaryData(SummaryData summaryData) {
        this.summaryData = summaryData;
    }

    @Override
    public String toString() {
        return "SummaryDialCharts(summaryData=" + this.getSummaryData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryDialCharts)) {
            return false;
        }
        SummaryDialCharts other = (SummaryDialCharts)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SummaryData this$summaryData = this.getSummaryData();
        SummaryData other$summaryData = other.getSummaryData();
        return !(this$summaryData == null ? other$summaryData != null : !((Object)this$summaryData).equals(other$summaryData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SummaryDialCharts;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SummaryData $summaryData = this.getSummaryData();
        result = result * 59 + ($summaryData == null ? 43 : ((Object)$summaryData).hashCode());
        return result;
    }

    public static abstract class SummaryDialChartsBuilder<C extends SummaryDialCharts, B extends SummaryDialChartsBuilder<C, B>>
    extends ChartComponent.ChartComponentBuilder<C, B> {
        private SummaryData summaryData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B summaryData(SummaryData summaryData) {
            this.summaryData = summaryData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SummaryDialCharts.SummaryDialChartsBuilder(super=" + super.toString() + ", summaryData=" + this.summaryData + ")";
        }
    }

    private static final class SummaryDialChartsBuilderImpl
    extends SummaryDialChartsBuilder<SummaryDialCharts, SummaryDialChartsBuilderImpl> {
        private SummaryDialChartsBuilderImpl() {
        }

        @Override
        protected SummaryDialChartsBuilderImpl self() {
            return this;
        }

        @Override
        public SummaryDialCharts build() {
            return new SummaryDialCharts(this);
        }
    }
}

