/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.component;

import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.data.DisplayData;

public abstract class Component {
    protected PDPageContentStream content;
    protected DisplayData displayData;
    protected ReportConfig reportConfig;
    protected PDPage page;

    public abstract void display();

    protected Component(ComponentBuilder<?, ?> b) {
        this.content = ((ComponentBuilder)b).content;
        this.displayData = ((ComponentBuilder)b).displayData;
        this.reportConfig = ((ComponentBuilder)b).reportConfig;
        this.page = ((ComponentBuilder)b).page;
    }

    public PDPageContentStream getContent() {
        return this.content;
    }

    public DisplayData getDisplayData() {
        return this.displayData;
    }

    public ReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public PDPage getPage() {
        return this.page;
    }

    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public void setDisplayData(DisplayData displayData) {
        this.displayData = displayData;
    }

    public void setReportConfig(ReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    public void setPage(PDPage page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Component)) {
            return false;
        }
        Component other = (Component)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDPageContentStream this$content = this.getContent();
        PDPageContentStream other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        DisplayData this$displayData = this.getDisplayData();
        DisplayData other$displayData = other.getDisplayData();
        if (this$displayData == null ? other$displayData != null : !this$displayData.equals(other$displayData)) {
            return false;
        }
        ReportConfig this$reportConfig = this.getReportConfig();
        ReportConfig other$reportConfig = other.getReportConfig();
        if (this$reportConfig == null ? other$reportConfig != null : !((Object)this$reportConfig).equals(other$reportConfig)) {
            return false;
        }
        PDPage this$page = this.getPage();
        PDPage other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Component;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDPageContentStream $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        DisplayData $displayData = this.getDisplayData();
        result = result * 59 + ($displayData == null ? 43 : $displayData.hashCode());
        ReportConfig $reportConfig = this.getReportConfig();
        result = result * 59 + ($reportConfig == null ? 43 : ((Object)$reportConfig).hashCode());
        PDPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public String toString() {
        return "Component(content=" + this.getContent() + ", displayData=" + this.getDisplayData() + ", reportConfig=" + this.getReportConfig() + ", page=" + this.getPage() + ")";
    }

    public static abstract class ComponentBuilder<C extends Component, B extends ComponentBuilder<C, B>> {
        private PDPageContentStream content;
        private DisplayData displayData;
        private ReportConfig reportConfig;
        private PDPage page;

        protected abstract B self();

        public abstract C build();

        public B content(PDPageContentStream content) {
            this.content = content;
            return this.self();
        }

        public B displayData(DisplayData displayData) {
            this.displayData = displayData;
            return this.self();
        }

        public B reportConfig(ReportConfig reportConfig) {
            this.reportConfig = reportConfig;
            return this.self();
        }

        public B page(PDPage page) {
            this.page = page;
            return this.self();
        }

        public String toString() {
            return "Component.ComponentBuilder(content=" + this.content + ", displayData=" + this.displayData + ", reportConfig=" + this.reportConfig + ", page=" + this.page + ")";
        }
    }
}

