/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.component.decorator;

import java.awt.Color;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.component.ComponentDecorator;
import tech.grasshopper.pdf.exception.PdfReportException;

public class BackgroundDecorator
extends ComponentDecorator {
    private static final Logger logger = Logger.getLogger(BackgroundDecorator.class.getName());
    private Component component;
    private PDPageContentStream content;
    private Color containerColor;
    private float xContainerBottomLeft;
    private float yContainerBottomLeft;
    private float containerWidth;
    private float containerHeight;

    @Override
    public void display() {
        try {
            this.content.setNonStrokingColor(this.containerColor);
            this.content.addRect(this.xContainerBottomLeft, this.yContainerBottomLeft, this.containerWidth, this.containerHeight);
            this.content.fill();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
        this.component.display();
    }

    private static Color $default$containerColor() {
        return Color.LIGHT_GRAY;
    }

    protected BackgroundDecorator(BackgroundDecoratorBuilder<?, ?> b) {
        super((ComponentDecorator.ComponentDecoratorBuilder<?, ?>)b);
        this.component = ((BackgroundDecoratorBuilder)b).component;
        this.content = ((BackgroundDecoratorBuilder)b).content;
        this.containerColor = ((BackgroundDecoratorBuilder)b).containerColor$set ? ((BackgroundDecoratorBuilder)b).containerColor : BackgroundDecorator.$default$containerColor();
        this.xContainerBottomLeft = ((BackgroundDecoratorBuilder)b).xContainerBottomLeft;
        this.yContainerBottomLeft = ((BackgroundDecoratorBuilder)b).yContainerBottomLeft;
        this.containerWidth = ((BackgroundDecoratorBuilder)b).containerWidth;
        this.containerHeight = ((BackgroundDecoratorBuilder)b).containerHeight;
    }

    public static BackgroundDecoratorBuilder<?, ?> builder() {
        return new BackgroundDecoratorBuilderImpl();
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public PDPageContentStream getContent() {
        return this.content;
    }

    public Color getContainerColor() {
        return this.containerColor;
    }

    public float getXContainerBottomLeft() {
        return this.xContainerBottomLeft;
    }

    public float getYContainerBottomLeft() {
        return this.yContainerBottomLeft;
    }

    public float getContainerWidth() {
        return this.containerWidth;
    }

    public float getContainerHeight() {
        return this.containerHeight;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public void setContainerColor(Color containerColor) {
        this.containerColor = containerColor;
    }

    public void setXContainerBottomLeft(float xContainerBottomLeft) {
        this.xContainerBottomLeft = xContainerBottomLeft;
    }

    public void setYContainerBottomLeft(float yContainerBottomLeft) {
        this.yContainerBottomLeft = yContainerBottomLeft;
    }

    public void setContainerWidth(float containerWidth) {
        this.containerWidth = containerWidth;
    }

    public void setContainerHeight(float containerHeight) {
        this.containerHeight = containerHeight;
    }

    @Override
    public String toString() {
        return "BackgroundDecorator(component=" + this.getComponent() + ", content=" + this.getContent() + ", containerColor=" + this.getContainerColor() + ", xContainerBottomLeft=" + this.getXContainerBottomLeft() + ", yContainerBottomLeft=" + this.getYContainerBottomLeft() + ", containerWidth=" + this.getContainerWidth() + ", containerHeight=" + this.getContainerHeight() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BackgroundDecorator)) {
            return false;
        }
        BackgroundDecorator other = (BackgroundDecorator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Component this$component = this.getComponent();
        Component other$component = other.getComponent();
        if (this$component == null ? other$component != null : !((Object)this$component).equals(other$component)) {
            return false;
        }
        PDPageContentStream this$content = this.getContent();
        PDPageContentStream other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Color this$containerColor = this.getContainerColor();
        Color other$containerColor = other.getContainerColor();
        if (this$containerColor == null ? other$containerColor != null : !((Object)this$containerColor).equals(other$containerColor)) {
            return false;
        }
        if (Float.compare(this.getXContainerBottomLeft(), other.getXContainerBottomLeft()) != 0) {
            return false;
        }
        if (Float.compare(this.getYContainerBottomLeft(), other.getYContainerBottomLeft()) != 0) {
            return false;
        }
        if (Float.compare(this.getContainerWidth(), other.getContainerWidth()) != 0) {
            return false;
        }
        return Float.compare(this.getContainerHeight(), other.getContainerHeight()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BackgroundDecorator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Component $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : ((Object)$component).hashCode());
        PDPageContentStream $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Color $containerColor = this.getContainerColor();
        result = result * 59 + ($containerColor == null ? 43 : ((Object)$containerColor).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getXContainerBottomLeft());
        result = result * 59 + Float.floatToIntBits(this.getYContainerBottomLeft());
        result = result * 59 + Float.floatToIntBits(this.getContainerWidth());
        result = result * 59 + Float.floatToIntBits(this.getContainerHeight());
        return result;
    }

    public static abstract class BackgroundDecoratorBuilder<C extends BackgroundDecorator, B extends BackgroundDecoratorBuilder<C, B>>
    extends ComponentDecorator.ComponentDecoratorBuilder<C, B> {
        private Component component;
        private PDPageContentStream content;
        private Color containerColor;
        private boolean containerColor$set;
        private float xContainerBottomLeft;
        private float yContainerBottomLeft;
        private float containerWidth;
        private float containerHeight;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B component(Component component) {
            this.component = component;
            return (B)this.self();
        }

        @Override
        public B content(PDPageContentStream content) {
            this.content = content;
            return (B)this.self();
        }

        public B containerColor(Color containerColor) {
            this.containerColor = containerColor;
            this.containerColor$set = true;
            return (B)this.self();
        }

        public B xContainerBottomLeft(float xContainerBottomLeft) {
            this.xContainerBottomLeft = xContainerBottomLeft;
            return (B)this.self();
        }

        public B yContainerBottomLeft(float yContainerBottomLeft) {
            this.yContainerBottomLeft = yContainerBottomLeft;
            return (B)this.self();
        }

        public B containerWidth(float containerWidth) {
            this.containerWidth = containerWidth;
            return (B)this.self();
        }

        public B containerHeight(float containerHeight) {
            this.containerHeight = containerHeight;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BackgroundDecorator.BackgroundDecoratorBuilder(super=" + super.toString() + ", component=" + this.component + ", content=" + this.content + ", containerColor=" + this.containerColor + ", xContainerBottomLeft=" + this.xContainerBottomLeft + ", yContainerBottomLeft=" + this.yContainerBottomLeft + ", containerWidth=" + this.containerWidth + ", containerHeight=" + this.containerHeight + ")";
        }
    }

    private static final class BackgroundDecoratorBuilderImpl
    extends BackgroundDecoratorBuilder<BackgroundDecorator, BackgroundDecoratorBuilderImpl> {
        private BackgroundDecoratorBuilderImpl() {
        }

        @Override
        protected BackgroundDecoratorBuilderImpl self() {
            return this;
        }

        @Override
        public BackgroundDecorator build() {
            return new BackgroundDecorator(this);
        }
    }
}

