/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.component.line;

import java.awt.Color;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.exception.PdfReportException;

public class HorizontalLineComponent
extends Component {
    private static final Logger logger = Logger.getLogger(HorizontalLineComponent.class.getName());
    private Color color;
    private int yCord;
    private int xStartCord;
    private int xEndCord;

    @Override
    public void display() {
        try {
            this.content.setStrokingColor(this.color);
            this.content.moveTo((float)this.xStartCord, (float)this.yCord);
            this.content.lineTo((float)this.xEndCord, (float)this.yCord);
            this.content.stroke();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
    }

    private static Color $default$color() {
        return Color.BLACK;
    }

    protected HorizontalLineComponent(HorizontalLineComponentBuilder<?, ?> b) {
        super(b);
        this.color = ((HorizontalLineComponentBuilder)b).color$set ? ((HorizontalLineComponentBuilder)b).color : HorizontalLineComponent.$default$color();
        this.yCord = ((HorizontalLineComponentBuilder)b).yCord;
        this.xStartCord = ((HorizontalLineComponentBuilder)b).xStartCord;
        this.xEndCord = ((HorizontalLineComponentBuilder)b).xEndCord;
    }

    public static HorizontalLineComponentBuilder<?, ?> builder() {
        return new HorizontalLineComponentBuilderImpl();
    }

    public Color getColor() {
        return this.color;
    }

    public int getYCord() {
        return this.yCord;
    }

    public int getXStartCord() {
        return this.xStartCord;
    }

    public int getXEndCord() {
        return this.xEndCord;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setYCord(int yCord) {
        this.yCord = yCord;
    }

    public void setXStartCord(int xStartCord) {
        this.xStartCord = xStartCord;
    }

    public void setXEndCord(int xEndCord) {
        this.xEndCord = xEndCord;
    }

    @Override
    public String toString() {
        return "HorizontalLineComponent(color=" + this.getColor() + ", yCord=" + this.getYCord() + ", xStartCord=" + this.getXStartCord() + ", xEndCord=" + this.getXEndCord() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HorizontalLineComponent)) {
            return false;
        }
        HorizontalLineComponent other = (HorizontalLineComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        if (this.getYCord() != other.getYCord()) {
            return false;
        }
        if (this.getXStartCord() != other.getXStartCord()) {
            return false;
        }
        return this.getXEndCord() == other.getXEndCord();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HorizontalLineComponent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        result = result * 59 + this.getYCord();
        result = result * 59 + this.getXStartCord();
        result = result * 59 + this.getXEndCord();
        return result;
    }

    public static abstract class HorizontalLineComponentBuilder<C extends HorizontalLineComponent, B extends HorizontalLineComponentBuilder<C, B>>
    extends Component.ComponentBuilder<C, B> {
        private Color color;
        private boolean color$set;
        private int yCord;
        private int xStartCord;
        private int xEndCord;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B color(Color color) {
            this.color = color;
            this.color$set = true;
            return (B)this.self();
        }

        public B yCord(int yCord) {
            this.yCord = yCord;
            return (B)this.self();
        }

        public B xStartCord(int xStartCord) {
            this.xStartCord = xStartCord;
            return (B)this.self();
        }

        public B xEndCord(int xEndCord) {
            this.xEndCord = xEndCord;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HorizontalLineComponent.HorizontalLineComponentBuilder(super=" + super.toString() + ", color=" + this.color + ", yCord=" + this.yCord + ", xStartCord=" + this.xStartCord + ", xEndCord=" + this.xEndCord + ")";
        }
    }

    private static final class HorizontalLineComponentBuilderImpl
    extends HorizontalLineComponentBuilder<HorizontalLineComponent, HorizontalLineComponentBuilderImpl> {
        private HorizontalLineComponentBuilderImpl() {
        }

        @Override
        protected HorizontalLineComponentBuilderImpl self() {
            return this;
        }

        @Override
        public HorizontalLineComponent build() {
            return new HorizontalLineComponent(this);
        }
    }
}

