/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.component.text;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.grasshopper.pdf.component.Component;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.report.Text;

public class TextComponent
extends Component {
    private static final Logger logger = Logger.getLogger(TextComponent.class.getName());
    private Text text;

    @Override
    public void display() {
        try {
            this.content.beginText();
            this.content.setNonStrokingColor(this.text.getTextColor());
            this.content.setFont(this.text.getFont(), this.text.getFontSize());
            this.content.newLineAtOffset(this.text.getXoffset(), this.text.getYoffset());
            this.content.showText(this.text.getText());
            this.content.endText();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
    }

    protected TextComponent(TextComponentBuilder<?, ?> b) {
        super(b);
        this.text = ((TextComponentBuilder)b).text;
    }

    public static TextComponentBuilder<?, ?> builder() {
        return new TextComponentBuilderImpl();
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return "TextComponent(text=" + this.getText() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextComponent)) {
            return false;
        }
        TextComponent other = (TextComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Text this$text = this.getText();
        Text other$text = other.getText();
        return !(this$text == null ? other$text != null : !((Object)this$text).equals(other$text));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextComponent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Text $text = this.getText();
        result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
        return result;
    }

    public static abstract class TextComponentBuilder<C extends TextComponent, B extends TextComponentBuilder<C, B>>
    extends Component.ComponentBuilder<C, B> {
        private Text text;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B text(Text text) {
            this.text = text;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TextComponent.TextComponentBuilder(super=" + super.toString() + ", text=" + this.text + ")";
        }
    }

    private static final class TextComponentBuilderImpl
    extends TextComponentBuilder<TextComponent, TextComponentBuilderImpl> {
        private TextComponentBuilderImpl() {
        }

        @Override
        protected TextComponentBuilderImpl self() {
            return this;
        }

        @Override
        public TextComponent build() {
            return new TextComponent(this);
        }
    }
}

