/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.optimizer;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;
import tech.grasshopper.pdf.exception.PdfReportException;

public class TextLengthOptimizer {
    private PDFont font;
    private int fontsize;
    private int spaceWidth;

    public int textWidth(String text) {
        int width = 0;
        try {
            width = (int)(this.font.getStringWidth(text) * (float)this.fontsize) / 1000;
        }
        catch (IOException e) {
            throw new PdfReportException(e);
        }
        return width;
    }

    public int optimizedTextWidth(String text) {
        int width = 0;
        try {
            width = (int)(this.font.getStringWidth(this.optimizeText(text)) * (float)this.fontsize) / 1000;
        }
        catch (IOException e) {
            throw new PdfReportException(e);
        }
        return width;
    }

    public boolean doesTextFitInSpace(String text) {
        try {
            return !(this.font.getStringWidth(text) * (float)this.fontsize / 1000.0f > (float)this.spaceWidth);
        }
        catch (IOException e) {
            throw new PdfReportException(e);
        }
    }

    public String optimizeText(String text) {
        if (this.doesTextFitInSpace(text)) {
            return text;
        }
        text = text.substring(0, text.length() - 3);
        while (!this.doesTextFitInSpace(String.valueOf(text) + "...")) {
            text = text.substring(0, text.length() - 1);
        }
        return String.valueOf(text) + "...";
    }

    public String optimizeDataCellText(String text) {
        if (this.doesTextFitInSpace(text)) {
            while (this.doesTextFitInSpace(text)) {
                text = String.valueOf(text) + " ";
            }
            return text.substring(0, text.length() - 2);
        }
        return this.optimizeText(text);
    }

    public static String optimizeOutlineText(String text) {
        return TextLengthOptimizer.optimizeTextLength(text, 50);
    }

    private static String optimizeTextLength(String text, int length) {
        if (text.length() > length) {
            return String.valueOf(text.substring(0, length - 3)) + "...";
        }
        return text;
    }

    TextLengthOptimizer(PDFont font, int fontsize, int spaceWidth) {
        this.font = font;
        this.fontsize = fontsize;
        this.spaceWidth = spaceWidth;
    }

    public static TextLengthOptimizerBuilder builder() {
        return new TextLengthOptimizerBuilder();
    }

    public PDFont getFont() {
        return this.font;
    }

    public int getFontsize() {
        return this.fontsize;
    }

    public int getSpaceWidth() {
        return this.spaceWidth;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontsize(int fontsize) {
        this.fontsize = fontsize;
    }

    public void setSpaceWidth(int spaceWidth) {
        this.spaceWidth = spaceWidth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextLengthOptimizer)) {
            return false;
        }
        TextLengthOptimizer other = (TextLengthOptimizer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        if (this.getFontsize() != other.getFontsize()) {
            return false;
        }
        return this.getSpaceWidth() == other.getSpaceWidth();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextLengthOptimizer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        result = result * 59 + this.getFontsize();
        result = result * 59 + this.getSpaceWidth();
        return result;
    }

    public String toString() {
        return "TextLengthOptimizer(font=" + this.getFont() + ", fontsize=" + this.getFontsize() + ", spaceWidth=" + this.getSpaceWidth() + ")";
    }

    public static class TextLengthOptimizerBuilder {
        private PDFont font;
        private int fontsize;
        private int spaceWidth;

        TextLengthOptimizerBuilder() {
        }

        public TextLengthOptimizerBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public TextLengthOptimizerBuilder fontsize(int fontsize) {
            this.fontsize = fontsize;
            return this;
        }

        public TextLengthOptimizerBuilder spaceWidth(int spaceWidth) {
            this.spaceWidth = spaceWidth;
            return this;
        }

        public TextLengthOptimizer build() {
            return new TextLengthOptimizer(this.font, this.fontsize, this.spaceWidth);
        }

        public String toString() {
            return "TextLengthOptimizer.TextLengthOptimizerBuilder(font=" + this.font + ", fontsize=" + this.fontsize + ", spaceWidth=" + this.spaceWidth + ")";
        }
    }
}

